/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.theme.vanilla.delegate;

import com.github.franckyi.guapi.api.node.TextField;
import com.github.franckyi.guapi.base.theme.vanilla.delegate.VanillaWidgetSkinDelegate;
import com.github.franckyi.ibeeditor.mixin.EditBoxMixin;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;

public class VanillaTextFieldSkinDelegate<N extends TextField>
extends class_342
implements VanillaWidgetSkinDelegate {
    private final N node;
    private final EditBoxMixin self;

    public VanillaTextFieldSkinDelegate(N node) {
        super(class_310.method_1551().field_1772, node.getX(), node.getY(), node.getWidth(), node.getHeight(), node.getLabel());
        this.node = node;
        this.self = (EditBoxMixin)((Object)this);
        this.field_22763 = !node.isDisabled();
        this.method_1880(node.getMaxLength());
        this.method_1852(node.getText());
        this.method_25365(node.isFocused());
        this.method_1863(arg_0 -> node.setText(arg_0));
        node.xProperty().addListener(newVal -> this.method_46421(newVal + 1));
        node.yProperty().addListener(newVal -> this.method_46419(newVal + 1));
        node.widthProperty().addListener(newVal -> this.method_25358(newVal - 2));
        node.heightProperty().addListener(newVal -> {
            this.field_22759 = newVal - 2;
        });
        node.disabledProperty().addListener(newVal -> {
            this.field_22763 = newVal == false;
        });
        node.labelProperty().addListener(arg_0 -> ((VanillaTextFieldSkinDelegate)this).method_25355(arg_0));
        node.maxLengthProperty().addListener(arg_0 -> ((VanillaTextFieldSkinDelegate)this).method_1880(arg_0));
        node.textProperty().addListener(this::updateText);
        node.focusedProperty().addListener(x$0 -> this.method_25365((boolean)x$0));
        node.validatorProperty().addListener(this::updateValidator);
        node.validationForcedProperty().addListener(this::updateValidator);
        node.textRendererProperty().addListener(this::updateRenderer);
        node.cursorPositionProperty().addListener(x$0 -> super.method_1875(x$0));
        node.highlightPositionProperty().addListener(x$0 -> super.method_1884(x$0));
        node.placeholderProperty().addListener(this::updatePlaceholder);
        node.textProperty().addListener(this::updatePlaceholder);
        this.method_1870();
        this.updateValidator();
        this.updateRenderer();
        this.updatePlaceholder();
    }

    private void updateText(String text) {
        if (this.node.getValidator().test(text)) {
            if (text.length() > this.node.getMaxLength()) {
                this.self.setRawValue(text.substring(0, this.node.getMaxLength()));
            } else {
                this.self.setRawValue(text);
            }
        }
    }

    private void updateValidator() {
        if (this.node.isValidationForced()) {
            if (this.node.getValidator() == null) {
                this.method_1890(Objects::nonNull);
            } else {
                this.method_1890(this.node.getValidator());
            }
        } else {
            this.method_1890(Objects::nonNull);
        }
    }

    private void updateRenderer() {
        if (this.node.getTextRenderer() == null) {
            this.method_1854((string, integer) -> class_5481.method_30747((String)string, (class_2583)class_2583.field_24360));
        } else {
            this.method_1854((string, integer) -> this.renderText((String)string, (int)integer).method_30937());
        }
        this.method_1870();
    }

    private void updatePlaceholder() {
        this.method_1887(this.method_1882().isEmpty() ? this.node.getPlaceholder().getString() : null);
    }

    public class_2561 renderText(String str, int firstCharacterIndex) {
        return this.node.getTextRenderer() == null ? class_2561.method_43470((String)str) : this.node.getTextRenderer().render(str, firstCharacterIndex);
    }

    @Override
    public void doTick() {
        this.method_1865();
    }

    public void method_1875(int value) {
        super.method_1875(value);
        this.node.setCursorPosition(this.method_1881());
        if (this.method_1881() < this.self.getDisplayPos()) {
            this.self.setDisplayPos(this.method_1881());
        }
    }

    public void method_1884(int value) {
        super.method_1884(value);
        this.node.setHighlightPosition(this.self.getHighlightPos());
    }

    public void method_1867(@NotNull String string) {
        int oldCursorPos = this.method_1881();
        int oldHighlightPos = this.node.getHighlightPosition();
        String oldText = this.method_1882();
        super.method_1867(string);
        this.node.onTextUpdate(oldCursorPos, oldHighlightPos, oldText, this.method_1881(), this.method_1882());
    }

    public void method_1878(int characterOffset) {
        if (this.method_1866().isEmpty()) {
            int oldCursorPos = this.method_1881();
            int oldHighlightPos = this.node.getHighlightPosition();
            String oldText = this.method_1882();
            super.method_1878(characterOffset);
            this.node.onTextUpdate(oldCursorPos, oldHighlightPos, oldText, this.method_1881(), this.method_1882());
        } else {
            super.method_1878(characterOffset);
        }
    }

    protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.self.setShiftPressed(false);
        int displayPos = this.self.getDisplayPos();
        class_327 font = class_310.method_1551().field_1772;
        class_5348 string = font.method_1714((class_5348)this.renderText(this.method_1882().substring(displayPos), displayPos), this.method_1859());
        this.method_1884(font.method_1714(string, class_3532.method_15357((double)mouseX) - this.method_46426() - 4).getString().length() + displayPos);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean flag;
        class_327 font = class_310.method_1551().field_1772;
        if (!this.method_1885()) {
            return false;
        }
        boolean bl = flag = mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
        if (this.self.canLoseFocus() && button == 0) {
            this.method_1876(flag);
        }
        if (this.method_25370() && flag && button == 0) {
            int i = class_3532.method_15357((double)mouseX) - this.method_46426();
            if (this.self.isBordered()) {
                i -= 4;
            }
            class_5348 string = font.method_1714((class_5348)this.renderText(this.method_1882().substring(this.self.getDisplayPos()), this.self.getDisplayPos()), this.method_1859());
            this.method_1883(font.method_1714(string, i).getString().length() + this.self.getDisplayPos());
            return true;
        }
        return false;
    }

    public void method_25359(@NotNull class_4587 matrices, int mouseX, int mouseY, float delta) {
        class_327 font = class_310.method_1551().field_1772;
        if (this.method_1885()) {
            if (this.self.isBordered()) {
                int i = this.method_25370() ? -1 : -6250336;
                VanillaTextFieldSkinDelegate.method_25294((class_4587)matrices, (int)(this.method_46426() - 1), (int)(this.method_46427() - 1), (int)(this.method_46426() + this.field_22758 + 1), (int)(this.method_46427() + this.field_22759 + 1), (int)i);
                VanillaTextFieldSkinDelegate.method_25294((class_4587)matrices, (int)this.method_46426(), (int)this.method_46427(), (int)(this.method_46426() + this.field_22758), (int)(this.method_46427() + this.field_22759), (int)-16777216);
            }
            int i2 = this.self.isEditable() ? this.self.getTextColor() : this.self.getTextColorUneditable();
            int j = this.self.getCursorPos() - this.self.getDisplayPos();
            int k = this.self.getHighlightPos() - this.self.getDisplayPos();
            class_2561 renderedText = this.renderText(this.method_1882().substring(this.self.getDisplayPos()), this.self.getDisplayPos());
            String s = renderedText != null ? font.method_1714((class_5348)renderedText, this.method_1859()).getString() : font.method_27523(this.method_1882().substring(this.self.getDisplayPos()), this.method_1859());
            boolean flag = j >= 0 && j <= s.length();
            boolean flag1 = this.method_25370() && this.self.getFrame() / 6 % 2 == 0 && flag;
            int l = this.self.isBordered() ? this.method_46426() + 4 : this.method_46426();
            int i1 = this.self.isBordered() ? this.method_46427() + (this.field_22759 - 8) / 2 : this.method_46427();
            int j1 = l;
            if (k > s.length()) {
                k = s.length();
            }
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 = font.method_27517(matrices, this.self.getFormatter().apply(s1, this.self.getDisplayPos()), (float)l, (float)i1, i2);
            }
            boolean flag2 = this.self.getCursorPos() < this.method_1882().length() || this.method_1882().length() >= this.self.invokeGetMaxLength();
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + this.field_22758 : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            if (!s.isEmpty() && flag && j < s.length()) {
                font.method_27517(matrices, this.self.getFormatter().apply(s.substring(j), this.self.getCursorPos()), (float)j1, (float)i1, i2);
            }
            if (!flag2 && this.self.getSuggestion() != null) {
                font.method_1720(matrices, this.self.getSuggestion(), (float)(k1 - 1), (float)i1, -8355712);
            }
            if (flag1) {
                if (flag2) {
                    VanillaTextFieldSkinDelegate.method_25294((class_4587)matrices, (int)k1, (int)(i1 - 1), (int)(k1 + 1), (int)(i1 + 1 + 9), (int)-3092272);
                } else {
                    font.method_1720(matrices, "_", (float)k1, (float)i1, i2);
                }
            }
            if (k != j) {
                int firstCharacterIndex = this.self.getDisplayPos();
                int cursorPosition = this.self.getCursorPos();
                int highlightPosition = this.self.getHighlightPos();
                int start = Math.max(Math.min(cursorPosition, highlightPosition), firstCharacterIndex);
                int end = Math.max(cursorPosition, highlightPosition);
                class_2561 fullText = this.renderText(this.method_1882().substring(firstCharacterIndex), firstCharacterIndex);
                String trimmedText = font.method_1714((class_5348)fullText, this.method_1859()).getString();
                if (cursorPosition == end && end > trimmedText.length() + firstCharacterIndex) {
                    this.self.setDisplayPos(end - trimmedText.length());
                }
                class_2561 previousText = this.renderText(this.method_1882().substring(firstCharacterIndex, start), firstCharacterIndex);
                int previousTextWidth = font.method_27525((class_5348)previousText);
                class_2561 highlightedText = this.renderText(this.method_1882().substring(start, end), start);
                int highlightedTextWidth = font.method_27525((class_5348)highlightedText);
                int x0 = this.method_46426() + 4;
                this.self.invokeRenderHighlight(x0 + previousTextWidth, i1 - 1, x0 + previousTextWidth + highlightedTextWidth, i1 + 1 + 9);
            }
        }
    }
}

