/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.fabric;

import com.github.franckyi.ibeeditor.common.network.NetworkHandler;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class PlatformUtilImpl {
    public static Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public static <P> void sendToServer(NetworkHandler.Server<P> handler, P packet) {
        class_2540 buf = PacketByteBufs.create();
        handler.getSerializer().write(packet, buf);
        ClientPlayNetworking.send((class_2960)handler.getLocation(), (class_2540)buf);
    }

    public static <P> void sendToClient(class_3222 player, NetworkHandler.Client<P> handler, P packet) {
        class_2540 buf = PacketByteBufs.create();
        handler.getSerializer().write(packet, buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)handler.getLocation(), (class_2540)buf);
    }

    public static <P> void registerServerHandler(NetworkHandler.Server<P> handler) {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)handler.getLocation(), (server, entity, networkHandler, buf, sender) -> {
            Object packet = handler.getSerializer().read(buf);
            server.execute(() -> handler.getPacketHandler().handle(entity, packet));
        });
    }

    public static <P> void registerClientHandler(NetworkHandler.Client<P> handler) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)handler.getLocation(), (client, networkHandler, buf, responseSender) -> {
                Object packet = handler.getSerializer().read(buf);
                client.execute(() -> handler.getPacketHandler().handle(packet));
            });
        }
    }
}

