/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.screen.view;

import com.github.franckyi.databindings.api.ObservableList;
import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.node.HBox;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.node.TexturedButton;
import com.github.franckyi.guapi.api.node.TexturedToggleButton;
import com.github.franckyi.guapi.api.node.Toggle;
import com.github.franckyi.guapi.api.node.TreeView;
import com.github.franckyi.guapi.api.node.VBox;
import com.github.franckyi.guapi.api.node.builder.TexturedButtonBuilder;
import com.github.franckyi.guapi.api.node.builder.TexturedToggleButtonBuilder;
import com.github.franckyi.guapi.api.node.builder.TreeViewBuilder;
import com.github.franckyi.ibeeditor.client.ModTextures;
import com.github.franckyi.ibeeditor.client.screen.model.NBTTagModel;
import com.github.franckyi.ibeeditor.client.screen.mvc.NBTTagMVC;
import com.github.franckyi.ibeeditor.client.screen.view.ScreenView;
import com.github.franckyi.ibeeditor.common.ModTexts;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class NBTEditorView
extends ScreenView {
    private VBox main;
    private TreeView<NBTTagModel> tagTree;
    private HBox addButtons;
    private TexturedButton addByteButton;
    private TexturedButton addShortButton;
    private TexturedButton addIntButton;
    private TexturedButton addLongButton;
    private TexturedButton addFloatButton;
    private TexturedButton addDoubleButton;
    private TexturedButton addByteArrayButton;
    private TexturedButton addStringButton;
    private TexturedButton addListButton;
    private TexturedButton addCompoundButton;
    private TexturedButton addIntArrayButton;
    private TexturedButton addLongArrayButton;
    private TexturedButton moveUpButton;
    private TexturedButton moveDownButton;
    private TexturedButton deleteButton;
    private TexturedButton cutButton;
    private TexturedButton copyButton;
    private TexturedButton pasteButton;
    private TexturedToggleButton addButton;
    private final ObservableList<ButtonType> visibleButtons = ObservableList.create();
    private Consumer<ButtonType> onButtonClick = b -> {};

    @Override
    public void build() {
        super.build();
        this.addButtons = GuapiHelper.hBox(addBox -> {
            this.addByteButton = this.createAddTagButton(ButtonType.BYTE, "blue", "Byte");
            addBox.add(this.addByteButton);
            this.addShortButton = this.createAddTagButton(ButtonType.SHORT, "green", "Short");
            addBox.add(this.addShortButton);
            this.addIntButton = this.createAddTagButton(ButtonType.INT, "aqua", "Int");
            addBox.add(this.addIntButton);
            this.addLongButton = this.createAddTagButton(ButtonType.LONG, "red", "Long");
            addBox.add(this.addLongButton);
            this.addFloatButton = this.createAddTagButton(ButtonType.FLOAT, "light_purple", "Float");
            addBox.add(this.addFloatButton);
            this.addDoubleButton = this.createAddTagButton(ButtonType.DOUBLE, "yellow", "Double");
            addBox.add(this.addDoubleButton);
            this.addByteArrayButton = this.createAddTagButton(ButtonType.BYTE_ARRAY, "blue", "Byte Array");
            addBox.add(this.addByteArrayButton);
            this.addStringButton = this.createAddTagButton(ButtonType.STRING, "gray", "String");
            addBox.add(this.addStringButton);
            this.addListButton = this.createAddTagButton(ButtonType.LIST, "green", "List");
            addBox.add(this.addListButton);
            this.addCompoundButton = this.createAddTagButton(ButtonType.COMPOUND, "light_purple", "Compound");
            addBox.add(this.addCompoundButton);
            this.addIntArrayButton = this.createAddTagButton(ButtonType.INT_ARRAY, "aqua", "Int Array");
            addBox.add(this.addIntArrayButton);
            this.addLongArrayButton = this.createAddTagButton(ButtonType.LONG_ARRAY, "red", "Long Array");
            addBox.add(this.addLongArrayButton);
            addBox.spacing(2);
        });
        this.getEnabledButtons().addListener(this::updateEnabledButtons);
        this.addButton.activeProperty().addListener(this::updateVisibleButtons);
    }

    private void updateVisibleButtons(boolean showButtons) {
        if (showButtons) {
            this.main.getChildren().add(1, this.addButtons);
        } else {
            this.main.getChildren().remove(this.addButtons);
        }
    }

    @Override
    protected class_5250 getHeaderLabelText() {
        return ModTexts.editorTitle("NBT");
    }

    @Override
    protected Node createMain() {
        this.main = (VBox)super.createMain();
        return this.main;
    }

    @Override
    protected Node createButtonBar() {
        Node res = super.createButtonBar();
        this.buttonBarLeft.getChildren().addAll((Node[])new Node[]{GuapiHelper.hBox(base -> {
            this.moveUpButton = (TexturedButton)this.createButtonFromType(ButtonType.MOVE_UP).disable();
            base.add(this.moveUpButton);
            this.moveDownButton = (TexturedButton)this.createButtonFromType(ButtonType.MOVE_DOWN).disable();
            base.add(this.moveDownButton);
            this.addButton = (TexturedToggleButton)this.createToggleButtonFromType(ButtonType.ADD).disable();
            base.add(this.addButton);
            this.deleteButton = (TexturedButton)this.createButtonFromType(ButtonType.DELETE).disable();
            base.add(this.deleteButton);
            base.spacing(2);
        }), GuapiHelper.hBox(copyBox -> {
            this.cutButton = (TexturedButton)this.createButtonFromType(ButtonType.CUT).disable();
            copyBox.add(this.cutButton);
            this.copyButton = (TexturedButton)this.createButtonFromType(ButtonType.COPY).disable();
            copyBox.add(this.copyButton);
            this.pasteButton = (TexturedButton)this.createButtonFromType(ButtonType.PASTE).disable();
            copyBox.add(this.pasteButton);
            copyBox.spacing(2);
        }), GuapiHelper.hBox(expand -> {
            expand.add((Node)this.createButton(ModTextures.COLLAPSE, ModTexts.COLLAPSE).action(this::collapseAll));
            expand.add((Node)this.createButton(ModTextures.EXPAND, ModTexts.EXPAND).action(this::expandAll));
            expand.spacing(2);
        }), this.createButton(ModTextures.SCROLL_FOCUSED, ModTexts.SCROLL_FOCUSED).action(() -> this.tagTree.setScrollTo((NBTTagModel)this.getTagTree().getFocusedElement()))});
        return res;
    }

    @Override
    protected Node createEditor() {
        this.tagTree = (TreeView)((TreeViewBuilder)((TreeViewBuilder)((TreeViewBuilder)((TreeViewBuilder)GuapiHelper.treeView(NBTTagModel.class).showRoot()).itemHeight(20)).childrenFocusable()).padding(5)).renderer(item -> GuapiHelper.mvc(NBTTagMVC.INSTANCE, item));
        return this.tagTree;
    }

    private void expandAll() {
        this.getTagTree().getRoot().flattened().forEach(tagModel -> tagModel.setExpanded(true));
        this.getTagTree().getRoot().setChildrenChanged(true);
    }

    private void collapseAll() {
        this.getTagTree().getRoot().flattened().forEach(tagModel -> tagModel.setExpanded(false));
        this.getTagTree().getRoot().setChildrenChanged(true);
    }

    public TreeView<NBTTagModel> getTagTree() {
        return this.tagTree;
    }

    public ObservableList<ButtonType> getEnabledButtons() {
        return this.visibleButtons;
    }

    public void setOnButtonClick(Consumer<ButtonType> action) {
        this.onButtonClick = action;
    }

    public Toggle getAddTagButton() {
        return this.addButton;
    }

    private TexturedButtonBuilder createButtonFromType(ButtonType type) {
        return this.createButtonFromType(type, type.getText());
    }

    private TexturedButtonBuilder createButtonFromType(ButtonType type, class_5250 tooltipText) {
        return (TexturedButtonBuilder)this.createButton(type.getTextureId(), tooltipText).action(() -> this.onButtonClick.accept(type));
    }

    private TexturedToggleButtonBuilder createToggleButtonFromType(ButtonType type) {
        return (TexturedToggleButtonBuilder)((TexturedToggleButtonBuilder)GuapiHelper.texturedToggleButton(type.getTextureId(), 16, 16, false).tooltip(new class_2561[]{type.getText()})).action(() -> this.onButtonClick.accept(type));
    }

    private TexturedButtonBuilder createAddTagButton(ButtonType type, String color, String with) {
        return this.createButtonFromType(type, ModTexts.addTag(color, with));
    }

    private void updateEnabledButtons() {
        for (ButtonType type : ButtonType.CAN_DISABLE) {
            this.getButton(type).setDisable(!this.getEnabledButtons().contains((Object)type));
        }
    }

    private TexturedButton getButton(ButtonType buttonType) {
        return switch (buttonType) {
            default -> throw new IncompatibleClassChangeError();
            case ButtonType.BYTE -> this.addByteButton;
            case ButtonType.SHORT -> this.addShortButton;
            case ButtonType.INT -> this.addIntButton;
            case ButtonType.LONG -> this.addLongButton;
            case ButtonType.FLOAT -> this.addFloatButton;
            case ButtonType.DOUBLE -> this.addDoubleButton;
            case ButtonType.BYTE_ARRAY -> this.addByteArrayButton;
            case ButtonType.STRING -> this.addStringButton;
            case ButtonType.LIST -> this.addListButton;
            case ButtonType.COMPOUND -> this.addCompoundButton;
            case ButtonType.INT_ARRAY -> this.addIntArrayButton;
            case ButtonType.LONG_ARRAY -> this.addLongArrayButton;
            case ButtonType.MOVE_UP -> this.moveUpButton;
            case ButtonType.MOVE_DOWN -> this.moveDownButton;
            case ButtonType.ADD -> this.addButton;
            case ButtonType.DELETE -> this.deleteButton;
            case ButtonType.CUT -> this.cutButton;
            case ButtonType.COPY -> this.copyButton;
            case ButtonType.PASTE -> this.pasteButton;
        };
    }

    public static enum ButtonType {
        BYTE(ModTextures.BYTE_TAG_ADD, 1),
        SHORT(ModTextures.SHORT_TAG_ADD, 2),
        INT(ModTextures.INT_TAG_ADD, 3),
        LONG(ModTextures.LONG_TAG_ADD, 4),
        FLOAT(ModTextures.FLOAT_TAG_ADD, 5),
        DOUBLE(ModTextures.DOUBLE_TAG_ADD, 6),
        BYTE_ARRAY(ModTextures.BYTE_ARRAY_TAG_ADD, 7),
        STRING(ModTextures.STRING_TAG_ADD, 8),
        LIST(ModTextures.LIST_TAG_ADD, 9),
        COMPOUND(ModTextures.COMPOUND_TAG_ADD, 10),
        INT_ARRAY(ModTextures.INT_ARRAY_TAG_ADD, 11),
        LONG_ARRAY(ModTextures.LONG_ARRAY_TAG_ADD, 12),
        MOVE_UP(ModTextures.MOVE_UP, ModTexts.MOVE_UP),
        MOVE_DOWN(ModTextures.MOVE_DOWN, ModTexts.MOVE_DOWN),
        ADD(ModTextures.ADD, ModTexts.ADD),
        DELETE(ModTextures.REMOVE, ModTexts.REMOVE),
        CUT(ModTextures.CUT, ModTexts.CUT),
        COPY(ModTextures.COPY, ModTexts.COPY),
        PASTE(ModTextures.PASTE, ModTexts.PASTE);

        public static final ButtonType[] CAN_DISABLE;
        private final class_2960 textureId;
        private final byte type;
        private final class_5250 text;

        private ButtonType(class_2960 textureId, int type, class_5250 text) {
            this.textureId = textureId;
            this.type = (byte)type;
            this.text = text;
        }

        private ButtonType(class_2960 textureId, int type) {
            this(textureId, type, null);
        }

        private ButtonType(class_2960 textureId, class_5250 text) {
            this(textureId, -1, text);
        }

        public byte getType() {
            return this.type;
        }

        public class_2960 getTextureId() {
            return this.textureId;
        }

        public class_5250 getText() {
            return this.text;
        }

        static {
            CAN_DISABLE = new ButtonType[]{MOVE_UP, MOVE_DOWN, ADD, DELETE, CUT, COPY, PASTE};
        }
    }
}

