/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.base.theme.vanilla.delegate;

import com.github.franckyi.guapi.api.node.TextField;
import com.github.franckyi.guapi.base.theme.vanilla.delegate.VanillaWidgetSkinDelegate;
import com.github.franckyi.ibeeditor.mixin.EditBoxMixin;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class VanillaTextFieldSkinDelegate<N extends TextField>
extends EditBox
implements VanillaWidgetSkinDelegate {
    private final N node;
    private final EditBoxMixin self;

    public VanillaTextFieldSkinDelegate(N node) {
        super(Minecraft.m_91087_().f_91062_, node.getX(), node.getY(), node.getWidth(), node.getHeight(), node.getLabel());
        this.node = node;
        this.self = (EditBoxMixin)((Object)this);
        this.f_93623_ = !node.isDisabled();
        this.m_94199_(node.getMaxLength());
        this.m_94144_(node.getText());
        this.m_93692_(node.isFocused());
        this.m_94151_(arg_0 -> node.setText(arg_0));
        node.xProperty().addListener(newVal -> this.m_252865_(newVal + 1));
        node.yProperty().addListener(newVal -> this.m_253211_(newVal + 1));
        node.widthProperty().addListener(newVal -> this.m_93674_(newVal - 2));
        node.heightProperty().addListener(newVal -> {
            this.f_93619_ = newVal - 2;
        });
        node.disabledProperty().addListener(newVal -> {
            this.f_93623_ = newVal == false;
        });
        node.labelProperty().addListener(arg_0 -> ((VanillaTextFieldSkinDelegate)this).m_93666_(arg_0));
        node.maxLengthProperty().addListener(arg_0 -> ((VanillaTextFieldSkinDelegate)this).m_94199_(arg_0));
        node.textProperty().addListener(this::updateText);
        node.focusedProperty().addListener(arg_0 -> ((VanillaTextFieldSkinDelegate)this).m_93692_(arg_0));
        node.validatorProperty().addListener(this::updateValidator);
        node.validationForcedProperty().addListener(this::updateValidator);
        node.textRendererProperty().addListener(this::updateRenderer);
        node.cursorPositionProperty().addListener(x$0 -> super.m_94196_(x$0));
        node.highlightPositionProperty().addListener(x$0 -> super.m_94208_(x$0));
        node.placeholderProperty().addListener(this::updatePlaceholder);
        node.textProperty().addListener(this::updatePlaceholder);
        this.m_94198_(false);
        this.updateValidator();
        this.updateRenderer();
        this.updatePlaceholder();
    }

    private void updateText(String text) {
        if (this.node.getValidator().test(text)) {
            if (text.length() > this.node.getMaxLength()) {
                this.self.setRawValue(text.substring(0, this.node.getMaxLength()));
            } else {
                this.self.setRawValue(text);
            }
        }
    }

    private void updateValidator() {
        if (this.node.isValidationForced()) {
            if (this.node.getValidator() == null) {
                this.m_94153_(Objects::nonNull);
            } else {
                this.m_94153_(this.node.getValidator());
            }
        } else {
            this.m_94153_(Objects::nonNull);
        }
    }

    private void updateRenderer() {
        if (this.node.getTextRenderer() == null) {
            this.m_94149_((string, integer) -> FormattedCharSequence.m_13714_((String)string, (Style)Style.f_131099_));
        } else {
            this.m_94149_((string, integer) -> this.renderText((String)string, (int)integer).m_7532_());
        }
        this.m_94198_(false);
    }

    private void updatePlaceholder() {
        this.m_94167_(this.m_94155_().isEmpty() ? this.node.getPlaceholder().getString() : null);
    }

    public Component renderText(String str, int firstCharacterIndex) {
        return this.node.getTextRenderer() == null ? Component.m_237113_((String)str) : this.node.getTextRenderer().render(str, firstCharacterIndex);
    }

    public void m_94196_(int value) {
        super.m_94196_(value);
        this.node.setCursorPosition(this.m_94207_());
        if (this.m_94207_() < this.self.getDisplayPos()) {
            this.self.setDisplayPos(this.m_94207_());
        }
    }

    public void m_94208_(int value) {
        super.m_94208_(value);
        this.node.setHighlightPosition(this.self.getHighlightPos());
    }

    public void m_94164_(@NotNull String string) {
        int oldCursorPos = this.m_94207_();
        int oldHighlightPos = this.node.getHighlightPosition();
        String oldText = this.m_94155_();
        super.m_94164_(string);
        this.node.onTextUpdate(oldCursorPos, oldHighlightPos, oldText, this.m_94207_(), this.m_94155_());
    }

    public void m_94180_(int characterOffset) {
        if (this.m_94173_().isEmpty()) {
            int oldCursorPos = this.m_94207_();
            int oldHighlightPos = this.node.getHighlightPosition();
            String oldText = this.m_94155_();
            super.m_94180_(characterOffset);
            this.node.onTextUpdate(oldCursorPos, oldHighlightPos, oldText, this.m_94207_(), this.m_94155_());
        } else {
            super.m_94180_(characterOffset);
        }
    }

    protected void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
        int displayPos = this.self.getDisplayPos();
        Font font = Minecraft.m_91087_().f_91062_;
        FormattedText string = font.m_92854_((FormattedText)this.renderText(this.m_94155_().substring(displayPos), displayPos), this.m_94210_());
        this.m_94208_(font.m_92854_(string, Mth.m_14107_((double)mouseX) - this.m_252754_() - 4).getString().length() + displayPos);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean flag;
        Font font = Minecraft.m_91087_().f_91062_;
        if (!this.m_94213_()) {
            return false;
        }
        boolean bl = flag = mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_);
        if (this.self.canLoseFocus() && button == 0) {
            this.m_93692_(flag);
        }
        if (this.m_93696_() && flag && button == 0) {
            int i = Mth.m_14107_((double)mouseX) - this.m_252754_();
            if (this.self.isBordered()) {
                i -= 4;
            }
            FormattedText string = font.m_92854_((FormattedText)this.renderText(this.m_94155_().substring(this.self.getDisplayPos()), this.self.getDisplayPos()), this.m_94210_());
            this.m_94192_(font.m_92854_(string, i).getString().length() + this.self.getDisplayPos(), false);
            return true;
        }
        return false;
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        Font font = Minecraft.m_91087_().f_91062_;
        if (this.m_94213_()) {
            if (this.self.isBordered()) {
                int i = this.m_93696_() ? -1 : -6250336;
                guiGraphics.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.f_93618_ + 1, this.m_252907_() + this.f_93619_ + 1, i);
                guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -16777216);
            }
            int i2 = this.self.isEditable() ? this.self.getTextColor() : this.self.getTextColorUneditable();
            int j = this.self.getCursorPos() - this.self.getDisplayPos();
            int k = this.self.getHighlightPos() - this.self.getDisplayPos();
            Component renderedText = this.renderText(this.m_94155_().substring(this.self.getDisplayPos()), this.self.getDisplayPos());
            String s = renderedText != null ? font.m_92854_((FormattedText)renderedText, this.m_94210_()).getString() : font.m_92834_(this.m_94155_().substring(this.self.getDisplayPos()), this.m_94210_());
            boolean flag = j >= 0 && j <= s.length();
            boolean flag1 = this.m_93696_() && (Util.m_137550_() - this.self.getFocusedTime()) / 300L % 2L == 0L && flag;
            int l = this.self.isBordered() ? this.m_252754_() + 4 : this.m_252754_();
            int i1 = this.self.isBordered() ? this.m_252907_() + (this.f_93619_ - 8) / 2 : this.m_252907_();
            int j1 = l;
            if (k > s.length()) {
                k = s.length();
            }
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 = guiGraphics.m_280648_(font, this.self.getFormatter().apply(s1, this.self.getDisplayPos()), l, i1, i2);
            }
            boolean flag2 = this.self.getCursorPos() < this.m_94155_().length() || this.m_94155_().length() >= this.self.invokeGetMaxLength();
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + this.f_93618_ : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            if (!s.isEmpty() && flag && j < s.length()) {
                guiGraphics.m_280648_(font, this.self.getFormatter().apply(s.substring(j), this.self.getCursorPos()), j1, i1, i2);
            }
            if (!flag2 && this.self.getSuggestion() != null) {
                guiGraphics.m_280488_(font, this.self.getSuggestion(), k1 - 1, i1, -8355712);
            }
            if (flag1) {
                if (flag2) {
                    guiGraphics.m_280509_(k1, i1 - 1, k1 + 1, i1 + 1 + 9, -3092272);
                } else {
                    guiGraphics.m_280488_(font, "_", k1, i1, i2);
                }
            }
            if (k != j) {
                int firstCharacterIndex = this.self.getDisplayPos();
                int cursorPosition = this.self.getCursorPos();
                int highlightPosition = this.self.getHighlightPos();
                int start = Math.max(Math.min(cursorPosition, highlightPosition), firstCharacterIndex);
                int end = Math.max(cursorPosition, highlightPosition);
                Component fullText = this.renderText(this.m_94155_().substring(firstCharacterIndex), firstCharacterIndex);
                String trimmedText = font.m_92854_((FormattedText)fullText, this.m_94210_()).getString();
                if (cursorPosition == end && end > trimmedText.length() + firstCharacterIndex) {
                    this.self.setDisplayPos(end - trimmedText.length());
                }
                Component previousText = this.renderText(this.m_94155_().substring(firstCharacterIndex, start), firstCharacterIndex);
                int previousTextWidth = font.m_92852_((FormattedText)previousText);
                Component highlightedText = this.renderText(this.m_94155_().substring(start, end), start);
                int highlightedTextWidth = font.m_92852_((FormattedText)highlightedText);
                int x0 = this.m_252754_() + 4;
                this.self.invokeRenderHighlight(guiGraphics, x0 + previousTextWidth, i1 - 1, x0 + previousTextWidth + highlightedTextWidth, i1 + 1 + 9);
            }
        }
    }
}

