/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client;

import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.node.Scene;
import com.github.franckyi.guapi.api.node.builder.SceneBuilder;
import com.github.franckyi.ibeeditor.client.ClientConfiguration;
import com.github.franckyi.ibeeditor.client.ClientUtil;
import com.github.franckyi.ibeeditor.client.context.BlockEditorContext;
import com.github.franckyi.ibeeditor.client.context.EditorContext;
import com.github.franckyi.ibeeditor.client.context.EntityEditorContext;
import com.github.franckyi.ibeeditor.client.context.ItemEditorContext;
import com.github.franckyi.ibeeditor.client.screen.model.BlockEditorModel;
import com.github.franckyi.ibeeditor.client.screen.model.ConfigEditorScreenModel;
import com.github.franckyi.ibeeditor.client.screen.model.EntityEditorModel;
import com.github.franckyi.ibeeditor.client.screen.model.ItemEditorModel;
import com.github.franckyi.ibeeditor.client.screen.model.NBTEditorModel;
import com.github.franckyi.ibeeditor.client.screen.model.SNBTEditorModel;
import com.github.franckyi.ibeeditor.client.screen.model.VaultScreenModel;
import com.github.franckyi.ibeeditor.client.screen.model.selection.ColorSelectionScreenModel;
import com.github.franckyi.ibeeditor.client.screen.model.selection.ListSelectionScreenModel;
import com.github.franckyi.ibeeditor.client.screen.model.selection.element.ListSelectionElementModel;
import com.github.franckyi.ibeeditor.client.screen.mvc.ColorSelectionScreenMVC;
import com.github.franckyi.ibeeditor.client.screen.mvc.ConfigEditorMVC;
import com.github.franckyi.ibeeditor.client.screen.mvc.ListSelectionScreenMVC;
import com.github.franckyi.ibeeditor.client.screen.mvc.NBTEditorMVC;
import com.github.franckyi.ibeeditor.client.screen.mvc.SNBTEditorMVC;
import com.github.franckyi.ibeeditor.client.screen.mvc.StandardEditorMVC;
import com.github.franckyi.ibeeditor.client.screen.mvc.VaultScreenMVC;
import com.github.franckyi.ibeeditor.client.util.ScreenScalingManager;
import com.github.franckyi.ibeeditor.common.EditorType;
import com.github.franckyi.ibeeditor.common.ModTexts;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModScreenHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void openSettingsScreen() {
        ModScreenHandler.openScaledScreen(GuapiHelper.mvc(ConfigEditorMVC.INSTANCE, new ConfigEditorScreenModel()));
    }

    public static void openListSelectionScreen(MutableComponent title, String attributeName, List<? extends ListSelectionElementModel> items, Consumer<String> action) {
        ModScreenHandler.openScaledScreen(GuapiHelper.mvc(ListSelectionScreenMVC.INSTANCE, new ListSelectionScreenModel(title, attributeName, items, action)));
    }

    public static void openColorSelectionScreen(ColorSelectionScreenModel.Target target, int color, Consumer<String> action) {
        ModScreenHandler.openScaledScreen(GuapiHelper.mvc(ColorSelectionScreenMVC.INSTANCE, new ColorSelectionScreenModel(target, action, color)));
    }

    public static void openVault() {
        ModScreenHandler.openScaledScreen(GuapiHelper.mvc(VaultScreenMVC.INSTANCE, new VaultScreenModel()));
    }

    private static void openScaledScreen(Node root) {
        ModScreenHandler.openScaledScreen(root, false);
    }

    private static void openScaledScreen(Node root, boolean replace) {
        Consumer<Scene> action = replace ? Guapi.getScreenHandler()::replaceScene : Guapi.getScreenHandler()::showScene;
        try {
            action.accept((Scene)((SceneBuilder)GuapiHelper.scene(root, true, true).show(scene -> {
                ScreenScalingManager.get().setBaseScale(ClientConfiguration.INSTANCE.getEditorScale());
                scene.widthProperty().addListener(ScreenScalingManager.get()::refresh);
                scene.heightProperty().addListener(ScreenScalingManager.get()::refresh);
            })).hide(scene -> {
                ClientConfiguration.INSTANCE.setEditorScale(ScreenScalingManager.get().getScaleAndReset());
                ClientConfiguration.save();
            }));
        }
        catch (Exception e) {
            LOGGER.error("Error while opening screen", (Throwable)e);
            ClientUtil.showMessage((Component)ModTexts.Messages.ERROR_GENERIC);
        }
    }

    public static void openEditor(EditorType editorType, EditorContext<?> context) {
        ModScreenHandler.openEditor(editorType, context, false);
    }

    public static void openEditor(EditorType editorType, EditorContext<?> context, boolean replace) {
        if (editorType != EditorType.STANDARD && context.getTag() == null) {
            ClientUtil.showMessage((Component)ModTexts.Messages.NO_BLOCK_DATA);
            return;
        }
        ModScreenHandler.openScaledScreen(switch (editorType) {
            default -> throw new IncompatibleClassChangeError();
            case EditorType.STANDARD -> {
                if (context instanceof ItemEditorContext) {
                    ItemEditorContext ctx = (ItemEditorContext)context;
                    yield GuapiHelper.mvc(StandardEditorMVC.INSTANCE, new ItemEditorModel(ctx));
                }
                if (context instanceof BlockEditorContext) {
                    BlockEditorContext ctx = (BlockEditorContext)context;
                    yield GuapiHelper.mvc(StandardEditorMVC.INSTANCE, new BlockEditorModel(ctx));
                }
                if (context instanceof EntityEditorContext) {
                    EntityEditorContext ctx = (EntityEditorContext)context;
                    yield GuapiHelper.mvc(StandardEditorMVC.INSTANCE, new EntityEditorModel(ctx));
                }
                throw new IllegalStateException("context should be an instance of ItemEditorContext, BlockEditorContext or EntityEditorContext");
            }
            case EditorType.NBT -> GuapiHelper.mvc(NBTEditorMVC.INSTANCE, new NBTEditorModel(context));
            case EditorType.SNBT -> GuapiHelper.mvc(SNBTEditorMVC.INSTANCE, new SNBTEditorModel(context));
        }, replace);
    }
}

