/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.context;

import com.github.franckyi.ibeeditor.client.context.EditorContext;
import com.github.franckyi.ibeeditor.common.ModTexts;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockEditorContext
extends EditorContext<BlockEditorContext> {
    private BlockState blockState;
    private final BlockEntity blockEntity;

    public BlockEditorContext(BlockState blockState, CompoundTag tag, Component errorTooltip, Consumer<BlockEditorContext> action) {
        super(tag, errorTooltip, false, action);
        this.blockState = blockState;
        this.blockEntity = tag == null ? null : BlockEntity.m_155241_((BlockPos)BlockPos.f_121853_, (BlockState)blockState, (CompoundTag)tag);
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public <T extends Comparable<T>> void updateBlockState(Property<T> property, T value) {
        this.blockState = (BlockState)this.blockState.m_61124_(property, value);
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    @Override
    public MutableComponent getTargetName() {
        return ModTexts.BLOCK;
    }

    @Override
    public String getCommandName() {
        return "/setblock";
    }

    @Override
    protected String getCommand() {
        String blockStateStr = this.getBlockState().toString();
        return String.format("/setblock ~ ~ ~ %s%s%s replace", BuiltInRegistries.f_256975_.m_7981_((Object)this.getBlockState().m_60734_()), this.getBlockState().m_61147_().isEmpty() ? "" : blockStateStr.substring(blockStateStr.indexOf("[")), this.getTag());
    }
}

