/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.logic;

import com.github.franckyi.ibeeditor.client.ModScreenHandler;
import com.github.franckyi.ibeeditor.client.context.BlockEditorContext;
import com.github.franckyi.ibeeditor.client.context.EntityEditorContext;
import com.github.franckyi.ibeeditor.client.context.ItemEditorContext;
import com.github.franckyi.ibeeditor.client.logic.ClientEditorUpdateLogic;
import com.github.franckyi.ibeeditor.common.ModTexts;
import com.github.franckyi.ibeeditor.common.network.BlockEditorPacket;
import com.github.franckyi.ibeeditor.common.network.BlockInventoryItemEditorPacket;
import com.github.franckyi.ibeeditor.common.network.EntityEditorPacket;
import com.github.franckyi.ibeeditor.common.network.EntityInventoryItemEditorPacket;
import com.github.franckyi.ibeeditor.common.network.MainHandItemEditorPacket;
import com.github.franckyi.ibeeditor.common.network.PlayerInventoryItemEditorPacket;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class ClientEditorResponseLogic {
    public static void onMainHandItemEditorResponse(MainHandItemEditorPacket.Response response) {
        ModScreenHandler.openEditor(response.getEditorType(), new ItemEditorContext(response.getItemStack(), ClientEditorResponseLogic.getErrorTooltip(response.hasPermission(), ModTexts.ITEM), true, context -> ClientEditorUpdateLogic.updateMainHandItem(response, context)));
    }

    public static void onPlayerInventoryItemEditorResponse(PlayerInventoryItemEditorPacket.Response response) {
        ModScreenHandler.openEditor(response.getEditorType(), new ItemEditorContext(response.getItemStack(), ClientEditorResponseLogic.getErrorTooltip(response.hasPermission(), ModTexts.ITEM), true, context -> ClientEditorUpdateLogic.updatePlayerInventoryItem(response, context)));
    }

    public static void onBlockInventoryItemEditorResponse(BlockInventoryItemEditorPacket.Response response) {
        ModScreenHandler.openEditor(response.getEditorType(), new ItemEditorContext(response.getItemStack(), ClientEditorResponseLogic.getErrorTooltip(response.hasPermission(), ModTexts.ITEM), true, context -> ClientEditorUpdateLogic.updateBlockInventoryItem(response, context)));
    }

    public static void onEntityInventoryItemEditorResponse(EntityInventoryItemEditorPacket.Response response) {
        ModScreenHandler.openEditor(response.getEditorType(), new ItemEditorContext(response.getItemStack(), ClientEditorResponseLogic.getErrorTooltip(response.hasPermission(), ModTexts.ITEM), true, context -> ClientEditorUpdateLogic.updateEntityInventoryItem(response, context)));
    }

    public static void onBlockEditorResponse(BlockEditorPacket.Response response) {
        ModScreenHandler.openEditor(response.getEditorType(), new BlockEditorContext(response.getBlockState(), response.getTag(), ClientEditorResponseLogic.getErrorTooltip(response.hasPermission(), ModTexts.BLOCK), context -> ClientEditorUpdateLogic.updateBlock(response, context)));
    }

    public static void onEntityEditorResponse(EntityEditorPacket.Response response) {
        ModScreenHandler.openEditor(response.getEditorType(), new EntityEditorContext(response.getTag(), ClientEditorResponseLogic.getErrorTooltip(response.hasPermission(), ModTexts.ENTITY), true, context -> ClientEditorUpdateLogic.updateEntity(response, context)));
    }

    private static Component getErrorTooltip(boolean hasPermission, MutableComponent arg) {
        return hasPermission ? null : ModTexts.errorPermissionDenied(arg);
    }
}

