/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.screen.controller;

import com.github.franckyi.guapi.api.mvc.Controller;
import com.github.franckyi.ibeeditor.client.screen.model.EditorModel;
import com.github.franckyi.ibeeditor.client.screen.view.ScreenView;
import com.github.franckyi.ibeeditor.common.ModTexts;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public interface EditorController<M extends EditorModel, V extends ScreenView>
extends Controller<M, V> {
    @Override
    default public void bind() {
        ((EditorModel)this.getModel()).validProperty().addListener(this::updateDoneButton);
        ((ScreenView)this.getView()).addCopyCommandButton(((EditorModel)this.getModel()).getContext().getCommandTooltip(), ((EditorModel)this.getModel()).getContext().getCommandName());
        ((ScreenView)this.getView()).getCopyCommandButton().setActive(((EditorModel)this.getModel()).getContext().isCopyCommand());
        ((ScreenView)this.getView()).getCopyCommandButton().activeProperty().addListener(((EditorModel)this.getModel()).getContext()::setCopyCommand);
        ((ScreenView)this.getView()).getCopyCommandButton().activeProperty().addListener(this::updateDoneButton);
        if (((EditorModel)this.getModel()).getContext().canSaveToVault()) {
            ((ScreenView)this.getView()).addSaveVaultButton(((EditorModel)this.getModel()).getContext().getTargetName());
            ((ScreenView)this.getView()).getSaveVaultButton().setActive(((EditorModel)this.getModel()).getContext().isSaveToVault());
            ((ScreenView)this.getView()).getSaveVaultButton().activeProperty().addListener(((EditorModel)this.getModel()).getContext()::setSaveToVault);
            ((ScreenView)this.getView()).getSaveVaultButton().activeProperty().addListener(this::updateDoneButton);
        }
        this.updateDoneButton();
    }

    default public void updateDoneButton() {
        if (((EditorModel)this.getModel()).getContext().hasPermission()) {
            ((ScreenView)this.getView()).getDoneButton().setDisable(!((EditorModel)this.getModel()).isValid());
            if (((EditorModel)this.getModel()).isValid()) {
                ((ScreenView)this.getView()).getDoneButton().getTooltip().clear();
            } else {
                ((ScreenView)this.getView()).getDoneButton().getTooltip().setAll((Component[])new Component[]{ModTexts.FIX_ERRORS});
            }
        } else {
            MutableComponent label;
            boolean disable = true;
            Component tooltip = null;
            if (((EditorModel)this.getModel()).getContext().isSaveToVault() || ((EditorModel)this.getModel()).getContext().isCopyCommand()) {
                MutableComponent mutableComponent = label = ((EditorModel)this.getModel()).getContext().isSaveToVault() ? ModTexts.SAVE_VAULT_GREEN : ModTexts.COPY_COMMAND_GREEN;
                if (((EditorModel)this.getModel()).isValid()) {
                    disable = false;
                } else {
                    tooltip = ModTexts.FIX_ERRORS;
                }
            } else {
                label = ModTexts.DONE;
                tooltip = ((EditorModel)this.getModel()).getContext().getErrorTooltip();
            }
            ((ScreenView)this.getView()).getDoneButton().setDisable(disable);
            ((ScreenView)this.getView()).getDoneButton().setLabel((Component)label);
            if (tooltip == null) {
                ((ScreenView)this.getView()).getDoneButton().getTooltip().clear();
            } else {
                ((ScreenView)this.getView()).getDoneButton().getTooltip().setAll((Component[])new Component[]{tooltip});
            }
        }
    }
}

