/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.screen.controller;

import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.api.mvc.AbstractController;
import com.github.franckyi.ibeeditor.client.screen.controller.EditorController;
import com.github.franckyi.ibeeditor.client.screen.model.NBTEditorModel;
import com.github.franckyi.ibeeditor.client.screen.model.NBTTagModel;
import com.github.franckyi.ibeeditor.client.screen.view.NBTEditorView;
import com.github.franckyi.ibeeditor.common.EditorType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NBTEditorController
extends AbstractController<NBTEditorModel, NBTEditorView>
implements EditorController<NBTEditorModel, NBTEditorView> {
    public NBTEditorController(NBTEditorModel model, NBTEditorView view) {
        super(model, view);
    }

    @Override
    public void bind() {
        EditorController.super.bind();
        ((NBTEditorView)this.view).addOpenEditorButton(() -> ((NBTEditorModel)this.model).changeEditor(EditorType.STANDARD));
        ((NBTEditorView)this.view).addOpenSNBTEditorButton(() -> ((NBTEditorModel)this.model).changeEditor(EditorType.SNBT));
        ((NBTEditorView)this.view).getTagTree().rootItemProperty().bind(((NBTEditorModel)this.model).rootTagProperty());
        ((NBTEditorView)this.view).getTagTree().focusedElementProperty().addListener(this::updateEnabledButtons);
        ((NBTEditorView)this.view).setOnButtonClick(this::onButtonClick);
        ((NBTEditorView)this.view).getDoneButton().onAction(((NBTEditorModel)this.model)::update);
        ((NBTEditorView)this.view).getCancelButton().onAction(Guapi.getScreenHandler()::hideScene);
    }

    private void onButtonClick(NBTEditorView.ButtonType target) {
        NBTTagModel tag = (NBTTagModel)((NBTEditorView)this.view).getTagTree().getFocusedElement();
        NBTTagModel parent = (NBTTagModel)tag.getParent();
        switch (target) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTE_ARRAY: 
            case STRING: 
            case LIST: 
            case COMPOUND: 
            case INT_ARRAY: 
            case LONG_ARRAY: {
                this.addChildTag(tag, this.createEmptyTag(target.getType()));
                break;
            }
            case MOVE_UP: {
                int index0 = parent.getChildren().indexOf(tag);
                Collections.swap(parent.getChildren(), index0, index0 - 1);
                this.updateEnabledButtons(tag);
                break;
            }
            case MOVE_DOWN: {
                int index1 = parent.getChildren().indexOf(tag);
                Collections.swap(parent.getChildren(), index1, index1 + 1);
                this.updateEnabledButtons(tag);
                break;
            }
            case ADD: {
                switch (tag.getTagType()) {
                    case 7: {
                        this.addChildTag(tag, (byte)1, "0");
                        break;
                    }
                    case 11: {
                        this.addChildTag(tag, (byte)3, "0");
                        break;
                    }
                    case 12: {
                        this.addChildTag(tag, (byte)4, "0");
                        break;
                    }
                    case 9: {
                        if (tag.getChildren().isEmpty()) break;
                        this.addChildTag(tag, this.createEmptyTag(((NBTTagModel)tag.getChildren().get(0)).getTagType()));
                    }
                }
                break;
            }
            case CUT: {
                ((NBTEditorModel)this.model).setClipboardTag(tag);
            }
            case DELETE: {
                parent.getChildren().remove(tag);
                ((NBTEditorView)this.view).getTagTree().setFocusedElement(null);
                break;
            }
            case COPY: {
                ((NBTEditorModel)this.model).setClipboardTag(tag.createClipboardTag());
                this.updateEnabledButtons(tag);
                break;
            }
            case PASTE: {
                NBTTagModel clipboardTag = ((NBTEditorModel)this.model).getClipboardTag();
                if (clipboardTag.canBuild()) {
                    this.addChildTag(tag, clipboardTag.build(), clipboardTag.getName());
                    break;
                }
                this.addChildTag(tag, clipboardTag.getTagType(), clipboardTag.getValue());
            }
        }
    }

    private void updateEnabledButtons(NBTTagModel newVal) {
        ((NBTEditorView)this.view).getAddTagButton().setActive(false);
        ArrayList<NBTEditorView.ButtonType> buttons = new ArrayList<NBTEditorView.ButtonType>();
        NBTTagModel clipboardTag = ((NBTEditorModel)this.model).getClipboardTag();
        if (newVal != null) {
            switch (newVal.getTagType()) {
                case 10: {
                    buttons.add(NBTEditorView.ButtonType.ADD);
                    if (clipboardTag == null || !clipboardTag.canBuild()) break;
                    buttons.add(NBTEditorView.ButtonType.PASTE);
                    break;
                }
                case 7: {
                    if (clipboardTag != null && !clipboardTag.canBuild() && clipboardTag.getTagType() == 1) {
                        buttons.add(NBTEditorView.ButtonType.PASTE);
                    }
                    buttons.add(NBTEditorView.ButtonType.ADD);
                    break;
                }
                case 11: {
                    if (clipboardTag != null && !clipboardTag.canBuild() && clipboardTag.getTagType() == 3) {
                        buttons.add(NBTEditorView.ButtonType.PASTE);
                    }
                    buttons.add(NBTEditorView.ButtonType.ADD);
                    break;
                }
                case 12: {
                    if (clipboardTag != null && !clipboardTag.canBuild() && clipboardTag.getTagType() == 4) {
                        buttons.add(NBTEditorView.ButtonType.PASTE);
                    }
                    buttons.add(NBTEditorView.ButtonType.ADD);
                    break;
                }
                case 9: {
                    if (newVal.getChildren().isEmpty()) {
                        buttons.add(NBTEditorView.ButtonType.ADD);
                        if (clipboardTag == null || !clipboardTag.canBuild()) break;
                        buttons.add(NBTEditorView.ButtonType.PASTE);
                        break;
                    }
                    buttons.add(NBTEditorView.ButtonType.ADD);
                    if (clipboardTag == null || !clipboardTag.canBuild() || clipboardTag.getTagType() != ((NBTTagModel)newVal.getChildren().get(0)).getTagType()) break;
                    buttons.add(NBTEditorView.ButtonType.PASTE);
                }
            }
            if (newVal.getParent() != null) {
                NBTTagModel parent = (NBTTagModel)newVal.getParent();
                if (parent.getChildren().indexOf(newVal) != 0) {
                    buttons.add(NBTEditorView.ButtonType.MOVE_UP);
                }
                if (parent.getChildren().indexOf(newVal) != parent.getChildren().size() - 1) {
                    buttons.add(NBTEditorView.ButtonType.MOVE_DOWN);
                }
                buttons.add(NBTEditorView.ButtonType.DELETE);
                buttons.add(NBTEditorView.ButtonType.CUT);
            }
            buttons.add(NBTEditorView.ButtonType.COPY);
        }
        ((NBTEditorView)this.view).getEnabledButtons().setAll((Collection<NBTEditorView.ButtonType>)buttons);
    }

    private void addChildTag(NBTTagModel parent, Tag newTag) {
        this.addChildTag(parent, newTag, "");
    }

    private void addChildTag(NBTTagModel parent, Tag newTag, String name) {
        this.addChildTag(parent, new NBTTagModel(newTag, parent, parent.getTagType() != 9 ? name : null, null));
    }

    private void addChildTag(NBTTagModel parent, byte target, String value) {
        this.addChildTag(parent, new NBTTagModel(target, parent, value));
    }

    private void addChildTag(NBTTagModel parent, NBTTagModel tag) {
        parent.getChildren().add(tag);
        parent.setExpanded(true);
        ((NBTEditorView)this.view).getTagTree().setScrollTo(tag);
        ((NBTEditorView)this.view).getTagTree().setFocusedElement(tag);
    }

    private Tag createEmptyTag(byte type) {
        return switch (type) {
            case 1 -> ByteTag.f_128256_;
            case 2 -> ShortTag.m_129258_((short)0);
            case 3 -> IntTag.m_128679_((int)0);
            case 4 -> LongTag.m_128882_((long)0L);
            case 5 -> FloatTag.f_128559_;
            case 6 -> DoubleTag.f_128493_;
            case 7 -> new ByteArrayTag(new byte[0]);
            case 8 -> StringTag.m_129297_((String)"");
            case 9 -> new ListTag();
            case 10 -> new CompoundTag();
            case 11 -> new IntArrayTag(new int[0]);
            case 12 -> new LongArrayTag(new long[0]);
            default -> null;
        };
    }
}

