/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.screen.controller.entry.vault;

import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.ibeeditor.client.ClientContext;
import com.github.franckyi.ibeeditor.client.ClientUtil;
import com.github.franckyi.ibeeditor.client.ModScreenHandler;
import com.github.franckyi.ibeeditor.client.context.ItemEditorContext;
import com.github.franckyi.ibeeditor.client.logic.ClientVaultActionLogic;
import com.github.franckyi.ibeeditor.client.screen.controller.entry.EntryController;
import com.github.franckyi.ibeeditor.client.screen.model.entry.vault.VaultItemEntryModel;
import com.github.franckyi.ibeeditor.client.screen.view.entry.vault.VaultItemEntryView;
import com.github.franckyi.ibeeditor.common.CommonUtil;
import com.github.franckyi.ibeeditor.common.EditorType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class VaultItemEntryController
extends EntryController<VaultItemEntryModel, VaultItemEntryView> {
    public VaultItemEntryController(VaultItemEntryModel model, VaultItemEntryView view) {
        super(model, view);
    }

    @Override
    public void bind() {
        super.bind();
        ((VaultItemEntryView)this.view).getItemView().itemProperty().bind(((VaultItemEntryModel)this.model).itemStackProperty());
        ((VaultItemEntryView)this.view).getLabel().labelProperty().bind(((VaultItemEntryModel)this.model).itemStackProperty().map(ItemStack::m_41786_));
        ((VaultItemEntryView)this.view).getButtonBox().getChildren().remove(((VaultItemEntryView)this.view).getResetButton());
        ((VaultItemEntryView)this.view).getGiveItemButton().setDisable(!Minecraft.m_91087_().f_91074_.m_7500_() || !ClientContext.isModInstalledOnServer());
        ((VaultItemEntryView)this.view).getGiveItemButton().onAction(() -> {
            int slot = ClientUtil.findSlot(((VaultItemEntryModel)this.model).getItemStack());
            if (Minecraft.m_91087_().f_91074_.m_7500_()) {
                Minecraft.m_91087_().f_91074_.f_108617_.m_295327_((Packet)new ServerboundSetCreativeModeSlotPacket(slot, ((VaultItemEntryModel)this.model).getItemStack()));
                CommonUtil.showVaultItemGiveSuccess((Player)Minecraft.m_91087_().f_91074_);
            } else if (ClientContext.isModInstalledOnServer()) {
                ClientVaultActionLogic.giveVaultItem(slot, ((VaultItemEntryModel)this.model).getItemStack());
            } else {
                return;
            }
            Guapi.getScreenHandler().hideScene();
        });
        ((VaultItemEntryView)this.view).getOpenEditorButton().onAction(() -> this.openEditor(EditorType.STANDARD));
        ((VaultItemEntryView)this.view).getOpenNBTEditorButton().onAction(() -> this.openEditor(EditorType.NBT));
        ((VaultItemEntryView)this.view).getOpenSNBTEditorButton().onAction(() -> this.openEditor(EditorType.SNBT));
    }

    private void openEditor(EditorType editorType) {
        ModScreenHandler.openEditor(editorType, new ItemEditorContext(((VaultItemEntryModel)this.model).getItemStack(), null, false, context -> ((VaultItemEntryModel)this.model).setItemStack(context.getItemStack())));
    }
}

