/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.screen.model;

import com.github.franckyi.databindings.api.BooleanProperty;
import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.ObservableList;
import com.github.franckyi.databindings.api.StringProperty;
import com.github.franckyi.guapi.api.mvc.Model;
import com.github.franckyi.guapi.api.node.TreeView;
import com.github.franckyi.ibeeditor.mixin.CompoundTagMixin;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.apache.commons.lang3.ArrayUtils;

public class NBTTagModel
implements TreeView.TreeItem<NBTTagModel>,
Model {
    private final ObservableList<NBTTagModel> children = ObservableList.create();
    private final BooleanProperty expandedProperty = BooleanProperty.create();
    private final ObjectProperty<NBTTagModel> parentProperty;
    private final BooleanProperty childrenChangedProperty = BooleanProperty.create();
    private final StringProperty nameProperty;
    private final StringProperty valueProperty;
    private final BooleanProperty validProperty = BooleanProperty.create();
    protected final Tag tag;
    protected byte forcedTagType;

    public NBTTagModel(Tag tag) {
        this(tag, null, null, null);
        this.setExpanded(true);
    }

    public NBTTagModel(byte forcedTagType, NBTTagModel parent, String value) {
        this(null, parent, null, value);
        this.forcedTagType = forcedTagType;
    }

    public NBTTagModel(Tag tag, NBTTagModel parent, String name, String value) {
        this.tag = tag;
        this.parentProperty = ObjectProperty.create(parent);
        this.nameProperty = StringProperty.create(name);
        this.valueProperty = StringProperty.create(value);
        if (tag != null) {
            switch (tag.m_7060_()) {
                case 10: {
                    this.children.setAll((Collection<NBTTagModel>)((CompoundTagMixin)tag).getTags().entrySet().stream().map(entry -> new NBTTagModel((Tag)entry.getValue(), this, (String)entry.getKey(), null)).toList());
                    break;
                }
                case 9: {
                    this.children.setAll((Collection<NBTTagModel>)((ListTag)tag).stream().map(tag1 -> new NBTTagModel((Tag)tag1, this, null, null)).toList());
                    break;
                }
                case 7: {
                    this.children.setAll((Collection<NBTTagModel>)Stream.of(ArrayUtils.toObject((byte[])((ByteArrayTag)tag).m_128227_())).map(b -> new NBTTagModel(1, this, Byte.toString(b))).toList());
                    break;
                }
                case 11: {
                    this.children.setAll((Collection<NBTTagModel>)Stream.of(ArrayUtils.toObject((int[])((IntArrayTag)tag).m_128648_())).map(i -> new NBTTagModel(3, this, Integer.toString(i))).toList());
                    break;
                }
                case 12: {
                    this.children.setAll((Collection<NBTTagModel>)Stream.of(ArrayUtils.toObject((long[])((LongArrayTag)tag).m_128851_())).map(l -> new NBTTagModel(4, this, Long.toString(l))).toList());
                    break;
                }
                case 1: {
                    this.setValue(Byte.toString(((ByteTag)tag).m_7063_()));
                    break;
                }
                case 2: {
                    this.setValue(Short.toString(((ShortTag)tag).m_7053_()));
                    break;
                }
                case 3: {
                    this.setValue(Integer.toString(((IntTag)tag).m_7047_()));
                    break;
                }
                case 4: {
                    this.setValue(Long.toString(((LongTag)tag).m_7046_()));
                    break;
                }
                case 5: {
                    this.setValue(Float.toString(((FloatTag)tag).m_7057_()));
                    break;
                }
                case 6: {
                    this.setValue(Double.toString(((DoubleTag)tag).m_7061_()));
                    break;
                }
                default: {
                    this.setValue(tag.m_7916_());
                }
            }
        }
        this.getChildren().addListener(() -> ((NBTTagModel)this.getRoot()).setChildrenChanged(true));
        this.validProperty().bind(this.getChildren().allMatch(NBTTagModel::isValid, NBTTagModel::validProperty));
    }

    @Override
    public ObservableList<NBTTagModel> getChildren() {
        return this.children;
    }

    @Override
    public BooleanProperty expandedProperty() {
        return this.expandedProperty;
    }

    @Override
    public ObjectProperty<NBTTagModel> parentProperty() {
        return this.parentProperty;
    }

    @Override
    public BooleanProperty childrenChangedProperty() {
        return this.childrenChangedProperty;
    }

    public String getName() {
        return (String)this.nameProperty().getValue();
    }

    public StringProperty nameProperty() {
        return this.nameProperty;
    }

    public void setName(String value) {
        this.nameProperty().setValue(value);
    }

    public String getValue() {
        return (String)this.valueProperty().getValue();
    }

    public StringProperty valueProperty() {
        return this.valueProperty;
    }

    public void setValue(String value) {
        this.valueProperty().setValue(value);
    }

    public boolean isValid() {
        return this.validProperty().getValue();
    }

    public BooleanProperty validProperty() {
        return this.validProperty;
    }

    public void setValid(boolean value) {
        this.validProperty().setValue(value);
    }

    public byte getTagType() {
        return this.tag != null ? this.tag.m_7060_() : this.forcedTagType;
    }

    public boolean canBuild() {
        return this.tag != null;
    }

    public Tag build() {
        if (this.canBuild()) {
            switch (this.tag.m_7060_()) {
                case 1: {
                    return ByteTag.m_128266_((byte)Byte.parseByte(this.getValue()));
                }
                case 2: {
                    return ShortTag.m_129258_((short)Short.parseShort(this.getValue()));
                }
                case 3: {
                    return IntTag.m_128679_((int)Integer.parseInt(this.getValue()));
                }
                case 4: {
                    return LongTag.m_128882_((long)Long.parseLong(this.getValue()));
                }
                case 5: {
                    return FloatTag.m_128566_((float)Float.parseFloat(this.getValue()));
                }
                case 6: {
                    return DoubleTag.m_128500_((double)Double.parseDouble(this.getValue()));
                }
                case 7: {
                    return new ByteArrayTag(this.getChildren().stream().map(NBTTagModel::getValue).map(Byte::parseByte).toList());
                }
                case 8: {
                    return StringTag.m_129297_((String)this.getValue());
                }
                case 9: {
                    ListTag listTag = new ListTag();
                    listTag.addAll(this.getChildren().stream().map(NBTTagModel::build).toList());
                    return listTag;
                }
                case 10: {
                    CompoundTag compoundTag = new CompoundTag();
                    this.getChildren().forEach(childTag -> compoundTag.m_128365_(childTag.getName(), childTag.build()));
                    return compoundTag;
                }
                case 11: {
                    return new IntArrayTag(this.getChildren().stream().map(NBTTagModel::getValue).map(Integer::parseInt).toList());
                }
                case 12: {
                    return new LongArrayTag(this.getChildren().stream().map(NBTTagModel::getValue).map(Long::parseLong).toList());
                }
            }
        }
        return null;
    }

    public NBTTagModel createClipboardTag() {
        return this.canBuild() ? new NBTTagModel(this.build(), null, this.getName(), this.getValue()) : new NBTTagModel(this.getTagType(), null, this.getValue());
    }
}

