/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.screen.model.category;

import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.ObservableBooleanValue;
import com.github.franckyi.databindings.api.ObservableList;
import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.mvc.Model;
import com.github.franckyi.ibeeditor.client.screen.model.CategoryEntryScreenModel;
import com.github.franckyi.ibeeditor.client.screen.model.entry.AddListEntryEntryModel;
import com.github.franckyi.ibeeditor.client.screen.model.entry.EntryModel;
import com.github.franckyi.ibeeditor.common.ModTexts;
import java.util.Collections;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class CategoryModel
implements Model {
    private final ObjectProperty<Component> nameProperty;
    private final ObservableBooleanValue selectedProperty;
    private final ObservableBooleanValue validProperty;
    private final ObservableList<EntryModel> entries = ObservableList.create();
    private final CategoryEntryScreenModel<?> parent;

    protected CategoryModel(Component name, CategoryEntryScreenModel<?> parent) {
        this.nameProperty = ObjectProperty.create(name);
        this.parent = parent;
        this.selectedProperty = parent.selectedCategoryProperty().is(this);
        this.validProperty = this.getEntries().allMatch(EntryModel::isValid, EntryModel::validProperty);
    }

    @Override
    public void initalize() {
        this.setupEntries();
        if (this.hasEntryList()) {
            if (this.canAddEntryInList()) {
                this.getEntries().add(new AddListEntryEntryModel(this, (Component)ModTexts.addListEntry(this.getAddListEntryButtonTooltip()).m_130940_(ChatFormatting.GREEN)));
            }
            this.updateEntryListIndexes();
        }
        this.getEntries().addListener(this::updateEntryListIndexes);
    }

    protected abstract void setupEntries();

    public Component getName() {
        return (Component)this.nameProperty().getValue();
    }

    public ObjectProperty<Component> nameProperty() {
        return this.nameProperty;
    }

    public void setName(Component value) {
        this.nameProperty().setValue(value);
    }

    public boolean isSelected() {
        return this.selectedProperty().getValue();
    }

    public ObservableBooleanValue selectedProperty() {
        return this.selectedProperty;
    }

    public boolean isValid() {
        return this.validProperty().getValue();
    }

    public ObservableBooleanValue validProperty() {
        return this.validProperty;
    }

    public CategoryEntryScreenModel<?> getParent() {
        return this.parent;
    }

    public ObservableList<EntryModel> getEntries() {
        return this.entries;
    }

    public void updateEntryListIndexes() {
        if (this.hasEntryList()) {
            for (int i = 0; i < this.getEntryListSize(); ++i) {
                EntryModel entry = (EntryModel)this.getEntries().get(this.getEntryListIndex(i));
                entry.setListSize(this.getEntryListSize());
                entry.setListIndex(i);
            }
        }
    }

    public int getEntryListStart() {
        return -1;
    }

    private int getEntryListIndex(int index) {
        return this.getEntryListStart() + index;
    }

    private int getEntryListSize() {
        return this.getEntries().size() - this.getEntryListStart() - (this.canAddEntryInList() ? 1 : 0);
    }

    private boolean hasEntryList() {
        return this.getEntryListStart() >= 0;
    }

    protected boolean canAddEntryInList() {
        return true;
    }

    public void addEntryInList() {
        this.getEntries().add(this.getEntries().size() - 1, this.createNewListEntry());
    }

    public EntryModel createNewListEntry() {
        return null;
    }

    protected MutableComponent getAddListEntryButtonTooltip() {
        return GuapiHelper.EMPTY_TEXT;
    }

    public void moveEntryUp(int index) {
        Collections.swap(this.getEntries(), this.getEntryListIndex(index), this.getEntryListIndex(index) - 1);
    }

    public void moveEntryDown(int index) {
        Collections.swap(this.getEntries(), this.getEntryListIndex(index), this.getEntryListIndex(index) + 1);
    }

    public void deleteEntry(int index) {
        this.getEntries().remove(this.getEntryListIndex(index));
    }

    public int getEntryHeight() {
        return 25;
    }

    public void apply() {
        this.getEntries().forEach(EntryModel::apply);
    }
}

