/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.screen.model.category.item;

import com.github.franckyi.ibeeditor.client.screen.model.ItemEditorModel;
import com.github.franckyi.ibeeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.franckyi.ibeeditor.client.screen.model.entry.EntryModel;
import com.github.franckyi.ibeeditor.client.screen.model.entry.item.PotionEffectEntryModel;
import com.github.franckyi.ibeeditor.client.screen.model.entry.item.PotionSelectionEntryModel;
import com.github.franckyi.ibeeditor.common.ModTexts;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffects;

public class ItemPotionEffectsCategoryModel
extends ItemEditorCategoryModel {
    private ListTag potionEffectList;

    public ItemPotionEffectsCategoryModel(ItemEditorModel editor) {
        super((Component)ModTexts.POTION_EFFECTS, editor);
    }

    @Override
    protected void setupEntries() {
        this.getEntries().add(new PotionSelectionEntryModel(this, ModTexts.DEFAULT_POTION, this.getTag().m_128461_("Potion"), this.getCustomPotionColor(), p -> this.getTag().m_128359_("Potion", p), this::setCustomPotionColor));
        this.getTag().m_128437_("custom_potion_effects", 10).stream().map(CompoundTag.class::cast).map(this::createPotionEffectEntry).forEach(this.getEntries()::add);
    }

    @Override
    public int getEntryListStart() {
        return 1;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createPotionEffectEntry(null);
    }

    @Override
    public int getEntryHeight() {
        return 50;
    }

    @Override
    protected MutableComponent getAddListEntryButtonTooltip() {
        return ModTexts.EFFECT;
    }

    private int getCustomPotionColor() {
        return this.getTag().m_128425_("CustomPotionColor", 3) ? this.getTag().m_128451_("CustomPotionColor") : Integer.MIN_VALUE;
    }

    private void setCustomPotionColor(int color) {
        if (color != Integer.MIN_VALUE) {
            this.getOrCreateTag().m_128405_("CustomPotionColor", color);
        } else {
            this.getOrCreateTag().m_128473_("CustomPotionColor");
        }
    }

    private EntryModel createPotionEffectEntry(CompoundTag tag) {
        if (tag != null) {
            String id = tag.m_128461_("id");
            int amplifier = tag.m_128451_("amplifier");
            int duration = tag.m_128425_("duration", 3) ? tag.m_128451_("duration") : 1;
            boolean ambient = tag.m_128471_("ambient");
            boolean showParticles = !tag.m_128425_("show_particles", 1) || tag.m_128471_("show_particles");
            boolean showIcon = tag.m_128471_("show_icon");
            return new PotionEffectEntryModel(this, id, amplifier, duration, ambient, showParticles, showIcon, this::addPotionEffect);
        }
        return new PotionEffectEntryModel(this, BuiltInRegistries.f_256974_.m_7981_((Object)MobEffects.f_19596_).toString(), 0, 1, false, true, true, this::addPotionEffect);
    }

    @Override
    public void apply() {
        this.potionEffectList = new ListTag();
        super.apply();
        if (!this.potionEffectList.isEmpty()) {
            this.getOrCreateTag().m_128365_("custom_potion_effects", (Tag)this.potionEffectList);
        } else if (this.getOrCreateTag().m_128441_("custom_potion_effects")) {
            this.getOrCreateTag().m_128473_("custom_potion_effects");
        }
    }

    private void addPotionEffect(String id, int amplifier, int duration, boolean ambient, boolean showParticles, boolean showIcon) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", id);
        tag.m_128405_("amplifier", amplifier);
        tag.m_128405_("duration", duration);
        tag.m_128379_("ambient", ambient);
        tag.m_128379_("show_particles", showParticles);
        tag.m_128379_("show_icon", showIcon);
        this.potionEffectList.add((Object)tag);
    }
}

