/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.screen.view.selection.color;

import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.node.HBox;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.node.Slider;
import com.github.franckyi.guapi.api.node.TextField;
import com.github.franckyi.guapi.api.node.builder.HBoxBuilder;
import com.github.franckyi.guapi.api.node.builder.VBoxBuilder;
import com.github.franckyi.ibeeditor.client.screen.view.ScreenView;
import com.github.franckyi.ibeeditor.common.ModTexts;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class ColorSelectionScreenView
extends ScreenView {
    private Slider redSlider;
    private Slider greenSlider;
    private Slider blueSlider;
    private TextField hexField;
    private HBox exampleBox;

    @Override
    protected MutableComponent getHeaderLabelText() {
        return ModTexts.title(ModTexts.choose(ModTexts.CUSTOM_COLOR));
    }

    @Override
    protected Node createEditor() {
        return GuapiHelper.hBox(editor -> {
            editor.add(GuapiHelper.vBox(), 1);
            editor.add(GuapiHelper.vBox(center -> {
                center.add(GuapiHelper.vBox(rgb -> {
                    rgb.add(GuapiHelper.hBox(labels -> {
                        labels.add(GuapiHelper.label((Component)ModTexts.RED_COLOR), 1);
                        labels.add(GuapiHelper.label((Component)ModTexts.GREEN_COLOR), 1);
                        labels.add(GuapiHelper.label((Component)ModTexts.BLUE_COLOR), 1);
                        labels.spacing(4);
                    }));
                    rgb.add(GuapiHelper.hBox(fields -> {
                        this.redSlider = this.colorSlider();
                        fields.add(this.redSlider, 1);
                        this.greenSlider = this.colorSlider();
                        fields.add(this.greenSlider, 1);
                        this.blueSlider = this.colorSlider();
                        fields.add(this.blueSlider, 1);
                        fields.spacing(4);
                    }));
                    ((VBoxBuilder)rgb.fillWidth()).spacing(4);
                }));
                center.add(GuapiHelper.vBox(hex -> {
                    hex.add(GuapiHelper.hBox(labels -> {
                        labels.add(GuapiHelper.label((Component)ModTexts.Literal.HEX), 1);
                        labels.add(GuapiHelper.hBox(), 1);
                        labels.add(GuapiHelper.hBox(), 1);
                        labels.spacing(4);
                    }));
                    hex.add(GuapiHelper.hBox(fields -> {
                        this.hexField = (TextField)GuapiHelper.textField().prefHeight(16);
                        fields.add(this.hexField, 1);
                        fields.add(this.createExample(), 1);
                        this.exampleBox = (HBox)GuapiHelper.hBox().prefHeight(16);
                        fields.add(this.exampleBox, 1);
                        ((HBoxBuilder)fields.spacing(4)).align(GuapiHelper.CENTER);
                    }));
                    ((VBoxBuilder)hex.fillWidth()).spacing(4);
                }));
                ((VBoxBuilder)((VBoxBuilder)center.fillWidth()).spacing(10)).align(GuapiHelper.CENTER);
            }), 4);
            editor.add(GuapiHelper.vBox(), 1);
            editor.fillHeight();
        });
    }

    private Slider colorSlider() {
        return GuapiHelper.slider(0.0, 0.0, 255.0, 1.0);
    }

    protected abstract Node createExample();

    public Slider getRedSlider() {
        return this.redSlider;
    }

    public Slider getGreenSlider() {
        return this.greenSlider;
    }

    public Slider getBlueSlider() {
        return this.blueSlider;
    }

    public TextField getHexField() {
        return this.hexField;
    }

    public HBox getExampleBox() {
        return this.exampleBox;
    }
}

