/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.common.logic;

import com.github.franckyi.ibeeditor.common.CommonUtil;
import com.github.franckyi.ibeeditor.common.ModTexts;
import com.github.franckyi.ibeeditor.common.logic.PermissionLogic;
import com.github.franckyi.ibeeditor.common.network.BlockEditorPacket;
import com.github.franckyi.ibeeditor.common.network.BlockInventoryItemEditorPacket;
import com.github.franckyi.ibeeditor.common.network.EntityEditorPacket;
import com.github.franckyi.ibeeditor.common.network.EntityInventoryItemEditorPacket;
import com.github.franckyi.ibeeditor.common.network.MainHandItemEditorPacket;
import com.github.franckyi.ibeeditor.common.network.NetworkManager;
import com.github.franckyi.ibeeditor.common.network.PlayerInventoryItemEditorPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public final class ServerEditorRequestLogic {
    public static void onMainHandItemEditorRequest(ServerPlayer player, MainHandItemEditorPacket.Request request) {
        NetworkManager.sendToClient(player, NetworkManager.MAIN_HAND_ITEM_EDITOR_RESPONSE, new MainHandItemEditorPacket.Response(request, PermissionLogic.hasPermission(player), player.m_21205_()));
    }

    public static void onPlayerInventoryItemEditorRequest(ServerPlayer player, PlayerInventoryItemEditorPacket.Request request) {
        NetworkManager.sendToClient(player, NetworkManager.PLAYER_INVENTORY_ITEM_EDITOR_RESPONSE, new PlayerInventoryItemEditorPacket.Response(request, PermissionLogic.hasPermission(player), player.m_150109_().m_8020_(request.getSlot())));
    }

    public static void onBlockInventoryItemEditorRequest(ServerPlayer player, BlockInventoryItemEditorPacket.Request request) {
        BlockEntity blockEntity = player.m_9236_().m_7702_(request.getBlockPos());
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            NetworkManager.sendToClient(player, NetworkManager.BLOCK_INVENTORY_ITEM_EDITOR_RESPONSE, new BlockInventoryItemEditorPacket.Response(request, PermissionLogic.hasPermission(player), container.m_8020_(request.getSlot())));
        } else {
            CommonUtil.showTargetError((Player)player, ModTexts.ITEM);
        }
    }

    public static void onEntityInventoryItemEditorRequest(ServerPlayer player, EntityInventoryItemEditorPacket.Request request) {
        Entity entity = player.m_9236_().m_6815_(request.getEntityId());
        if (entity instanceof Container) {
            Container container = (Container)entity;
            NetworkManager.sendToClient(player, NetworkManager.ENTITY_INVENTORY_ITEM_EDITOR_RESPONSE, new EntityInventoryItemEditorPacket.Response(request, PermissionLogic.hasPermission(player), container.m_8020_(request.getSlot())));
        } else {
            CommonUtil.showTargetError((Player)player, ModTexts.ITEM);
        }
    }

    public static void onBlockEditorRequest(ServerPlayer player, BlockEditorPacket.Request request) {
        Level level = player.m_9236_();
        BlockState blockState = level.m_8055_(request.getBlockPos());
        BlockEntity blockEntity = level.m_7702_(request.getBlockPos());
        CompoundTag tag = blockEntity == null ? null : blockEntity.m_187481_();
        NetworkManager.sendToClient(player, NetworkManager.BLOCK_EDITOR_RESPONSE, new BlockEditorPacket.Response(request, PermissionLogic.hasPermission(player), blockState, tag));
    }

    public static void onEntityEditorRequest(ServerPlayer player, EntityEditorPacket.Request request) {
        Entity entity = player.m_9236_().m_6815_(request.getEntityId());
        CompoundTag tag = null;
        if (entity != null && !entity.m_20223_(tag = new CompoundTag())) {
            entity.m_20240_(tag);
        }
        NetworkManager.sendToClient(player, NetworkManager.ENTITY_EDITOR_RESPONSE, new EntityEditorPacket.Response(request, PermissionLogic.hasPermission(player), tag));
    }
}

