/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.common.logic;

import com.github.franckyi.ibeeditor.common.CommonUtil;
import com.github.franckyi.ibeeditor.common.ModTexts;
import com.github.franckyi.ibeeditor.common.logic.PermissionLogic;
import com.github.franckyi.ibeeditor.common.network.BlockEditorPacket;
import com.github.franckyi.ibeeditor.common.network.BlockInventoryItemEditorPacket;
import com.github.franckyi.ibeeditor.common.network.EntityEditorPacket;
import com.github.franckyi.ibeeditor.common.network.EntityInventoryItemEditorPacket;
import com.github.franckyi.ibeeditor.common.network.MainHandItemEditorPacket;
import com.github.franckyi.ibeeditor.common.network.PlayerInventoryItemEditorPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class ServerEditorUpdateLogic {
    public static void onMainHandItemEditorUpdate(ServerPlayer player, MainHandItemEditorPacket.Update response) {
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showPermissionError((Player)player, ModTexts.ITEM);
            return;
        }
        player.m_21008_(InteractionHand.MAIN_HAND, response.getItemStack());
        CommonUtil.showUpdateSuccess((Player)player, ModTexts.ITEM);
    }

    public static void onPlayerInventoryItemEditorUpdate(ServerPlayer player, PlayerInventoryItemEditorPacket.Update response) {
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showPermissionError((Player)player, ModTexts.ITEM);
            return;
        }
        player.m_150109_().m_6836_(response.getSlot(), response.getItemStack());
        CommonUtil.showUpdateSuccess((Player)player, ModTexts.ITEM);
    }

    public static void onBlockInventoryItemEditorUpdate(ServerPlayer player, BlockInventoryItemEditorPacket.Update response) {
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showPermissionError((Player)player, ModTexts.ITEM);
            return;
        }
        BlockEntity blockEntity = player.m_9236_().m_7702_(response.getBlockPos());
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            container.m_6836_(response.getSlot(), response.getItemStack());
            CommonUtil.showUpdateSuccess((Player)player, ModTexts.ITEM);
        } else {
            CommonUtil.showTargetError((Player)player, ModTexts.ITEM);
        }
    }

    public static void onEntityInventoryItemEditorUpdate(ServerPlayer player, EntityInventoryItemEditorPacket.Update response) {
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showPermissionError((Player)player, ModTexts.ITEM);
            return;
        }
        Entity entity = player.m_9236_().m_6815_(response.getEntityId());
        if (entity instanceof Container) {
            Container container = (Container)entity;
            container.m_6836_(response.getSlot(), response.getItemStack());
            CommonUtil.showUpdateSuccess((Player)player, ModTexts.ITEM);
        } else {
            CommonUtil.showTargetError((Player)player, ModTexts.ITEM);
        }
    }

    public static void onBlockEditorUpdate(ServerPlayer player, BlockEditorPacket.Update update) {
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showPermissionError((Player)player, ModTexts.BLOCK);
            return;
        }
        Level level = player.m_9236_();
        level.m_46597_(update.getBlockPos(), update.getBlockState());
        BlockEntity blockEntity = level.m_7702_(update.getBlockPos());
        if (update.getTag() != null) {
            if (blockEntity == null) {
                CommonUtil.showTargetError((Player)player, ModTexts.BLOCK);
                return;
            }
            blockEntity.m_142466_(update.getTag());
        }
        CommonUtil.showUpdateSuccess((Player)player, ModTexts.BLOCK);
    }

    public static void onEntityEditorUpdate(ServerPlayer player, EntityEditorPacket.Update update) {
        if (!PermissionLogic.hasPermission(player)) {
            CommonUtil.showPermissionError((Player)player, ModTexts.ENTITY);
            return;
        }
        Entity entity = player.m_9236_().m_6815_(update.getEntityId());
        if (entity != null) {
            entity.m_20258_(update.getTag());
            CommonUtil.showUpdateSuccess((Player)player, ModTexts.ENTITY);
        } else {
            CommonUtil.showTargetError((Player)player, ModTexts.ENTITY);
        }
    }
}

