/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.common.network;

import com.github.franckyi.ibeeditor.common.EditorType;
import com.github.franckyi.ibeeditor.common.network.AbstractEditorRequest;
import com.github.franckyi.ibeeditor.common.network.AbstractEditorResponse;
import com.github.franckyi.ibeeditor.common.network.AbstractEditorUpdate;
import com.github.franckyi.ibeeditor.common.network.PacketSerializer;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.state.BlockState;

public final class BlockEditorPacket {

    public static class Update
    extends AbstractEditorUpdate<RequestData, ResponseData> {
        public static final PacketSerializer<Update> SERIALIZER = new AbstractEditorUpdate.Serializer<Update, RequestData, ResponseData>(){

            @Override
            public Update createInstance() {
                return new Update();
            }

            @Override
            protected PacketSerializer<RequestData> getRequestDataSerializer() {
                return RequestData.SERIALIZER;
            }

            @Override
            protected PacketSerializer<ResponseData> getResponseDataSerializer() {
                return ResponseData.SERIALIZER;
            }
        };

        private Update() {
        }

        public Update(Response response, BlockState blockState, CompoundTag tag) {
            super((RequestData)response.getRequestData(), new ResponseData(blockState, tag));
        }

        public BlockPos getBlockPos() {
            return ((RequestData)this.getRequestData()).blockPos();
        }

        public BlockState getBlockState() {
            return ((ResponseData)this.getResponseData()).blockState();
        }

        public CompoundTag getTag() {
            return ((ResponseData)this.getResponseData()).tag();
        }
    }

    public static class Response
    extends AbstractEditorResponse<RequestData, ResponseData> {
        public static final PacketSerializer<Response> SERIALIZER = new AbstractEditorResponse.Serializer<Response, RequestData, ResponseData>(){

            @Override
            public Response createInstance() {
                return new Response();
            }

            @Override
            protected PacketSerializer<ResponseData> getResponseDataSerializer() {
                return ResponseData.SERIALIZER;
            }

            @Override
            protected PacketSerializer<RequestData> getRequestDataSerializer() {
                return RequestData.SERIALIZER;
            }
        };

        private Response() {
        }

        public Response(Request request, boolean hasPermission, BlockState blockState, CompoundTag tag) {
            super(request, hasPermission, new ResponseData(blockState, tag));
        }

        public BlockPos getBlockPos() {
            return ((RequestData)this.getRequestData()).blockPos();
        }

        public BlockState getBlockState() {
            return ((ResponseData)this.getResponseData()).blockState();
        }

        public CompoundTag getTag() {
            return ((ResponseData)this.getResponseData()).tag();
        }
    }

    public static class Request
    extends AbstractEditorRequest<RequestData> {
        public static final PacketSerializer<Request> SERIALIZER = new AbstractEditorRequest.Serializer<Request, RequestData>(){

            @Override
            public Request createInstance() {
                return new Request();
            }

            @Override
            protected PacketSerializer<RequestData> getRequestDataSerializer() {
                return RequestData.SERIALIZER;
            }
        };

        private Request() {
        }

        public Request(EditorType editorType, BlockPos blockPos) {
            super(editorType, new RequestData(blockPos));
        }

        public BlockPos getBlockPos() {
            return ((RequestData)this.getRequestData()).blockPos();
        }
    }

    protected record ResponseData(BlockState blockState, CompoundTag tag) {
        public static final PacketSerializer<ResponseData> SERIALIZER = new PacketSerializer<ResponseData>(){

            @Override
            public void write(ResponseData obj, FriendlyByteBuf buf) {
                buf.m_266332_((DynamicOps)NbtOps.f_128958_, BlockState.f_61039_, (Object)obj.blockState());
                buf.m_130079_((Tag)obj.tag());
            }

            @Override
            public ResponseData read(FriendlyByteBuf buf) {
                return new ResponseData((BlockState)buf.m_266466_((DynamicOps)NbtOps.f_128958_, BlockState.f_61039_, NbtAccounter.m_301669_()), buf.m_130260_());
            }
        };
    }

    protected record RequestData(BlockPos blockPos) {
        public static final PacketSerializer<RequestData> SERIALIZER = new PacketSerializer<RequestData>(){

            @Override
            public void write(RequestData obj, FriendlyByteBuf buf) {
                buf.m_130064_(obj.blockPos());
            }

            @Override
            public RequestData read(FriendlyByteBuf buf) {
                return new RequestData(buf.m_130135_());
            }
        };
    }
}

