/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.forge;

import com.github.franckyi.ibeeditor.client.ClientContext;
import com.github.franckyi.ibeeditor.client.ClientEventHandler;
import com.github.franckyi.ibeeditor.client.ClientInit;
import com.github.franckyi.ibeeditor.client.KeyBindings;
import com.github.franckyi.ibeeditor.client.ModScreenHandler;
import com.github.franckyi.ibeeditor.common.CommonInit;
import com.github.franckyi.ibeeditor.common.ServerCommandHandler;
import com.github.franckyi.ibeeditor.common.ServerEventHandler;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;

@Mod(value="ibeeditor")
public final class ForgeIBEEditorMod {
    public ForgeIBEEditorMod() {
        CommonInit.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCommonInit);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            ClientInit.init();
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientInit);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onRegisterKeybindings);
        }
    }

    private void onRegisterKeybindings(RegisterKeyMappingsEvent event) {
        event.register(KeyBindings.getEditorKey());
        event.register(KeyBindings.getNBTEditorKey());
        event.register(KeyBindings.getSNBTEditorKey());
        event.register(KeyBindings.getVaultKey());
    }

    private void onCommonInit(FMLCommonSetupEvent event) {
        CommonInit.setup();
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerLoggedOut);
    }

    private void onClientInit(FMLClientSetupEvent event) {
        ClientInit.setup();
        MinecraftForge.EVENT_BUS.addListener(this::onKeyInput);
        MinecraftForge.EVENT_BUS.addListener(this::onKeyPressed);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerLoggingIn);
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, screen) -> {
            ModScreenHandler.openSettingsScreen();
            return minecraft.f_91080_;
        }));
    }

    private void onServerStarting(ServerStartingEvent event) {
        ServerCommandHandler.registerCommand((CommandDispatcher<CommandSourceStack>)event.getServer().m_129892_().m_82094_());
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerEventHandler.onPlayerJoin((ServerPlayer)event.getEntity());
    }

    private void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerEventHandler.onPlayerLeave((ServerPlayer)event.getEntity());
    }

    private void onKeyInput(InputEvent.Key e) {
        if (Minecraft.m_91087_().f_91080_ == null) {
            ClientEventHandler.onKeyInput();
        }
    }

    private void onKeyPressed(ScreenEvent.KeyPressed.Pre e) {
        Screen screen = e.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            e.setCanceled(ClientEventHandler.onScreenEvent(screen2, e.getKeyCode()));
        }
    }

    private void onPlayerLoggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientContext.setModInstalledOnServer(false);
    }
}

