/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client;

import com.github.franckyi.ibeeditor.client.screen.model.selection.element.EnchantmentListSelectionElementModel;
import com.github.franckyi.ibeeditor.client.screen.model.selection.element.ItemListSelectionElementModel;
import com.github.franckyi.ibeeditor.client.screen.model.selection.element.ListSelectionElementModel;
import com.github.franckyi.ibeeditor.client.screen.model.selection.element.SortedEnchantmentListSelectionElementModel;
import com.github.franckyi.ibeeditor.client.screen.model.selection.element.SpriteListSelectionElementModel;
import com.github.franckyi.ibeeditor.common.ColoredItemHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public final class ClientCache {
    private static List<String> itemSuggestions;
    private static List<ItemListSelectionElementModel> itemSelectionItems;
    private static List<String> blockSuggestions;
    private static List<ItemListSelectionElementModel> blockSelectionItems;
    private static List<String> enchantmentSuggestions;
    private static List<EnchantmentListSelectionElementModel> enchantmentSelectionItems;
    private static List<String> attributeSuggestions;
    private static List<ListSelectionElementModel> attributeSelectionItems;
    private static List<String> potionSuggestions;
    private static List<ItemListSelectionElementModel> potionSelectionItems;
    private static List<String> effectSuggestions;
    private static List<SpriteListSelectionElementModel> effectSelectionItems;

    public static List<String> getItemSuggestions() {
        return itemSuggestions == null ? (itemSuggestions = ClientCache.buildSuggestions(BuiltInRegistries.f_257033_)) : itemSuggestions;
    }

    public static List<ItemListSelectionElementModel> getItemSelectionItems() {
        return itemSelectionItems == null ? (itemSelectionItems = ClientCache.buildItemSelectionItems()) : itemSelectionItems;
    }

    public static List<String> getBlockSuggestions() {
        return blockSuggestions == null ? (blockSuggestions = ClientCache.buildSuggestions(BuiltInRegistries.f_256975_)) : blockSuggestions;
    }

    public static List<ItemListSelectionElementModel> getBlockSelectionItems() {
        return blockSelectionItems == null ? (blockSelectionItems = ClientCache.buildBlockSelectionItems()) : blockSelectionItems;
    }

    public static List<String> getEnchantmentSuggestions() {
        return enchantmentSuggestions == null ? (enchantmentSuggestions = ClientCache.buildSuggestions(BuiltInRegistries.f_256876_)) : enchantmentSuggestions;
    }

    public static List<SortedEnchantmentListSelectionElementModel> getSortedEnchantmentSelectionItems(ItemStack target) {
        if (enchantmentSelectionItems == null) {
            enchantmentSelectionItems = ClientCache.buildEnchantmentSelectionItems();
        }
        return enchantmentSelectionItems.stream().map(item -> new SortedEnchantmentListSelectionElementModel((EnchantmentListSelectionElementModel)item, item.getEnchantment().m_6589_(), item.getEnchantment().m_6081_(target))).sorted((o1, o2) -> {
            if (o1.isCurse()) {
                if (o2.isCurse()) {
                    return o1.getName().compareTo(o2.getName());
                }
                return 1;
            }
            if (o2.isCurse()) {
                return -1;
            }
            if (o1.canApply()) {
                if (o2.canApply()) {
                    return o1.getName().compareTo(o2.getName());
                }
                return -1;
            }
            if (o2.canApply()) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }).toList();
    }

    public static List<String> getAttributeSuggestions() {
        return attributeSuggestions == null ? (attributeSuggestions = ClientCache.buildSuggestions(BuiltInRegistries.f_256951_)) : attributeSuggestions;
    }

    public static List<ListSelectionElementModel> getAttributeSelectionItems() {
        return attributeSelectionItems == null ? (attributeSelectionItems = ClientCache.buildAttributeSelectionItems()) : attributeSelectionItems;
    }

    public static List<String> getPotionSuggestions() {
        return potionSuggestions == null ? (potionSuggestions = ClientCache.buildSuggestions(BuiltInRegistries.f_256980_)) : potionSuggestions;
    }

    public static List<ItemListSelectionElementModel> getPotionSelectionItems() {
        return potionSelectionItems == null ? (potionSelectionItems = ClientCache.buildPotionSelectionItems()) : potionSelectionItems;
    }

    public static List<String> getEffectSuggestions() {
        return effectSuggestions == null ? (effectSuggestions = ClientCache.buildSuggestions(BuiltInRegistries.f_256974_)) : effectSuggestions;
    }

    public static List<SpriteListSelectionElementModel> getEffectSelectionItems() {
        return effectSelectionItems == null ? (effectSelectionItems = ClientCache.buildEffectSelectionItems()) : effectSelectionItems;
    }

    private static List<String> buildSuggestions(Registry<?> registry) {
        ArrayList<String> suggestions = new ArrayList<String>();
        registry.m_6579_().stream().map(e -> ((ResourceKey)e.getKey()).m_135782_().toString()).forEach(id -> {
            suggestions.add((String)id);
            if (id.startsWith("minecraft:")) {
                suggestions.add(id.substring(10));
            }
        });
        return suggestions;
    }

    private static List<ItemListSelectionElementModel> buildItemSelectionItems() {
        return BuiltInRegistries.f_257033_.m_6579_().stream().map(e -> new ItemListSelectionElementModel(((Item)e.getValue()).m_5524_(), ((ResourceKey)e.getKey()).m_135782_(), new ItemStack((ItemLike)e.getValue()))).sorted().toList();
    }

    private static List<ItemListSelectionElementModel> buildBlockSelectionItems() {
        return BuiltInRegistries.f_256975_.m_6579_().stream().map(e -> new ItemListSelectionElementModel(((Block)e.getValue()).m_7705_(), ((ResourceKey)e.getKey()).m_135782_(), new ItemStack((ItemLike)e.getValue()))).sorted().toList();
    }

    private static List<EnchantmentListSelectionElementModel> buildEnchantmentSelectionItems() {
        return BuiltInRegistries.f_256876_.m_6579_().stream().map(e -> new EnchantmentListSelectionElementModel(((Enchantment)e.getValue()).m_44704_(), ((ResourceKey)e.getKey()).m_135782_(), (Enchantment)e.getValue(), new ItemStack((ItemLike)ClientCache.getEnchantmentTypeItem((Enchantment)e.getValue())))).sorted().toList();
    }

    private static Item getEnchantmentTypeItem(Enchantment e) {
        EnchantmentCategory c = e.f_44672_;
        if (c == EnchantmentCategory.ARMOR || c == EnchantmentCategory.WEARABLE) {
            return Items.f_42469_;
        }
        if (c == EnchantmentCategory.ARMOR_FEET) {
            return Items.f_42475_;
        }
        if (c == EnchantmentCategory.ARMOR_LEGS) {
            return Items.f_42474_;
        }
        if (c == EnchantmentCategory.ARMOR_CHEST) {
            return Items.f_42473_;
        }
        if (c == EnchantmentCategory.ARMOR_HEAD) {
            return Items.f_42472_;
        }
        if (c == EnchantmentCategory.WEAPON) {
            return Items.f_42388_;
        }
        if (c == EnchantmentCategory.DIGGER) {
            return Items.f_42390_;
        }
        if (c == EnchantmentCategory.FISHING_ROD) {
            return Items.f_42523_;
        }
        if (c == EnchantmentCategory.TRIDENT) {
            return Items.f_42713_;
        }
        if (c == EnchantmentCategory.BOW) {
            return Items.f_42411_;
        }
        if (c == EnchantmentCategory.CROSSBOW) {
            return Items.f_42717_;
        }
        if (c == EnchantmentCategory.BREAKABLE || c == EnchantmentCategory.VANISHABLE) {
            return Items.f_42384_;
        }
        return Items.f_41852_;
    }

    private static List<ListSelectionElementModel> buildAttributeSelectionItems() {
        return BuiltInRegistries.f_256951_.m_6579_().stream().map(e -> new ListSelectionElementModel(((Attribute)e.getValue()).m_22087_(), ((ResourceKey)e.getKey()).m_135782_())).sorted().toList();
    }

    private static List<ItemListSelectionElementModel> buildPotionSelectionItems() {
        return BuiltInRegistries.f_256980_.m_6579_().stream().map(e -> new ItemListSelectionElementModel(((Potion)e.getValue()).m_43492_(Items.f_42589_.m_5524_() + ".effect."), ((ResourceKey)e.getKey()).m_135782_(), ColoredItemHelper.createColoredPotionItem(((ResourceKey)e.getKey()).m_135782_(), Integer.MIN_VALUE))).sorted().toList();
    }

    private static List<SpriteListSelectionElementModel> buildEffectSelectionItems() {
        return BuiltInRegistries.f_256974_.m_6579_().stream().map(e -> new SpriteListSelectionElementModel(((MobEffect)e.getValue()).m_19481_(), ((ResourceKey)e.getKey()).m_135782_(), () -> Minecraft.m_91087_().m_91306_().m_118732_((MobEffect)e.getValue()))).sorted().toList();
    }
}

