/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.context;

import com.github.franckyi.ibeeditor.client.ClientUtil;
import com.github.franckyi.ibeeditor.common.ModTexts;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class EditorContext<T extends EditorContext<T>> {
    private CompoundTag tag;
    protected Component errorTooltip;
    protected boolean canSaveToVault;
    private boolean isSaveToVault = false;
    private boolean isCopyCommand = false;
    private final Consumer<T> action;

    public EditorContext(CompoundTag tag, Component errorTooltip, boolean canSaveToVault, Consumer<T> action) {
        this.tag = tag;
        this.errorTooltip = errorTooltip;
        this.canSaveToVault = canSaveToVault;
        this.action = action;
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    public void setTag(CompoundTag tag) {
        this.tag = tag;
    }

    public Component getErrorTooltip() {
        return this.errorTooltip;
    }

    public boolean hasPermission() {
        return this.errorTooltip == null;
    }

    public void update() {
        if (this.isSaveToVault()) {
            this.saveToVault();
        }
        if (this.isCopyCommand()) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getCommand());
            ClientUtil.showMessage((Component)ModTexts.Messages.successCopyClipboard(this.getCommandName()));
        }
        if (this.hasPermission()) {
            this.action.accept(this);
        }
    }

    public boolean canSaveToVault() {
        return this.canSaveToVault;
    }

    public boolean isSaveToVault() {
        return this.isSaveToVault;
    }

    public void setSaveToVault(boolean isSaveToVault) {
        this.isSaveToVault = isSaveToVault;
    }

    public boolean isCopyCommand() {
        return this.isCopyCommand;
    }

    public void setCopyCommand(boolean copyCommand) {
        this.isCopyCommand = copyCommand;
    }

    public void saveToVault() {
    }

    public abstract MutableComponent getTargetName();

    public MutableComponent getCommandTooltip() {
        return ModTexts.copyCommand(this.getCommandName());
    }

    public abstract String getCommandName();

    protected abstract String getCommand();
}

