/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.logic;

import com.github.franckyi.ibeeditor.client.ClientContext;
import com.github.franckyi.ibeeditor.client.ClientUtil;
import com.github.franckyi.ibeeditor.client.ModScreenHandler;
import com.github.franckyi.ibeeditor.client.context.BlockEditorContext;
import com.github.franckyi.ibeeditor.client.context.EntityEditorContext;
import com.github.franckyi.ibeeditor.client.context.ItemEditorContext;
import com.github.franckyi.ibeeditor.common.EditorType;
import com.github.franckyi.ibeeditor.common.ModTexts;
import com.github.franckyi.ibeeditor.common.network.BlockEditorPacket;
import com.github.franckyi.ibeeditor.common.network.BlockInventoryItemEditorPacket;
import com.github.franckyi.ibeeditor.common.network.EntityEditorPacket;
import com.github.franckyi.ibeeditor.common.network.EntityInventoryItemEditorPacket;
import com.github.franckyi.ibeeditor.common.network.MainHandItemEditorPacket;
import com.github.franckyi.ibeeditor.common.network.NetworkManager;
import com.github.franckyi.ibeeditor.common.network.PlayerInventoryItemEditorPacket;
import com.github.franckyi.ibeeditor.mixin.AbstractContainerScreenMixin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public final class ClientEditorRequestLogic {
    public static void requestWorldEditor(EditorType editorType) {
        if (!(ClientEditorRequestLogic.requestEntityEditor(editorType) || ClientEditorRequestLogic.requestBlockEditor(editorType) || ClientEditorRequestLogic.requestMainHandItemEditor(editorType))) {
            ClientEditorRequestLogic.requestSelfEditor(editorType);
        }
    }

    public static boolean requestEntityEditor(EditorType editorType) {
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult res = (EntityHitResult)hitResult;
            Entity entity = res.m_82443_();
            if (ClientContext.isModInstalledOnServer()) {
                NetworkManager.sendToServer(NetworkManager.ENTITY_EDITOR_REQUEST, new EntityEditorPacket.Request(editorType, entity.m_19879_()));
            } else {
                CompoundTag tag = new CompoundTag();
                entity.m_20223_(tag);
                ModScreenHandler.openEditor(editorType, new EntityEditorContext(tag, (Component)ModTexts.errorServerModRequired(ModTexts.ENTITY), true, null));
            }
            return true;
        }
        return false;
    }

    public static boolean requestBlockEditor(EditorType editorType) {
        BlockHitResult res;
        HitResult hitResult = Minecraft.m_91087_().f_91077_;
        if (hitResult instanceof BlockHitResult && (res = (BlockHitResult)hitResult).m_6662_() != HitResult.Type.MISS) {
            BlockPos blockPos = res.m_82425_();
            if (ClientContext.isModInstalledOnServer()) {
                NetworkManager.sendToServer(NetworkManager.BLOCK_EDITOR_REQUEST, new BlockEditorPacket.Request(editorType, blockPos));
            } else {
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                BlockState blockState = level.m_8055_(blockPos);
                BlockEntity blockEntity = level.m_7702_(blockPos);
                CompoundTag tag = blockEntity == null ? null : blockEntity.m_187481_();
                ModScreenHandler.openEditor(editorType, new BlockEditorContext(blockState, tag, (Component)ModTexts.errorServerModRequired(ModTexts.BLOCK), null));
            }
            return true;
        }
        return false;
    }

    public static boolean requestMainHandItemEditor(EditorType editorType) {
        ItemStack item = Minecraft.m_91087_().f_91074_.m_21205_();
        if (item.m_41619_()) {
            return false;
        }
        if (ClientContext.isModInstalledOnServer()) {
            NetworkManager.sendToServer(NetworkManager.MAIN_HAND_ITEM_EDITOR_REQUEST, new MainHandItemEditorPacket.Request(editorType));
        } else if (Minecraft.m_91087_().f_91074_.m_7500_()) {
            ModScreenHandler.openEditor(editorType, new ItemEditorContext(item, null, true, context -> Minecraft.m_91087_().f_91074_.f_108617_.m_295327_((Packet)new ServerboundSetCreativeModeSlotPacket(Minecraft.m_91087_().f_91074_.m_150109_().f_35977_ + 36, context.getItemStack()))));
        } else {
            ModScreenHandler.openEditor(editorType, new ItemEditorContext(item, (Component)ModTexts.errorServerModRequired(ModTexts.ITEM), true, null));
        }
        return true;
    }

    public static void requestSelfEditor(EditorType editorType) {
        LocalPlayer entity = Minecraft.m_91087_().f_91074_;
        if (ClientContext.isModInstalledOnServer()) {
            NetworkManager.sendToServer(NetworkManager.ENTITY_EDITOR_REQUEST, new EntityEditorPacket.Request(editorType, entity.m_19879_()));
        }
    }

    public static boolean requestInventoryItemEditor(EditorType editorType, AbstractContainerScreen<?> screen) {
        Slot slot = ((AbstractContainerScreenMixin)screen).getHoveredSlot();
        if (slot != null && slot.m_6657_()) {
            EntityHitResult res;
            BlockHitResult res2;
            int slotIndex = slot.m_150661_();
            if (slot.f_40218_ instanceof Inventory) {
                boolean creativeInventoryScreen = false;
                if (screen instanceof CreativeModeInventoryScreen) {
                    CreativeModeInventoryScreen c = (CreativeModeInventoryScreen)screen;
                    creativeInventoryScreen = true;
                    if (c.m_258017_()) {
                        slotIndex = ClientUtil.convertCreativeInventorySlot(slotIndex);
                    }
                }
                if (ClientContext.isModInstalledOnServer()) {
                    NetworkManager.sendToServer(NetworkManager.PLAYER_INVENTORY_ITEM_EDITOR_REQUEST, new PlayerInventoryItemEditorPacket.Request(editorType, slotIndex, creativeInventoryScreen));
                } else if (Minecraft.m_91087_().f_91074_.m_7500_()) {
                    ModScreenHandler.openEditor(editorType, new ItemEditorContext(slot.m_7993_(), null, true, context -> slot.m_5852_(context.getItemStack())));
                } else {
                    ModScreenHandler.openEditor(editorType, new ItemEditorContext(slot.m_7993_(), (Component)ModTexts.errorServerModRequired(ModTexts.ITEM), true, null));
                }
                return true;
            }
            HitResult hitResult = Minecraft.m_91087_().f_91077_;
            if (hitResult instanceof BlockHitResult && Minecraft.m_91087_().f_91073_.m_7702_((res2 = (BlockHitResult)hitResult).m_82425_()) instanceof Container) {
                if (ClientContext.isModInstalledOnServer()) {
                    NetworkManager.sendToServer(NetworkManager.BLOCK_INVENTORY_ITEM_EDITOR_REQUEST, new BlockInventoryItemEditorPacket.Request(editorType, slotIndex, res2.m_82425_()));
                }
                return true;
            }
            hitResult = Minecraft.m_91087_().f_91077_;
            if (hitResult instanceof EntityHitResult && (res = (EntityHitResult)hitResult).m_82443_() instanceof Container && ClientContext.isModInstalledOnServer()) {
                NetworkManager.sendToServer(NetworkManager.ENTITY_INVENTORY_ITEM_EDITOR_REQUEST, new EntityInventoryItemEditorPacket.Request(editorType, slotIndex, res.m_82443_().m_19879_()));
            }
        }
        return false;
    }
}

