/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.screen.model;

import com.github.franckyi.databindings.api.ObjectProperty;
import com.github.franckyi.databindings.api.ObservableBooleanValue;
import com.github.franckyi.databindings.api.ObservableList;
import com.github.franckyi.databindings.api.StringProperty;
import com.github.franckyi.guapi.api.Guapi;
import com.github.franckyi.guapi.api.mvc.Model;
import com.github.franckyi.ibeeditor.client.screen.model.category.CategoryModel;
import com.github.franckyi.ibeeditor.client.util.texteditor.TextEditorActionHandler;

public abstract class CategoryEntryScreenModel<C extends CategoryModel>
implements Model {
    protected final ObservableBooleanValue validProperty;
    protected final ObservableList<C> categories = ObservableList.create();
    protected final ObjectProperty<CategoryModel> selectedCategory = ObjectProperty.create();
    protected final ObjectProperty<TextEditorActionHandler> activeTextEditorProperty = ObjectProperty.create();
    protected final StringProperty textEditorCustomColorProperty = StringProperty.create("#ffffff");

    public CategoryEntryScreenModel() {
        this.validProperty = this.getCategories().allMatch(CategoryModel::isValid, CategoryModel::validProperty);
    }

    @Override
    public void initalize() {
        this.setupCategories();
        if (this.getCategories().size() > 0) {
            this.setSelectedCategory((CategoryModel)this.getCategories().get(0));
        }
    }

    protected abstract void setupCategories();

    public abstract void apply();

    public void update() {
        this.apply();
        Guapi.getScreenHandler().hideScene();
    }

    public ObservableList<C> getCategories() {
        return this.categories;
    }

    public CategoryModel getSelectedCategory() {
        return (CategoryModel)this.selectedCategoryProperty().getValue();
    }

    public ObjectProperty<CategoryModel> selectedCategoryProperty() {
        return this.selectedCategory;
    }

    public void setSelectedCategory(CategoryModel value) {
        this.selectedCategoryProperty().setValue(value);
    }

    public boolean isValid() {
        return this.validProperty().getValue();
    }

    public ObservableBooleanValue validProperty() {
        return this.validProperty;
    }

    public TextEditorActionHandler getActiveTextEditor() {
        return (TextEditorActionHandler)this.activeTextEditorProperty().getValue();
    }

    public ObjectProperty<TextEditorActionHandler> activeTextEditorProperty() {
        return this.activeTextEditorProperty;
    }

    public void setActiveTextEditor(TextEditorActionHandler value) {
        this.activeTextEditorProperty().setValue(value);
    }

    public String getTextEditorCustomColor() {
        return (String)this.textEditorCustomColor().getValue();
    }

    public StringProperty textEditorCustomColor() {
        return this.textEditorCustomColorProperty;
    }

    public void setTextEditorCustomColor(String value) {
        this.textEditorCustomColor().setValue(value);
    }
}

