/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.screen.model;

import com.github.franckyi.databindings.api.ObservableBooleanValue;
import com.github.franckyi.databindings.api.StringProperty;
import com.github.franckyi.ibeeditor.client.context.EditorContext;
import com.github.franckyi.ibeeditor.client.screen.model.EditorModel;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.nbt.TagParser;

public class SNBTEditorModel
implements EditorModel {
    private final EditorContext<?> context;
    private final StringProperty valueProperty;
    private final ObservableBooleanValue validProperty;

    public SNBTEditorModel(EditorContext<?> context) {
        this.context = context;
        this.valueProperty = StringProperty.create(context.getTag().toString());
        this.validProperty = this.valueProperty.mapToBoolean(value -> {
            try {
                return TagParser.m_129359_((String)value) != null;
            }
            catch (CommandSyntaxException e) {
                return false;
            }
        });
    }

    public String getValue() {
        return (String)this.valueProperty().getValue();
    }

    public StringProperty valueProperty() {
        return this.valueProperty;
    }

    public void setValue(String value) {
        this.valueProperty().setValue(value);
    }

    @Override
    public void apply() {
        try {
            this.context.setTag(TagParser.m_129359_((String)this.getValue()));
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EditorContext<?> getContext() {
        return this.context;
    }

    @Override
    public ObservableBooleanValue validProperty() {
        return this.validProperty;
    }
}

