/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.screen.model.category.item;

import com.github.franckyi.ibeeditor.client.screen.model.ItemEditorModel;
import com.github.franckyi.ibeeditor.client.screen.model.category.CategoryModel;
import com.github.franckyi.ibeeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.franckyi.ibeeditor.client.screen.model.entry.EntryModel;
import com.github.franckyi.ibeeditor.client.screen.model.entry.item.AttributeModifierEntryModel;
import com.github.franckyi.ibeeditor.common.ModTexts;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ItemAttributeModifiersCategoryModel
extends ItemEditorCategoryModel {
    private ListTag newAttributeModifiers;

    public ItemAttributeModifiersCategoryModel(ItemEditorModel editor) {
        super((Component)ModTexts.ATTRIBUTE_MODIFIERS, editor);
    }

    @Override
    protected void setupEntries() {
        this.getTag().m_128437_("AttributeModifiers", 10).stream().map(CompoundTag.class::cast).map(this::createModifierEntry).forEach(this.getEntries()::add);
    }

    @Override
    public int getEntryListStart() {
        return 0;
    }

    @Override
    public int getEntryHeight() {
        return 50;
    }

    @Override
    public EntryModel createNewListEntry() {
        return this.createModifierEntry(null);
    }

    private EntryModel createModifierEntry(CompoundTag tag) {
        if (tag != null) {
            String attributeName = tag.m_128461_("AttributeName");
            String slot = tag.m_128461_("Slot");
            int operation = tag.m_128451_("Operation");
            double amount = tag.m_128459_("Amount");
            UUID uuid = tag.m_128342_("UUID");
            return new AttributeModifierEntryModel((CategoryModel)this, attributeName, slot, operation, amount, uuid, this::addAttributeModifier);
        }
        return new AttributeModifierEntryModel(this, this::addAttributeModifier);
    }

    @Override
    protected MutableComponent getAddListEntryButtonTooltip() {
        return ModTexts.MODIFIER;
    }

    @Override
    public void apply() {
        this.newAttributeModifiers = new ListTag();
        super.apply();
        if (!this.newAttributeModifiers.isEmpty()) {
            this.getOrCreateTag().m_128365_("AttributeModifiers", (Tag)this.newAttributeModifiers);
        } else if (this.getOrCreateTag().m_128441_("AttributeModifiers")) {
            this.getOrCreateTag().m_128473_("AttributeModifiers");
        }
    }

    private void addAttributeModifier(String attributeName, String slot, int operation, double amount, UUID uuid) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("AttributeName", attributeName);
        if (!"all".equals(slot)) {
            tag.m_128359_("Slot", slot);
        }
        tag.m_128405_("Operation", operation);
        tag.m_128347_("Amount", amount);
        tag.m_128362_("UUID", uuid);
        this.newAttributeModifiers.add((Object)tag);
    }
}

