/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.screen.model.entry.item;

import com.github.franckyi.databindings.api.IntegerProperty;
import com.github.franckyi.ibeeditor.client.ClientCache;
import com.github.franckyi.ibeeditor.client.screen.model.category.CategoryModel;
import com.github.franckyi.ibeeditor.client.screen.model.category.item.ItemEditorCategoryModel;
import com.github.franckyi.ibeeditor.client.screen.model.entry.EntryModel;
import com.github.franckyi.ibeeditor.client.screen.model.entry.SelectionEntryModel;
import com.github.franckyi.ibeeditor.client.screen.model.selection.element.ListSelectionElementModel;
import com.github.franckyi.ibeeditor.common.ModTexts;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.network.chat.MutableComponent;

public class EnchantmentEntryModel
extends SelectionEntryModel {
    private final IntegerProperty levelProperty;
    private final BiConsumer<String, Integer> action;
    protected int defaultLevel;

    public EnchantmentEntryModel(CategoryModel category, String id, int level, BiConsumer<String, Integer> action) {
        super(category, (MutableComponent)null, id, (Consumer<String>)null);
        this.levelProperty = IntegerProperty.create(level);
        this.action = action;
        this.defaultLevel = level;
    }

    public int getLevel() {
        return this.levelProperty().getValue();
    }

    public IntegerProperty levelProperty() {
        return this.levelProperty;
    }

    public void setLevel(int value) {
        this.levelProperty().setValue(value);
    }

    @Override
    public void apply() {
        this.action.accept((String)this.getValue(), this.getLevel());
        this.defaultValue = this.getValue();
        this.defaultLevel = this.getLevel();
    }

    @Override
    public void reset() {
        super.reset();
        this.setLevel(this.defaultLevel);
    }

    @Override
    public ItemEditorCategoryModel getCategory() {
        return (ItemEditorCategoryModel)super.getCategory();
    }

    @Override
    public EntryModel.Type getType() {
        return EntryModel.Type.ENCHANTMENT;
    }

    @Override
    public List<String> getSuggestions() {
        return ClientCache.getEnchantmentSuggestions();
    }

    @Override
    public MutableComponent getSelectionScreenTitle() {
        return ModTexts.ENCHANTMENT;
    }

    @Override
    public List<? extends ListSelectionElementModel> getSelectionItems() {
        return ClientCache.getSortedEnchantmentSelectionItems(this.getCategory().getParent().getContext().getItemStack());
    }
}

