/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.screen.view;

import com.github.franckyi.guapi.api.GuapiHelper;
import com.github.franckyi.guapi.api.mvc.View;
import com.github.franckyi.guapi.api.node.HBox;
import com.github.franckyi.guapi.api.node.Label;
import com.github.franckyi.guapi.api.node.Node;
import com.github.franckyi.guapi.api.node.TextField;
import com.github.franckyi.guapi.api.node.builder.HBoxBuilder;
import com.github.franckyi.guapi.api.node.builder.TextFieldBuilder;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class NBTTagView
implements View {
    private final ResourceLocation texture;
    private final MutableComponent tooltip;
    private Predicate<String> validator;
    private HBox root;
    private TextField nameField;
    private Label separator;
    private TextField valueField;

    public NBTTagView(ResourceLocation texture, MutableComponent tooltip, Predicate<String> validator) {
        this(texture, tooltip);
        this.validator = validator;
    }

    public NBTTagView(ResourceLocation texture, MutableComponent tooltip) {
        this.texture = texture;
        this.tooltip = tooltip;
    }

    @Override
    public void build() {
        this.root = GuapiHelper.hBox(root -> {
            root.add((Node)GuapiHelper.imageView(this.texture, 16, 16).tooltip(new Component[]{this.tooltip}));
            this.nameField = (TextField)((TextFieldBuilder)GuapiHelper.textField().prefHeight(14)).prefWidth(120);
            root.add(this.nameField);
            this.separator = GuapiHelper.label(":");
            root.add(this.separator);
            this.valueField = (TextField)GuapiHelper.textField().prefHeight(14);
            root.add(this.valueField);
            ((HBoxBuilder)root.spacing(5)).align(GuapiHelper.CENTER_LEFT);
        });
        if (this.validator != null) {
            this.valueField.setValidator(this.validator);
        }
    }

    @Override
    public HBox getRoot() {
        return this.root;
    }

    public TextField getNameField() {
        return this.nameField;
    }

    public Label getSeparator() {
        return this.separator;
    }

    public TextField getValueField() {
        return this.valueField;
    }
}

