/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.util.texteditor;

import com.github.franckyi.ibeeditor.client.util.texteditor.ColorFormatting;
import com.github.franckyi.ibeeditor.client.util.texteditor.Formatting;
import com.github.franckyi.ibeeditor.client.util.texteditor.StyleFormatting;
import com.github.franckyi.ibeeditor.client.util.texteditor.StyleType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;

public class TextEditorInputParser {
    private final List<Formatting> formattings = new ArrayList<Formatting>();
    private int index;

    public void parse(MutableComponent text) {
        ComponentContents componentContents = text.m_214077_();
        if (componentContents instanceof PlainTextContents) {
            PlainTextContents lc = (PlainTextContents)componentContents;
            int length = lc.m_305315_().length();
            if (text.m_7383_().m_131154_()) {
                this.addStyleFormatting(new StyleFormatting(this.index, this.index + length, StyleType.BOLD));
            }
            if (text.m_7383_().m_131161_()) {
                this.addStyleFormatting(new StyleFormatting(this.index, this.index + length, StyleType.ITALIC));
            }
            if (text.m_7383_().m_131171_()) {
                this.addStyleFormatting(new StyleFormatting(this.index, this.index + length, StyleType.UNDERLINED));
            }
            if (text.m_7383_().m_131168_()) {
                this.addStyleFormatting(new StyleFormatting(this.index, this.index + length, StyleType.STRIKETHROUGH));
            }
            if (text.m_7383_().m_131176_()) {
                this.addStyleFormatting(new StyleFormatting(this.index, this.index + length, StyleType.OBFUSCATED));
            }
            if (text.m_7383_().m_131135_() != null) {
                this.addColorFormatting(new ColorFormatting(this.index, this.index + length, text.m_7383_().m_131135_().toString()));
            }
            this.index += lc.m_305315_().length();
        }
        if (text.m_7360_() != null) {
            text.m_7360_().stream().filter(MutableComponent.class::isInstance).map(MutableComponent.class::cast).forEach(this::parse);
        }
    }

    private void addStyleFormatting(StyleFormatting formatting) {
        Optional<StyleFormatting> merge = this.formattings.stream().filter(StyleFormatting.class::isInstance).map(StyleFormatting.class::cast).filter(other -> other.getType() == formatting.getType() && other.getEnd() == formatting.getStart()).findAny();
        if (merge.isPresent()) {
            merge.get().setEnd(formatting.getEnd());
        } else {
            this.formattings.add(formatting);
        }
    }

    private void addColorFormatting(ColorFormatting formatting) {
        Optional<ColorFormatting> merge = this.formattings.stream().filter(ColorFormatting.class::isInstance).map(ColorFormatting.class::cast).filter(other -> Objects.equals(other.getColor(), formatting.getColor()) && other.getEnd() == formatting.getStart()).findAny();
        if (merge.isPresent()) {
            merge.get().setEnd(formatting.getEnd());
        } else {
            this.formattings.add(formatting);
        }
    }

    public List<Formatting> getFormattings() {
        return this.formattings;
    }
}

