/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.common;

import com.github.franckyi.ibeeditor.common.CommonConfiguration;
import com.github.franckyi.ibeeditor.common.EditorType;
import com.github.franckyi.ibeeditor.common.logic.ServerEditorCommandLogic;
import com.github.franckyi.ibeeditor.common.network.EditorCommandPacket;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ServerCommandHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void registerCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder subCommand;
        LOGGER.debug("Registering /ibe command");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"ibe").executes(ServerCommandHandler.createCommand(p -> ServerEditorCommandLogic.commandOpenEditor(p, EditorTargetArgument.DEFAULT, EditorTypeArgument.DEFAULT)));
        for (EditorTypeArgument editorTypeArgument : EditorTypeArgument.values()) {
            subCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)editorTypeArgument.literal).executes(ServerCommandHandler.createCommand(p -> ServerEditorCommandLogic.commandOpenEditor(p, EditorTargetArgument.DEFAULT, typeArg.type)));
            for (EditorTargetArgument editorTargetArgument : EditorTargetArgument.values()) {
                subCommand.then(Commands.m_82127_((String)editorTargetArgument.literal).executes(ServerCommandHandler.createCommand(p -> ServerEditorCommandLogic.commandOpenEditor(p, targetArg.target, typeArg.type))));
            }
            command.then((ArgumentBuilder)subCommand);
        }
        for (Enum enum_ : EditorTargetArgument.values()) {
            subCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)((EditorTargetArgument)enum_).literal).executes(ServerCommandHandler.createCommand(arg_0 -> ServerCommandHandler.lambda$registerCommand$3((EditorTargetArgument)enum_, arg_0)));
            for (Enum enum_2 : EditorTypeArgument.values()) {
                subCommand.then(Commands.m_82127_((String)((EditorTypeArgument)enum_2).literal).executes(ServerCommandHandler.createCommand(arg_0 -> ServerCommandHandler.lambda$registerCommand$4((EditorTargetArgument)enum_, (EditorTypeArgument)enum_2, arg_0))));
            }
            command.then((ArgumentBuilder)subCommand);
        }
        command.requires(source -> source.m_6761_(CommonConfiguration.INSTANCE.getPermissionLevel()));
        dispatcher.register(command);
    }

    private static Command<CommandSourceStack> createCommand(Function<ServerPlayer, Integer> command) {
        return ctx -> (Integer)command.apply(((CommandSourceStack)ctx.getSource()).m_81375_());
    }

    private static /* synthetic */ Integer lambda$registerCommand$4(EditorTargetArgument targetArg, EditorTypeArgument typeArg, ServerPlayer p) {
        return ServerEditorCommandLogic.commandOpenEditor(p, targetArg.target, typeArg.type);
    }

    private static /* synthetic */ Integer lambda$registerCommand$3(EditorTargetArgument targetArg, ServerPlayer p) {
        return ServerEditorCommandLogic.commandOpenEditor(p, targetArg.target, EditorTypeArgument.DEFAULT);
    }

    private static enum EditorTypeArgument {
        NBT("nbt", EditorType.NBT),
        SNBT("snbt", EditorType.SNBT);

        private static final EditorType DEFAULT;
        private final String literal;
        private final EditorType type;

        private EditorTypeArgument(String literal, EditorType type) {
            this.literal = literal;
            this.type = type;
        }

        static {
            DEFAULT = EditorType.STANDARD;
        }
    }

    private static enum EditorTargetArgument {
        ITEM("item", EditorCommandPacket.Target.ITEM),
        BLOCK("block", EditorCommandPacket.Target.BLOCK),
        ENTITY("entity", EditorCommandPacket.Target.ENTITY),
        SELF("self", EditorCommandPacket.Target.SELF);

        private static final EditorCommandPacket.Target DEFAULT;
        private final String literal;
        private final EditorCommandPacket.Target target;

        private EditorTargetArgument(String literal, EditorCommandPacket.Target target) {
            this.literal = literal;
            this.target = target;
        }

        static {
            DEFAULT = EditorCommandPacket.Target.WORLD;
        }
    }
}

