/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.common.network;

import com.github.franckyi.ibeeditor.common.network.PacketSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public abstract class NetworkHandler<P> {
    private static int count;
    private final Class<P> type;
    private final ResourceLocation location;
    private final int id;
    private final PacketSerializer<P> serializer;

    protected NetworkHandler(Class<P> type, String location, PacketSerializer<P> serializer) {
        this.type = type;
        this.location = new ResourceLocation(location);
        this.id = count++;
        this.serializer = serializer;
    }

    public Class<P> getType() {
        return this.type;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public int getId() {
        return this.id;
    }

    public PacketSerializer<P> getSerializer() {
        return this.serializer;
    }

    public static class Server<P>
    extends NetworkHandler<P> {
        private final ServerPacketHandler<P> packetHandler;

        public Server(Class<P> type, String location, PacketSerializer<P> serializer, ServerPacketHandler<P> packetHandler) {
            super(type, location, serializer);
            this.packetHandler = packetHandler;
        }

        public ServerPacketHandler<P> getPacketHandler() {
            return this.packetHandler;
        }

        @FunctionalInterface
        public static interface ServerPacketHandler<P> {
            public void handle(ServerPlayer var1, P var2);
        }
    }

    public static class Client<P>
    extends NetworkHandler<P> {
        private final ClientPacketHandler<P> packetHandler;

        public Client(Class<P> type, String location, PacketSerializer<P> serializer, ClientPacketHandler<P> packetHandler) {
            super(type, location, serializer);
            this.packetHandler = packetHandler;
        }

        public ClientPacketHandler<P> getPacketHandler() {
            return this.packetHandler;
        }

        @FunctionalInterface
        public static interface ClientPacketHandler<P> {
            public void handle(P var1);
        }
    }
}

