/*
 * Decompiled with CFR 0.152.
 */
package creepskeet.improved.windows;

import creepskeet.improved.windows.capabilities.PaneListCapability;
import creepskeet.improved.windows.entity.ModEntityTypes;
import creepskeet.improved.windows.entity.PaneEntity;
import net.minecraft.block.Block;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="improved_windows", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class EventHandler {
    @SubscribeEvent
    public static void attachCapabilitiesEntity(AttachCapabilitiesEvent<Chunk> event) {
        if (event.getObject() instanceof Chunk) {
            event.addCapability(new ResourceLocation("improved_windows", "pane_list_capability"), (ICapabilityProvider)new PaneListCapability());
        }
    }

    @SubscribeEvent
    public static void onGlassPanePlacement(PlayerInteractEvent.RightClickBlock event) {
        Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
        Chunk chunk = (Chunk)event.getWorld().func_217349_x(event.getPos());
        LazyOptional paneList = chunk.getCapability(PaneListCapability.PANE_LIST_CAPABILITY).cast();
        paneList.ifPresent(list -> {
            if (list.isBlockPosSuitable(event.getPos()) && event.getItemStack().func_77973_b() instanceof BlockItem) {
                BlockItem item = (BlockItem)event.getItemStack().func_77973_b();
                if (item.func_179223_d() instanceof PaneBlock && (block instanceof StairsBlock || block instanceof SlabBlock)) {
                    item.func_179223_d();
                    PaneEntity glass = (PaneEntity)((EntityType)ModEntityTypes.PANE_ENTITY.get()).func_200721_a(event.getWorld());
                    glass.func_70107_b((double)event.getPos().func_177958_n() + 0.5, event.getPos().func_177956_o(), (double)event.getPos().func_177952_p() + 0.5);
                    glass.setPane(item);
                    event.getWorld().func_217376_c((Entity)glass);
                    if (!event.getPlayer().func_184812_l_()) {
                        event.getItemStack().func_190918_g(1);
                    }
                    event.setCanceled(true);
                }
            } else if (event.getItemStack().func_77973_b() == Items.field_151055_y && list.getList().containsKey(event.getPos())) {
                PaneEntity glass = list.getList().get(event.getPos());
                glass.func_70106_y();
            }
        });
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Chunk chunk = (Chunk)event.getWorld().func_217349_x(event.getPos());
        LazyOptional paneList = chunk.getCapability(PaneListCapability.PANE_LIST_CAPABILITY).cast();
        paneList.ifPresent(list -> {
            if (list.getList().containsKey(event.getPos())) {
                PaneEntity entity = list.getPane(event.getPos());
                entity.func_70106_y();
            }
        });
    }
}

