/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.items;

import com.beanbot.instrumentus.capability.ModEnergyStorageItem;
import com.beanbot.instrumentus.init.ModItemGroups;
import com.beanbot.instrumentus.items.ModEnergyToolCommon;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ModEnergyAxeItem
extends AxeItem {
    public ModEnergyAxeItem(IItemTier tier, float attackDamageIn, float attackSpeedIn) {
        super(tier, attackDamageIn, attackSpeedIn, new Item.Properties().func_200918_c(0).func_200917_a(1).func_200916_a(ModItemGroups.MOD_ITEM_GROUP));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack empty = new ItemStack((IItemProvider)this);
            items.add((Object)empty);
            ItemStack full = new ItemStack((IItemProvider)this);
            full.func_196082_o().func_74768_a("Energy", 20000);
            items.add((Object)full);
        }
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        IEnergyStorage storage;
        LazyOptional lazy = stack.getCapability(CapabilityEnergy.ENERGY);
        if (lazy.isPresent() && (storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new)).getEnergyStored() <= 0) {
            return 0.0f;
        }
        return super.func_150893_a(stack, state);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        LazyOptional lazy;
        PlayerEntity player;
        if (!stack.func_77942_o()) {
            return false;
        }
        if (entityLiving instanceof PlayerEntity && !(player = (PlayerEntity)entityLiving).func_184812_l_() && (lazy = stack.getCapability(CapabilityEnergy.ENERGY)).isPresent()) {
            IEnergyStorage storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new);
            if (state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
                storage.extractEnergy(8, false);
            }
        }
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = world.func_180495_p(blockpos);
        Block block = (Block)field_203176_a.get(blockstate.func_177230_c());
        ItemStack stack = context.func_195996_i();
        if (block != null) {
            PlayerEntity playerentity = context.func_195999_j();
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                LazyOptional lazy;
                world.func_180501_a(blockpos, (BlockState)block.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, blockstate.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M)), 11);
                if (playerentity != null && (lazy = stack.getCapability(CapabilityEnergy.ENERGY)).isPresent()) {
                    IEnergyStorage storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new);
                    storage.extractEnergy(8, false);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ModEnergyToolCommon.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        LazyOptional lazy = stack.getCapability(CapabilityEnergy.ENERGY);
        if (lazy.isPresent()) {
            IEnergyStorage storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new);
            return storage.getEnergyStored() != storage.getMaxEnergyStored();
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return ModEnergyToolCommon.getDurabilityForDisplay(stack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT nbt) {
        if (CapabilityEnergy.ENERGY == null) {
            return null;
        }
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return cap == CapabilityEnergy.ENERGY ? LazyOptional.of(() -> new ModEnergyStorageItem(stack, 20000, 32)).cast() : LazyOptional.empty();
            }
        };
    }
}

