/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.items;

import com.beanbot.instrumentus.capability.ModEnergyStorageItem;
import com.beanbot.instrumentus.items.ModEnergyToolCommon;
import com.beanbot.instrumentus.items.ModSickleItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ModEnergySickleItem
extends ModSickleItem {
    protected ItemTier material;

    public ModEnergySickleItem(ItemTier material) {
        super(material);
        this.material = material;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack empty = new ItemStack((IItemProvider)this);
            items.add((Object)empty);
            ItemStack full = new ItemStack((IItemProvider)this);
            full.func_196082_o().func_74768_a("Energy", 20000);
            items.add((Object)full);
        }
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        IEnergyStorage storage;
        LazyOptional lazy = stack.getCapability(CapabilityEnergy.ENERGY);
        if (lazy.isPresent() && (storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new)).getEnergyStored() <= 0) {
            return 0.0f;
        }
        return super.func_150893_a(stack, state);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ModEnergyToolCommon.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        LazyOptional lazy = stack.getCapability(CapabilityEnergy.ENERGY);
        if (lazy.isPresent()) {
            IEnergyStorage storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new);
            return storage.getEnergyStored() != storage.getMaxEnergyStored();
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return ModEnergyToolCommon.getDurabilityForDisplay(stack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT nbt) {
        if (CapabilityEnergy.ENERGY == null) {
            return null;
        }
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return cap == CapabilityEnergy.ENERGY ? LazyOptional.of(() -> new ModEnergyStorageItem(stack, 20000, 32)).cast() : LazyOptional.empty();
            }
        };
    }

    @Override
    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entity) {
        LazyOptional lazy;
        int height;
        if (state.func_177230_c() == null || world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a) {
            return false;
        }
        boolean isLeaves = state.func_185904_a() == Material.field_151584_j;
        int radius = isLeaves ? 0 : 2;
        int n = height = isLeaves ? 0 : 2;
        if (this.material == ItemTier.WOOD || this.material == ItemTier.STONE) {
            radius = 1;
            height = 1;
        }
        if (this.material == ItemTier.IRON || this.material == ItemTier.GOLD || this.material == ItemTier.DIAMOND) {
            radius = 2;
            height = 2;
        }
        if ((lazy = stack.getCapability(CapabilityEnergy.ENERGY)).isPresent()) {
            IEnergyStorage storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new);
            if (state.func_185887_b((IBlockReader)world, pos) != 0.0f) {
                storage.extractEnergy(8, false);
            }
        }
        int numberTrimmed = 0;
        if (isLeaves && !entity.func_213453_ef()) {
            numberTrimmed += this.trim(stack, entity, world, pos, height, radius, ModSickleItem.TrimType.TRIM_LEAVES, false, 40);
        } else {
            numberTrimmed += this.trim(stack, entity, world, pos, height, radius, ModSickleItem.TrimType.TRIM_GRASS_AND_FLOWERS, true, 70);
            if (world.field_73012_v.nextInt(3) == 0) {
                numberTrimmed += this.trim(stack, entity, world, pos, height, radius - 1, ModSickleItem.TrimType.TRIM_GRASS_AND_FLOWERS, false, 0);
            }
        }
        return numberTrimmed > 0;
    }

    @Override
    public int trim(ItemStack stack, LivingEntity entity, World world, BlockPos pos, int height, int radius, ModSickleItem.TrimType trimType, boolean cutCorners, int damagePercentChance) {
        int numberTrimmed = 0;
        int fortune = 0;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (dx == 0 && dy == 0 && dz == 0 || cutCorners && Math.abs(dz) >= 2 * radius || !trimType.trimAtPos(world, pos.func_177982_a(dx, dy, dz), fortune)) continue;
                    ++numberTrimmed;
                    LazyOptional lazy = stack.getCapability(CapabilityEnergy.ENERGY);
                    if (!lazy.isPresent()) continue;
                    IEnergyStorage storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new);
                    storage.extractEnergy(8, false);
                }
            }
        }
        return numberTrimmed;
    }

    public static enum TrimType {
        TRIM_GRASS_AND_FLOWERS,
        TRIM_LEAVES;


        public boolean trimAtPos(World world, BlockPos pos, int fortune) {
            BlockState state = world.func_180495_p(pos);
            switch (this) {
                case TRIM_LEAVES: {
                    if (state.func_185904_a() == Material.field_151584_j) {
                        world.func_175655_b(pos, true);
                        return true;
                    }
                    return false;
                }
            }
            if (state.func_185904_a() == Material.field_151582_l) {
                world.func_175655_b(pos, true);
                return true;
            }
            if (state.func_185904_a() == Material.field_151585_k) {
                world.func_175655_b(pos, true);
                return true;
            }
            return false;
        }
    }
}

