/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.util;

import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TooltipHelper {
    public static ITextComponent tipString(String text) {
        return new TranslationTextComponent(text, new Object[0]).func_211708_a(TextFormatting.GRAY);
    }

    public static ITextComponent tipString(String text, TextFormatting ... styles) {
        return TooltipHelper.tipString(text).func_211709_a(styles);
    }

    public static ITextComponent tipInt(int value) {
        return new TranslationTextComponent(NumberFormat.getNumberInstance(Locale.US).format(value), new Object[0]);
    }

    public static ITextComponent tipInt(int value, TextFormatting ... styles) {
        return TooltipHelper.tipInt(value).func_211709_a(styles);
    }

    public static ITextComponent newLine() {
        return new TranslationTextComponent(" ", new Object[0]);
    }

    public static ITextComponent chargeRatio(ItemStack stack) {
        LazyOptional lazy = stack.getCapability(CapabilityEnergy.ENERGY);
        if (lazy.isPresent()) {
            IEnergyStorage storage = (IEnergyStorage)lazy.orElse(null);
            TextFormatting storedColor = storage.getEnergyStored() != 0 ? TextFormatting.GREEN : TextFormatting.RED;
            return TooltipHelper.tipInt(storage.getEnergyStored(), storedColor).func_150257_a(TooltipHelper.tipString(" FE / ", TextFormatting.GRAY).func_150257_a(TooltipHelper.tipInt(storage.getMaxEnergyStored(), TextFormatting.GRAY)).func_150257_a(TooltipHelper.tipString(" FE", TextFormatting.GRAY)));
        }
        return TooltipHelper.tipString("");
    }
}

