/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;

public class EnergyStorageItem
extends EnergyStorage
implements ICapabilityProvider {
    private final LazyOptional<EnergyStorageItem> LAZY;
    private final ItemStack STACK;

    public EnergyStorageItem(ItemStack stack, int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
        this.STACK = stack;
        this.LAZY = LazyOptional.of(() -> this);
    }

    public EnergyStorageItem(ItemStack stack, int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
        this.STACK = stack;
        this.LAZY = LazyOptional.of(() -> this);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyStored = this.getEnergyStored();
        int energyReceived = Math.min(this.capacity - energyStored, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.setEnergyStored(energyStored + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyStored = this.getEnergyStored();
        int energyExtracted = Math.min(energyStored, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.setEnergyStored(energyStored - energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.STACK.func_196082_o().func_74762_e("Energy");
    }

    public void setEnergyStored(int amount) {
        this.STACK.func_196082_o().func_74768_a("Energy", amount);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityEnergy.ENERGY.orEmpty(cap, this.LAZY.cast());
    }
}

