/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.items;

import com.beanbot.instrumentus.common.capability.EnergyStorageItem;
import com.beanbot.instrumentus.common.items.EnergyToolCommon;
import com.beanbot.instrumentus.common.items.HammerItem;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyHammerItem
extends HammerItem {
    private static final Set<Block> EFFECTIVE_ON = ImmutableSet.of((Object)Blocks.field_150408_cc, (Object)Blocks.field_150365_q, (Object)Blocks.field_150347_e, (Object)Blocks.field_150319_E, (Object)Blocks.field_150484_ah, (Object)Blocks.field_150482_ag, (Object[])new Block[]{Blocks.field_196552_aC, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_205164_gk, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_196583_aj, Blocks.field_196585_ak, Blocks.field_196798_hA, Blocks.field_196799_hB, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_196650_c, Blocks.field_196652_d, Blocks.field_196654_e, Blocks.field_196655_f, Blocks.field_196656_g, Blocks.field_196657_h, Blocks.field_150333_U, Blocks.field_222401_hJ, Blocks.field_196640_bx, Blocks.field_196643_by, Blocks.field_196646_bz, Blocks.field_196571_bA, Blocks.field_196573_bB, Blocks.field_196575_bC, Blocks.field_196576_bD, Blocks.field_196578_bE, Blocks.field_185771_cX, Blocks.field_196581_bI, Blocks.field_196582_bJ, Blocks.field_196580_bH, Blocks.field_196579_bG, Blocks.field_150430_aB, Blocks.field_150456_au, Blocks.field_222446_lj, Blocks.field_222447_lk, Blocks.field_222448_ll, Blocks.field_222449_lm, Blocks.field_222450_ln, Blocks.field_222451_lo, Blocks.field_222452_lp, Blocks.field_222453_lq, Blocks.field_222454_lr, Blocks.field_222455_ls, Blocks.field_222456_lt, Blocks.field_222457_lu, Blocks.field_222458_lv, Blocks.field_204409_il, Blocks.field_190975_dA, Blocks.field_190988_dw, Blocks.field_190989_dx, Blocks.field_190986_du, Blocks.field_190984_ds, Blocks.field_190990_dy, Blocks.field_190980_do, Blocks.field_196875_ie, Blocks.field_190982_dq, Blocks.field_190979_dn, Blocks.field_190978_dm, Blocks.field_190983_dr, Blocks.field_190987_dv, Blocks.field_190991_dz, Blocks.field_190977_dl, Blocks.field_190981_dp});
    protected ItemTier material;

    public EnergyHammerItem(ItemTier material, float attackDamageIn, float attackSpeedIn) {
        super(material, attackSpeedIn, attackDamageIn);
        this.material = material;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack empty = new ItemStack((IItemProvider)this);
            items.add((Object)empty);
            ItemStack full = new ItemStack((IItemProvider)this);
            full.func_196082_o().func_74768_a("Energy", 20000);
            items.add((Object)full);
        }
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        IEnergyStorage storage;
        LazyOptional lazy = stack.getCapability(CapabilityEnergy.ENERGY);
        if (lazy.isPresent() && (storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new)).getEnergyStored() <= 0) {
            return 0.0f;
        }
        return super.func_150893_a(stack, state);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        LazyOptional lazy = stack.getCapability(CapabilityEnergy.ENERGY);
        if (lazy.isPresent()) {
            IEnergyStorage storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new);
            storage.extractEnergy(8, false);
        }
        return true;
    }

    @Override
    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entity) {
        int r;
        if (state.func_177230_c() == null || world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a) {
            return false;
        }
        boolean isRock = state.func_185904_a() == Material.field_151576_e || state.func_185904_a() == Material.field_151573_f || state.func_185904_a() == Material.field_151574_g;
        int n = r = isRock ? 0 : 2;
        if (this.material == ItemTier.WOOD || this.material == ItemTier.STONE || this.material == ItemTier.IRON || this.material == ItemTier.GOLD || this.material == ItemTier.DIAMOND) {
            r = 1;
        }
        stack.func_222118_a(1, entity, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
        int numberTrimmed = 0;
        if (isRock && !entity.func_213453_ef()) {
            numberTrimmed += this.trim(stack, entity, world, pos, r, HammerItem.TrimType.TRIM_ROCK, false, 100);
        }
        return numberTrimmed > 0;
    }

    @Override
    public int trim(ItemStack stack, LivingEntity entity, World world, BlockPos pos, int r, HammerItem.TrimType trimType, boolean cutCorners, int damagePercentChance) {
        int numberTrimmed;
        block7: {
            Vector3d look;
            int fortune;
            block8: {
                block6: {
                    numberTrimmed = 0;
                    fortune = 0;
                    look = entity.func_70040_Z();
                    if (!(look.field_72450_a >= -1.0 && look.field_72450_a <= -0.75) && (!(look.field_72450_a <= 1.0) || !(look.field_72450_a >= 0.75))) break block6;
                    for (int dz = -r; dz <= r; ++dz) {
                        for (int dy = -r; dy <= r; ++dy) {
                            if (dy == 0 && dz == 0 || !trimType.trimAtPos(world, pos.func_177982_a(0, dy, dz), fortune)) continue;
                            ++numberTrimmed;
                            LazyOptional lazy = stack.getCapability(CapabilityEnergy.ENERGY);
                            if (!lazy.isPresent()) continue;
                            IEnergyStorage storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new);
                            if (world.func_180495_p(pos).func_185887_b((IBlockReader)world, pos) == 0.0f) continue;
                            storage.extractEnergy(8, false);
                        }
                    }
                    break block7;
                }
                if (!(look.field_72449_c >= -1.0 && look.field_72449_c <= -0.75) && (!(look.field_72449_c <= 1.0) || !(look.field_72449_c >= 0.75))) break block8;
                for (int dx = -r; dx <= r; ++dx) {
                    for (int dy = -r; dy <= r; ++dy) {
                        if (dy == 0 && dx == 0 || !trimType.trimAtPos(world, pos.func_177982_a(dx, dy, 0), fortune)) continue;
                        ++numberTrimmed;
                        LazyOptional lazy = stack.getCapability(CapabilityEnergy.ENERGY);
                        if (!lazy.isPresent()) continue;
                        IEnergyStorage storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new);
                        if (world.func_180495_p(pos).func_185887_b((IBlockReader)world, pos) == 0.0f) continue;
                        storage.extractEnergy(8, false);
                    }
                }
                break block7;
            }
            if (!(look.field_72448_b >= -1.0 && look.field_72448_b <= -0.75) && (!(look.field_72448_b <= 1.0) || !(look.field_72448_b >= 0.75))) break block7;
            for (int dx = -r; dx <= r; ++dx) {
                for (int dz = -r; dz <= r; ++dz) {
                    if (dz == 0 && dx == 0 || !trimType.trimAtPos(world, pos.func_177982_a(dx, 0, dz), fortune)) continue;
                    ++numberTrimmed;
                    LazyOptional lazy = stack.getCapability(CapabilityEnergy.ENERGY);
                    if (!lazy.isPresent()) continue;
                    IEnergyStorage storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new);
                    if (world.func_180495_p(pos).func_185887_b((IBlockReader)world, pos) == 0.0f) continue;
                    storage.extractEnergy(8, false);
                }
            }
        }
        return numberTrimmed;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        EnergyToolCommon.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        LazyOptional lazy = stack.getCapability(CapabilityEnergy.ENERGY);
        if (lazy.isPresent()) {
            IEnergyStorage storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new);
            return storage.getEnergyStored() != storage.getMaxEnergyStored();
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return EnergyToolCommon.getDurabilityForDisplay(stack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT nbt) {
        if (CapabilityEnergy.ENERGY == null) {
            return null;
        }
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return cap == CapabilityEnergy.ENERGY ? LazyOptional.of(() -> new EnergyStorageItem(stack, 20000, 32)).cast() : LazyOptional.empty();
            }
        };
    }

    public static enum TrimType {
        TRIM_ROCK;


        public boolean trimAtPos(World world, BlockPos pos, int fortune) {
            BlockState state = world.func_180495_p(pos);
            switch (this) {
                default: 
            }
            if (state.func_185904_a() == Material.field_151576_e || state.func_185904_a() == Material.field_151573_f || state.func_185904_a() == Material.field_151574_g) {
                world.func_175655_b(pos, true);
                return true;
            }
            return false;
        }
    }
}

