/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.items;

import com.beanbot.instrumentus.common.capability.EnergyStorageItem;
import com.beanbot.instrumentus.common.init.ModItemGroups;
import com.beanbot.instrumentus.common.items.EnergyToolCommon;
import com.beanbot.instrumentus.common.items.ModShearsItem;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyShearsItem
extends ModShearsItem {
    public EnergyShearsItem(ItemTier material) {
        super(material, new Item.Properties().func_200917_a(1).func_200918_c(0).func_200916_a(ModItemGroups.MOD_ITEM_GROUP));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack empty = new ItemStack((IItemProvider)this);
            items.add((Object)empty);
            ItemStack full = new ItemStack((IItemProvider)this);
            full.func_196082_o().func_74768_a("Energy", 20000);
            items.add((Object)full);
        }
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        IEnergyStorage storage;
        LazyOptional lazy = stack.getCapability(CapabilityEnergy.ENERGY);
        if (lazy.isPresent() && (storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new)).getEnergyStored() <= 0) {
            return 0.0f;
        }
        return super.func_150893_a(stack, state);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        LazyOptional lazy;
        PlayerEntity player;
        if (!stack.func_77942_o()) {
            return false;
        }
        if (entityLiving instanceof PlayerEntity && !(player = (PlayerEntity)entityLiving).func_184812_l_() && (lazy = stack.getCapability(CapabilityEnergy.ENERGY)).isPresent()) {
            IEnergyStorage storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new);
            if (state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
                storage.extractEnergy(8, false);
            }
        }
        return true;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        LazyOptional lazy = stack.getCapability(CapabilityEnergy.ENERGY);
        if (lazy.isPresent()) {
            IEnergyStorage storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new);
            storage.extractEnergy(8, false);
        }
        return true;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity entity, Hand hand) {
        if (entity.field_70170_p.field_72995_K) {
            return ActionResultType.PASS;
        }
        if (entity instanceof IForgeShearable) {
            IForgeShearable target = (IForgeShearable)entity;
            BlockPos pos = new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            if (target.isShearable(stack, entity.field_70170_p, pos)) {
                List drops = target.onSheared(playerIn, stack, entity.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack));
                Random rand = new Random();
                drops.forEach(d -> {
                    ItemEntity ent = entity.func_70099_a(d, 1.0f);
                    ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                });
                LazyOptional lazy = stack.getCapability(CapabilityEnergy.ENERGY);
                if (lazy.isPresent()) {
                    IEnergyStorage storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new);
                    storage.extractEnergy(8, false);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        EnergyToolCommon.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        LazyOptional lazy = stack.getCapability(CapabilityEnergy.ENERGY);
        if (lazy.isPresent()) {
            IEnergyStorage storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new);
            return storage.getEnergyStored() != storage.getMaxEnergyStored();
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return EnergyToolCommon.getDurabilityForDisplay(stack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT nbt) {
        if (CapabilityEnergy.ENERGY == null) {
            return null;
        }
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return cap == CapabilityEnergy.ENERGY ? LazyOptional.of(() -> new EnergyStorageItem(stack, 20000, 32)).cast() : LazyOptional.empty();
            }
        };
    }
}

