/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyToolCommon {
    static final int CAPACITY = 20000;
    static final int MAX_TRANSFER = 32;
    static final String ENERGY_TAG = "Energy";

    public static float getChargeRatio(ItemStack stack) {
        LazyOptional lazy = stack.getCapability(CapabilityEnergy.ENERGY);
        if (lazy.isPresent()) {
            IEnergyStorage storage = (IEnergyStorage)lazy.orElseThrow(IllegalStateException::new);
            return (float)storage.getEnergyStored() / (float)storage.getMaxEnergyStored();
        }
        return 0.0f;
    }

    static void addInformation(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (CapabilityEnergy.ENERGY == null) {
            return;
        }
        LazyOptional lazy = stack.getCapability(CapabilityEnergy.ENERGY);
        if (lazy.isPresent()) {
            IEnergyStorage storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new);
            TranslationTextComponent energyText = new TranslationTextComponent("instrumentus.lore.energy", new Object[]{String.format("%,d", storage.getEnergyStored()), String.format("%,d", storage.getMaxEnergyStored())});
            if (storage.getEnergyStored() == 0) {
                energyText = new TranslationTextComponent("instrumentus.lore.no_energy");
                tooltip.add((ITextComponent)energyText.func_240699_a_(TextFormatting.DARK_RED));
            } else {
                tooltip.add((ITextComponent)energyText.func_240699_a_(TextFormatting.DARK_GREEN));
            }
        }
    }

    static boolean showDurabilityBar(ItemStack stack) {
        LazyOptional lazy = stack.getCapability(CapabilityEnergy.ENERGY);
        if (lazy.isPresent()) {
            IEnergyStorage storage = (IEnergyStorage)lazy.orElseThrow(AssertionError::new);
            return storage.getEnergyStored() != storage.getMaxEnergyStored();
        }
        return false;
    }

    static double getDurabilityForDisplay(ItemStack stack) {
        return 1.0f - EnergyToolCommon.getChargeRatio(stack);
    }
}

