/*
 * Decompiled with CFR 0.152.
 */
package com.beanbot.instrumentus.common.items;

import com.beanbot.instrumentus.common.init.ModItemGroups;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.ToolItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SickleItem
extends ToolItem {
    private static final Set<Block> EFFECTIVE_ON = ImmutableSet.of((Object)Blocks.field_196572_aa, (Object)Blocks.field_196647_Y, (Object)Blocks.field_196574_ab, (Object)Blocks.field_196648_Z, (Object)Blocks.field_196642_W, (Object)Blocks.field_196645_X, (Object[])new Block[0]);
    protected ItemTier material;

    public SickleItem(ItemTier material) {
        super(material.func_200929_c(), 1.0f, (IItemTier)material, EFFECTIVE_ON, new Item.Properties().func_200917_a(1).func_200916_a(ModItemGroups.MOD_ITEM_GROUP).func_200918_c(material.func_200926_a()));
        this.material = material;
    }

    public boolean func_150897_b(BlockState blockIn) {
        Block block = blockIn.func_177230_c();
        Material material = blockIn.func_185904_a();
        return material == Material.field_151584_j;
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entity) {
        int height;
        if (state.func_177230_c() == null || world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a) {
            return false;
        }
        boolean isLeaves = state.func_185904_a() == Material.field_151584_j;
        int radius = isLeaves ? 0 : 2;
        int n = height = isLeaves ? 0 : 2;
        if (this.material == ItemTier.WOOD || this.material == ItemTier.STONE) {
            radius = 1;
            height = 1;
        }
        if (this.material == ItemTier.IRON || this.material == ItemTier.GOLD || this.material == ItemTier.DIAMOND) {
            radius = 2;
            height = 2;
        }
        if (this.material == ItemTier.NETHERITE) {
            radius = 3;
            height = 3;
        }
        stack.func_222118_a(1, entity, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
        int numberTrimmed = 0;
        if (isLeaves && !entity.func_213453_ef()) {
            numberTrimmed += this.trim(stack, entity, world, pos, height, radius, TrimType.TRIM_LEAVES, false, 40);
        } else {
            numberTrimmed += this.trim(stack, entity, world, pos, height, radius, TrimType.TRIM_GRASS_AND_FLOWERS, true, 70);
            if (world.field_73012_v.nextInt(3) == 0) {
                numberTrimmed += this.trim(stack, entity, world, pos, height, radius - 1, TrimType.TRIM_GRASS_AND_FLOWERS, false, 0);
            }
        }
        return numberTrimmed > 0;
    }

    public int trim(ItemStack stack, LivingEntity entity, World world, BlockPos pos, int height, int radius, TrimType trimType, boolean cutCorners, int damagePercentChance) {
        int numberTrimmed = 0;
        int fortune = 0;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (dx == 0 && dy == 0 && dz == 0 || cutCorners && Math.abs(dz) >= 2 * radius || !trimType.trimAtPos(world, pos.func_177982_a(dx, dy, dz), fortune)) continue;
                    ++numberTrimmed;
                    if (world.field_73012_v.nextInt(100) >= damagePercentChance) continue;
                    stack.func_222118_a(1, entity, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
                }
            }
        }
        return numberTrimmed;
    }

    public static enum TrimType {
        TRIM_GRASS_AND_FLOWERS,
        TRIM_LEAVES;


        public boolean trimAtPos(World world, BlockPos pos, int fortune) {
            BlockState state = world.func_180495_p(pos);
            switch (this) {
                case TRIM_LEAVES: {
                    if (state.func_185904_a() == Material.field_151584_j) {
                        world.func_175655_b(pos, true);
                        return true;
                    }
                    return false;
                }
            }
            if (state.func_185904_a() == Material.field_151582_l) {
                world.func_175655_b(pos, true);
                return true;
            }
            if (state.func_185904_a() == Material.field_151585_k) {
                world.func_175655_b(pos, true);
                return true;
            }
            return false;
        }
    }
}

