/*
 * Decompiled with CFR 0.152.
 */
package info.beanbot.morepaxels.client.player;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import info.beanbot.morepaxels.init.ModItems;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class PlayerSpecials {
    public static final PlayerSpecials INSTANCE = new PlayerSpecials();
    private Multimap<UUID, IDevRenderer> renderMap = ArrayListMultimap.create();

    private PlayerSpecials() {
        this.renderMap.put((Object)UUID.fromString("d1af5f04-c4cc-486f-b187-fcb0a745bda6"), (Object)new RenderBack(new ItemStack(ModItems.GoldPaxel)));
        this.renderMap.put((Object)UUID.fromString("9a0c55e2-635d-4b7b-aa62-b8fab574af35"), (Object)new RenderBack(new ItemStack(ModItems.ManaSteelPaxel)));
        this.renderMap.put((Object)UUID.fromString("92914230-9d52-4333-b3ba-e53d97393b6d"), (Object)new RenderBack(new ItemStack(ModItems.ElementiumPaxel)));
        this.renderMap.put((Object)UUID.fromString("7b6d348f-7ee3-4e67-ac03-234b51fe355f"), (Object)new RenderBack(new ItemStack(ModItems.ThaumiumPaxel)));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void init() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPLayerRenderPre(RenderLivingEvent.Pre event) {
        if (this.nameIsGood((Entity)event.entity)) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
    }

    @SubscribeEvent
    public void onPlayerRenderPost(RenderLivingEvent.Post event) {
        if (this.nameIsGood((Entity)event.entity)) {
            GL11.glDisable((int)3042);
        }
    }

    @SubscribeEvent
    public void onPlayerRenderSpecialPre(RenderPlayerEvent.Specials.Pre event) {
        Collection renders = this.renderMap.get((Object)event.entityPlayer.func_110124_au());
        for (IDevRenderer r : renders) {
            r.renderExtras(event.entityPlayer, false);
        }
    }

    @SubscribeEvent
    public void onPlayerRenderSpecialPost(RenderPlayerEvent.Specials.Post event) {
        Collection renders = this.renderMap.get((Object)event.entityPlayer.func_110124_au());
        for (IDevRenderer r : renders) {
            r.renderExtras(event.entityPlayer, true);
        }
    }

    private boolean nameIsGood(Entity entity) {
        return EnumChatFormatting.func_110646_a((String)entity.func_70005_c_()).equals("Beanxxbot") || EnumChatFormatting.func_110646_a((String)entity.func_70005_c_()).equals("TheDiscoCreeper") || EnumChatFormatting.func_110646_a((String)entity.func_70005_c_()).equals("Rajecent") || EnumChatFormatting.func_110646_a((String)entity.func_70005_c_()).equals("Hermyone");
    }

    private class RenderBack
    implements IDevRenderer {
        private ItemStack toRender;

        private RenderBack(ItemStack toRender) {
            this.toRender = toRender;
        }

        @Override
        public void renderExtras(EntityPlayer player, boolean post) {
            if (!post) {
                GL11.glPushMatrix();
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
                if (player.func_70093_af()) {
                    GL11.glRotatef((float)28.64789f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                boolean armor = player.func_82169_q(2) != null;
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.075f, (float)-0.2f, (float)(armor ? 0.2f : 0.14f));
                GL11.glScalef((float)0.25f, (float)0.25f, (float)0.25f);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                int light = 0xF000F0;
                int lightmapX = light % 65536;
                int lightmapY = light / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightmapX, (float)lightmapY);
                IIcon icon = this.toRender.func_77954_c();
                ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
                GL11.glPopMatrix();
            }
        }

        @Override
        public void renderPlayer(EntityPlayer player, boolean post) {
        }
    }

    private static interface IDevRenderer {
        public void renderPlayer(EntityPlayer var1, boolean var2);

        public void renderExtras(EntityPlayer var1, boolean var2);
    }
}

