/*
 * Decompiled with CFR 0.152.
 */
package info.beanbot.morepaxels.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import info.beanbot.morepaxels.MorePaxels;
import info.beanbot.morepaxels.item.ToolHelper;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;

public abstract class ItemAOETool
extends ItemTool {
    public int breakRadius = 1;
    public int breakDepth = 0;
    protected Random random = new Random();

    public ItemAOETool(float damage, Item.ToolMaterial material, Set blocks) {
        super(damage, material, blocks);
        this.field_77777_bU = 1;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        Block block = player.field_70170_p.func_147439_a(x, y, z);
        int meta = player.field_70170_p.func_72805_g(x, y, z);
        if (block == null || !this.isEffective(block, meta) || !stack.func_77942_o()) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        MovingObjectPosition mop = ToolHelper.raytraceFromEntity(player.field_70170_p, (Entity)player, false, 4.5);
        if (mop == null) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        int sideHit = mop.field_72310_e;
        int xRange = this.breakRadius;
        int yRange = this.breakRadius;
        int zRange = this.breakDepth;
        switch (sideHit) {
            case 0: 
            case 1: {
                yRange = this.breakDepth;
                zRange = this.breakRadius;
                break;
            }
            case 2: 
            case 3: {
                xRange = this.breakRadius;
                zRange = this.breakDepth;
                break;
            }
            case 4: 
            case 5: {
                xRange = this.breakDepth;
                zRange = this.breakRadius;
            }
        }
        for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
            for (int yPos = y - yRange; yPos <= y + yRange; ++yPos) {
                for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                    if (xPos == x && yPos == y && zPos == z || super.onBlockStartBreak(stack, xPos, yPos, zPos, player)) continue;
                    this.breakExtraBlock(player.field_70170_p, xPos, yPos, zPos, sideHit, player, x, y, z);
                }
            }
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    protected abstract Material[] getEffectiveMaterials();

    protected abstract String getHarvestType();

    public boolean isEffective(Block block, int meta) {
        if (this.getHarvestType().equals(block.getHarvestTool(meta))) {
            return true;
        }
        return this.isEffective(block.func_149688_o());
    }

    public boolean isEffective(Material material) {
        for (Material m : this.getEffectiveMaterials()) {
            if (m != material) continue;
            return true;
        }
        return false;
    }

    protected void breakExtraBlock(World world, int x, int y, int z, int sidehit, EntityPlayer playerEntity, int refX, int refY, int refZ) {
        int meta;
        if (world.func_147437_c(x, y, z)) {
            return;
        }
        if (!(playerEntity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)playerEntity;
        Block block = world.func_147439_a(x, y, z);
        if (!this.isEffective(block, meta = world.func_72805_g(x, y, z))) {
            return;
        }
        Block refBlock = world.func_147439_a(refX, refY, refZ);
        float refStrength = ForgeHooks.blockStrength((Block)refBlock, (EntityPlayer)player, (World)world, (int)refX, (int)refY, (int)refZ);
        float strength = ForgeHooks.blockStrength((Block)block, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z);
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (int)meta) || refStrength / strength > 10.0f) {
            return;
        }
        BlockEvent.BreakEvent event = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (int)x, (int)y, (int)z);
        if (event.isCanceled()) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_149681_a(world, x, y, z, meta, (EntityPlayer)player);
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, false)) {
                block.func_149664_b(world, x, y, z, meta);
            }
            if (!world.field_72995_K) {
                player.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
            }
            return;
        }
        player.func_71045_bC().func_150999_a(world, block, x, y, z, (EntityPlayer)player);
        if (!world.field_72995_K) {
            block.func_149681_a(world, x, y, z, meta, (EntityPlayer)player);
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
                block.func_149636_a(world, (EntityPlayer)player, x, y, z, meta);
                block.func_149657_c(world, x, y, z, event.getExpToDrop());
            }
            player.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
        } else {
            ItemStack itemstack;
            world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
            }
            if ((itemstack = player.func_71045_bC()) != null) {
                itemstack.func_150999_a(world, block, x, y, z, (EntityPlayer)player);
                if (itemstack.field_77994_a == 0) {
                    player.func_71028_bD();
                }
            }
            if (MorePaxels.extraBlockUpdates) {
                Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C07PacketPlayerDigging(2, x, y, z, Minecraft.func_71410_x().field_71476_x.field_72310_e));
            }
        }
    }

    public String func_77658_a() {
        return String.format("item.%s%s", "Instrumentus".toLowerCase() + ":", this.getUnwrappedUnlocalizedName(super.func_77658_a()));
    }

    public String func_77667_c(ItemStack itemStack) {
        return String.format("item.%s%s", "Instrumentus".toLowerCase() + ":", this.getUnwrappedUnlocalizedName(super.func_77658_a()));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_77658_a().substring(this.func_77658_a().indexOf(".") + 1));
    }

    protected String getUnwrappedUnlocalizedName(String unlocalizedName) {
        return unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
    }
}

