/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.common.drop.action;

import java.util.List;
import java.util.Locale;
import mod.lucky.common.GameAPI;
import mod.lucky.common.GameAPIKt;
import mod.lucky.common.Logger;
import mod.lucky.common.UtilsKt;
import mod.lucky.common.Vec3;
import mod.lucky.common.attribute.Attr;
import mod.lucky.common.attribute.AttrType;
import mod.lucky.common.attribute.AttributeKt;
import mod.lucky.common.attribute.DictAttr;
import mod.lucky.common.attribute.ListAttr;
import mod.lucky.common.attribute.ValueAttr;
import mod.lucky.common.drop.DropContext;
import mod.lucky.common.drop.DropError;
import mod.lucky.common.drop.SingleDrop;
import mod.lucky.jetbrains.annotations.NotNull;
import mod.lucky.jetbrains.annotations.Nullable;
import mod.lucky.kotlin.Metadata;
import mod.lucky.kotlin.collections.CollectionsKt;
import mod.lucky.kotlin.jvm.internal.Intrinsics;
import mod.lucky.kotlin.ranges.IntRange;
import mod.lucky.kotlin.text.StringsKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a6\u0010\u0000\u001a\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u00032\u0006\u0010\b\u001a\u00020\t\u001aX\u0010\n\u001a\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0016\b\u0002\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001j\u0004\u0018\u0001`\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0016\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0016\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0016\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0016\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0016\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0016\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0016\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0016\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0016\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0016\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014\u001a,\u0010\u001f\u001a\u00020\u00122\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020 0\u0001j\u0002`!2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0018\u0010\"\u001a\u0004\u0018\u00010\u000f2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000f\u00a8\u0006%"}, d2={"adjustY", "Lmod/lucky/common/Vec3;", "", "Lmod/lucky/common/Vec3d;", "world", "", "Lmod/lucky/common/World;", "pos", "adjustRange", "Lmod/lucky/kotlin/ranges/IntRange;", "calculatePos", "drop", "Lmod/lucky/common/drop/SingleDrop;", "default", "posKey", "", "offsetKey", "doBlockDrop", "", "context", "Lmod/lucky/common/drop/DropContext;", "doCommandDrop", "doDifficultyDrop", "doEntityDrop", "doExplosionDrop", "doFillDrop", "doItemDrop", "doMessageDrop", "doParticleDrop", "doSoundDrop", "doTimeDrop", "setBlock", "", "Lmod/lucky/common/Vec3i;", "withBlockMode", "mode", "blockId", "common"})
public final class DropActionsKt {
    @NotNull
    public static final Vec3<Double> adjustY(@NotNull Object world, @NotNull Vec3<Double> pos, @NotNull IntRange adjustRange) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(adjustRange, "adjustRange");
        int n = adjustRange.getFirst();
        int n2 = adjustRange.getLast();
        if (n <= n2) {
            int y;
            do {
                y = n++;
                Vec3<Double> newPos = new Vec3<Double>(pos.getX(), (Double)((Number)(pos.getY() + (double)y)), pos.getZ());
                if (!GameAPIKt.getGAME_API().isAirBlock(world, newPos.floor())) continue;
                return newPos;
            } while (y != n2);
        }
        return pos;
    }

    @NotNull
    public static final Vec3<Double> calculatePos(@NotNull SingleDrop drop, @Nullable Vec3<Double> vec3, @Nullable Object world, @NotNull String posKey, @Nullable String offsetKey) {
        Vec3<Double> posWithOffset;
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(posKey, "posKey");
        Vec3<Double> basePos = drop.getVec3(posKey, vec3);
        Vec3 centerOffset = SingleDrop.getVec3$default(drop, "centerOffset", null, 2, null);
        String string = offsetKey;
        if (string == null) {
            string = "posOffset";
        }
        Vec3 posOffset = SingleDrop.getVec3$default(drop, string, null, 2, null);
        Vec3<Double> vec32 = !Intrinsics.areEqual(centerOffset, UtilsKt.getZeroVec3d()) ? UtilsKt.getWorldPos(posOffset, centerOffset, basePos, ((Number)SingleDrop.get$default(drop, "rotation", null, 2, null)).intValue()) : (posWithOffset = !Intrinsics.areEqual(posOffset, UtilsKt.getZeroVec3d()) ? basePos.plus(posOffset) : basePos);
        if (world == null) {
            return posWithOffset;
        }
        ListAttr adjustList = (ListAttr)SingleDrop.get$default(drop, "adjustY", null, 2, null);
        IntRange adjustRange = new IntRange(((Number)adjustList.getValue(0)).intValue(), ((Number)adjustList.getValue(1)).intValue());
        return DropActionsKt.adjustY(world, posWithOffset, adjustRange);
    }

    public static /* synthetic */ Vec3 calculatePos$default(SingleDrop singleDrop, Vec3 vec3, Object object, String string, String string2, int n, Object object2) {
        if ((n & 2) != 0) {
            vec3 = null;
        }
        if ((n & 4) != 0) {
            object = null;
        }
        if ((n & 8) != 0) {
            string = "pos";
        }
        if ((n & 0x10) != 0) {
            string2 = "posOffset";
        }
        return DropActionsKt.calculatePos(singleDrop, vec3, object, string, string2);
    }

    @Nullable
    public static final String withBlockMode(@NotNull String mode, @NotNull String blockId) {
        String string;
        Intrinsics.checkNotNullParameter(mode, "mode");
        Intrinsics.checkNotNullParameter(blockId, "blockId");
        switch (mode) {
            case "air": {
                if (!Intrinsics.areEqual(blockId, "minecraft:air")) {
                    string = "minecraft:air";
                    break;
                }
                string = null;
                break;
            }
            case "overlay": {
                if (!Intrinsics.areEqual(blockId, "minecraft:air")) {
                    string = blockId;
                    break;
                }
                string = null;
                break;
            }
            case "replace": {
                string = blockId;
                break;
            }
            default: {
                Logger.DefaultImpls.logError$default(GameAPIKt.getGAME_API(), "Invalid block mode '" + mode + '\'', null, 2, null);
                string = null;
            }
        }
        return string;
    }

    public static final void setBlock(@NotNull Object world, @NotNull Vec3<Integer> pos, @NotNull SingleDrop drop) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(drop, "drop");
        if (!drop.contains("id")) {
            throw new DropError("Missing block ID");
        }
        String string = DropActionsKt.withBlockMode((String)SingleDrop.get$default(drop, "blockMode", null, 2, null), (String)SingleDrop.get$default(drop, "id", null, 2, null));
        if (string == null) {
            return;
        }
        String blockId = string;
        GameAPIKt.getGAME_API().setBlock(world, pos, blockId, (DictAttr)drop.getOrNull("state"), (DictAttr)drop.getOrNull("components"), UtilsKt.positiveMod(((Number)SingleDrop.get$default(drop, "facing", null, 2, null)).intValue() + ((Number)SingleDrop.get$default(drop, "rotation", null, 2, null)).intValue(), 4), (Boolean)SingleDrop.get$default(drop, "blockUpdate", null, 2, null));
        if (drop.contains("nbttag")) {
            GameAPIKt.getGAME_API().setBlockEntity(world, pos, (DictAttr)SingleDrop.get$default(drop, "nbttag", null, 2, null));
        }
    }

    public static final void doBlockDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        Vec3<Integer> pos = DropActionsKt.calculatePos$default(drop, context.getPos(), context.getWorld(), null, null, 24, null).floor();
        DropActionsKt.setBlock(context.getWorld(), pos, drop);
    }

    public static final void doFillDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        Vec3<Integer> pos = DropActionsKt.calculatePos$default(drop, context.getPos(), context.getWorld(), null, null, 24, null).floor();
        Vec3<Integer> pos2 = drop.contains("pos2") ? DropActionsKt.calculatePos$default(drop, null, context.getWorld(), "pos2", "posOffset2", 2, null).floor() : pos.plus(SingleDrop.getVec3$default(drop, "size", null, 2, null)).minus(new Vec3<Number>(1, 1, 1));
        IntRange xRange = new IntRange(Math.min(pos.getX(), pos2.getX()), Math.max(pos.getX(), pos2.getX()));
        IntRange yRange = new IntRange(Math.min(pos.getY(), pos2.getY()), Math.max(pos.getY(), pos2.getY()));
        IntRange zRange = new IntRange(Math.min(pos.getZ(), pos2.getZ()), Math.max(pos.getZ(), pos2.getZ()));
        int n = xRange.getFirst();
        int n2 = xRange.getLast();
        if (n <= n2) {
            int x;
            do {
                int y;
                int n3;
                x = n++;
                int n4 = yRange.getFirst();
                if (n4 > (n3 = yRange.getLast())) continue;
                do {
                    int z;
                    int n5;
                    y = n4++;
                    int n6 = zRange.getFirst();
                    if (n6 > (n5 = zRange.getLast())) continue;
                    do {
                        z = n6++;
                        DropActionsKt.setBlock(context.getWorld(), new Vec3<Number>(x, y, z), drop);
                    } while (z != n5);
                } while (y != n3);
            } while (x != n2);
        }
    }

    public static final void doItemDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        GameAPIKt.getGAME_API().dropItem(context.getWorld(), DropActionsKt.calculatePos$default(drop, context.getPos(), context.getWorld(), null, null, 24, null), (String)SingleDrop.get$default(drop, "id", null, 2, null), (DictAttr)drop.getOrNull("nbttag"), (DictAttr)drop.getOrNull("components"));
    }

    public static final void doMessageDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        Object player;
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        Object object = context.getPlayer();
        if (object == null) {
            object = GameAPIKt.getGAME_API().getNearestPlayer(context.getWorld(), DropActionsKt.calculatePos$default(drop, context.getPos(), context.getWorld(), null, null, 24, null));
        }
        if ((player = object) != null) {
            GameAPIKt.getGAME_API().sendMessage(player, (String)SingleDrop.get$default(drop, "id", null, 2, null));
        }
    }

    public static final void doCommandDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        GameAPIKt.getGAME_API().runCommand(context.getWorld(), DropActionsKt.calculatePos$default(drop, context.getPos(), context.getWorld(), null, null, 24, null), (String)SingleDrop.get$default(drop, "id", null, 2, null), (String)SingleDrop.get$default(drop, "commandSender", null, 2, null), (Boolean)SingleDrop.get$default(drop, "displayOutput", null, 2, null));
    }

    public static final void doDifficultyDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        String string;
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        String value = (String)SingleDrop.get$default(drop, "id", null, 2, null);
        String string2 = value.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        String string3 = string2;
        String[] stringArray = new String[]{"peacful", "p", "0"};
        if (CollectionsKt.listOf(stringArray).contains(string3)) {
            string = "peacful";
        } else {
            stringArray = new String[]{"easy", "3", "1"};
            if (CollectionsKt.listOf(stringArray).contains(string3)) {
                string = "easy";
            } else {
                stringArray = new String[]{"normal", "n", "2"};
                if (CollectionsKt.listOf(stringArray).contains(string3)) {
                    string = "normal";
                } else {
                    stringArray = new String[]{"hard", "h", "3"};
                    if (CollectionsKt.listOf(stringArray).contains(string3)) {
                        string = "hard";
                    } else {
                        Logger.DefaultImpls.logError$default(GameAPIKt.getGAME_API(), Intrinsics.stringPlus("Invalid diffictulty: ", value), null, 2, null);
                        return;
                    }
                }
            }
        }
        String difficulty = string;
        GameAPIKt.getGAME_API().setDifficulty(context.getWorld(), difficulty);
    }

    public static final void doTimeDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        long l;
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        Attr attr = drop.getProps().get("id");
        if (attr == null) {
            throw new NullPointerException("null cannot be cast to non-null type mod.lucky.common.attribute.ValueAttr");
        }
        ValueAttr timeAttr = (ValueAttr)attr;
        if (AttributeKt.isNumType(timeAttr.getType())) {
            l = (Long)AttributeKt.castNum(AttrType.LONG, (Number)timeAttr.getValue());
        } else {
            String string = (String)timeAttr.getValue();
            if (Intrinsics.areEqual(string, "day")) {
                l = 1000L;
            } else if (Intrinsics.areEqual(string, "night")) {
                l = 13000L;
            } else {
                Logger.DefaultImpls.logError$default(GameAPIKt.getGAME_API(), Intrinsics.stringPlus("Invalid time: ", timeAttr.getValue()), null, 2, null);
                return;
            }
        }
        long time = l;
        GameAPIKt.getGAME_API().setTime(context.getWorld(), time);
    }

    public static final void doSoundDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        Vec3 pos = DropActionsKt.calculatePos$default(drop, context.getPos(), context.getWorld(), null, null, 24, null);
        GameAPIKt.getGAME_API().playSound(context.getWorld(), pos, (String)SingleDrop.get$default(drop, "id", null, 2, null), ((Number)SingleDrop.get$default(drop, "volume", null, 2, null)).doubleValue(), ((Number)SingleDrop.get$default(drop, "pitch", null, 2, null)).doubleValue());
    }

    public static final void doExplosionDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        Vec3<Number> pos = DropActionsKt.calculatePos$default(drop, context.getPos(), context.getWorld(), null, null, 24, null).plus(new Vec3<Number>(0.0, 0.5, 0.0));
        GameAPIKt.getGAME_API().createExplosion(context.getWorld(), pos, ((Number)SingleDrop.get$default(drop, "damage", null, 2, null)).doubleValue(), (Boolean)SingleDrop.get$default(drop, "fire", null, 2, null));
    }

    public static final void doParticleDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        Attr attr = drop.getProps().get("id");
        if (attr == null) {
            throw new NullPointerException("null cannot be cast to non-null type mod.lucky.common.attribute.ValueAttr");
        }
        ValueAttr effectIdAttr = (ValueAttr)attr;
        Vec3 pos = DropActionsKt.calculatePos$default(drop, context.getPos(), context.getWorld(), null, null, 24, null);
        int particleData = ((Number)SingleDrop.get$default(drop, "damage", null, 2, null)).intValue();
        if (AttributeKt.isNumType(effectIdAttr.getType())) {
            int particleIdInt = (Integer)AttributeKt.castNum(AttrType.INT, (Number)effectIdAttr.getValue());
            GameAPIKt.getGAME_API().playParticleEvent(context.getWorld(), pos, particleIdInt, particleData);
        } else {
            String particleId = (String)effectIdAttr.getValue();
            if (StringsKt.equals(particleId, "splashpotion", true)) {
                String potionName = (String)drop.getOrNull("potion");
                GameAPIKt.getGAME_API().playSplashPotionEvent(context.getWorld(), pos, potionName, potionName == null ? Integer.valueOf(particleData) : null);
            } else {
                char[] cArray = new char[]{'.'};
                List splitId = StringsKt.split$default((CharSequence)particleId, cArray, false, 0, 6, null);
                List<String> particleArgs = splitId.size() >= 2 ? splitId.subList(1, splitId.size()) : CollectionsKt.emptyList();
                GameAPIKt.getGAME_API().spawnParticle(context.getWorld(), pos, (String)splitId.get(0), particleArgs, SingleDrop.getVec3$default(drop, "size", null, 2, null), ((Number)SingleDrop.get$default(drop, "particleAmount", null, 2, null)).intValue());
            }
        }
    }

    public static final void doEntityDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        Vec3 pos = DropActionsKt.calculatePos$default(drop, context.getPos(), context.getWorld(), null, null, 24, null);
        if (!drop.contains("id")) {
            throw new DropError("Missing entity ID");
        }
        String initId = (String)SingleDrop.get$default(drop, "id", null, 2, null);
        String id = Intrinsics.areEqual(initId, "LightningBolt") ? "lightning_bolt" : initId;
        GameAPI gameAPI = GameAPIKt.getGAME_API();
        Object object = context.getWorld();
        DictAttr dictAttr = (DictAttr)SingleDrop.get$default(drop, "nbttag", null, 2, null);
        DictAttr dictAttr2 = (DictAttr)drop.getOrNull("components");
        Object object2 = context.getPlayer();
        String string = context.getSourceId();
        boolean bl = (Boolean)SingleDrop.get$default(drop, "randomizeMob", null, 2, null);
        double d = UtilsKt.positiveMod(((Number)SingleDrop.get$default(drop, "facing", null, 2, null)).doubleValue() + ((Number)SingleDrop.get$default(drop, "rotation", null, 2, null)).doubleValue(), 4.0);
        gameAPI.spawnEntity(object, id, pos, dictAttr, dictAttr2, d, bl, object2, string);
    }
}

