/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.java.loader;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mod.lucky.common.LoggerKt;
import mod.lucky.common.Vec3;
import mod.lucky.common.attribute.AttrType;
import mod.lucky.common.attribute.AttributeKt;
import mod.lucky.common.attribute.DictAttr;
import mod.lucky.common.drop.BaseDrop;
import mod.lucky.common.drop.DropStructure;
import mod.lucky.common.drop.DropStructureKt;
import mod.lucky.java.JavaGameAPIKt;
import mod.lucky.java.loader.LoaderKt;
import mod.lucky.java.loader.NbtStructureWithProps;
import mod.lucky.java.loader.ReadLegacySchematicKt;
import mod.lucky.java.loader.StructureWithProps;
import mod.lucky.java.loader.StructuresConfig;
import mod.lucky.java.loader.StructuresConfigKt;
import mod.lucky.jetbrains.annotations.NotNull;
import mod.lucky.kotlin.Metadata;
import mod.lucky.kotlin.Pair;
import mod.lucky.kotlin.TuplesKt;
import mod.lucky.kotlin.collections.MapsKt;
import mod.lucky.kotlin.jvm.internal.Intrinsics;
import mod.lucky.kotlin.text.StringsKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\"\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"readDropStructures", "", "", "Lmod/lucky/common/drop/DropStructure;", "baseDir", "Ljava/io/File;", "structuresConfig", "Lmod/lucky/java/loader/StructuresConfig;", "readNbtStructures", "Lmod/lucky/java/loader/NbtStructureWithProps;", "common"})
public final class ReadStructuresKt {
    @NotNull
    public static final Map<String, DropStructure> readDropStructures(@NotNull File baseDir, @NotNull StructuresConfig structuresConfig) {
        Object object;
        Object v;
        Map.Entry $dstr$_u24__u24$v;
        Object object2;
        Object k;
        Map.Entry it$iv$iv;
        Map<Object, Object> $this$mapValuesTo$iv$iv;
        Object k2;
        Map.Entry element$iv$iv;
        Map.Entry element$iv$iv$iv;
        Map $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(baseDir, "baseDir");
        Intrinsics.checkNotNullParameter(structuresConfig, "structuresConfig");
        Map<String, String> $this$mapNotNull$iv = StructuresConfigKt.getStructurePathsById(baseDir);
        boolean $i$f$mapNotNull = false;
        Map<String, String> map = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            InputStream it$iv$iv2;
            Object stream;
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry $dstr$k$path = element$iv$iv;
            boolean bl2 = false;
            k2 = (String)$dstr$k$path.getKey();
            String path = (String)$dstr$k$path.getValue();
            try {
                Pair<Object, DropStructure> pair;
                DropStructure dropStructure;
                if (StringsKt.endsWith$default((String)k2, ".luckystruct", false, 2, null)) {
                    InputStream inputStream = LoaderKt.getInputStream(baseDir, path);
                    Intrinsics.checkNotNull(inputStream);
                    stream = inputStream;
                    dropStructure = DropStructureKt.readDropStructure(LoaderKt.readLines((InputStream)stream));
                    pair = TuplesKt.to(k2, dropStructure);
                } else if (StringsKt.endsWith$default((String)k2, ".schematic", false, 2, null)) {
                    InputStream inputStream = LoaderKt.getInputStream(baseDir, path);
                    Intrinsics.checkNotNull(inputStream);
                    stream = inputStream;
                    dropStructure = ReadLegacySchematicKt.readLegacySchematic((InputStream)stream);
                    DictAttr props = dropStructure.component1();
                    List<BaseDrop> drops = dropStructure.component2();
                    pair = TuplesKt.to(k2, new DropStructure(props, drops));
                } else {
                    pair = null;
                }
                stream = pair;
            }
            catch (Exception e) {
                LoggerKt.getLOGGER().logError("Error reading structure '" + (String)k2 + "', path=" + path, e);
                stream = null;
            }
            if (stream == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv2);
        }
        Map dropStructures = MapsKt.toMap((List)destination$iv$iv);
        Map<Object, Object> $this$mapValues$iv = dropStructures;
        boolean $i$f$mapValues = false;
        $this$mapNotNullTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        iterator2 = $this$associateByTo$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            Object object3 = destination$iv$iv;
            boolean bl = false;
            k2 = element$iv$iv$iv;
            k = it$iv$iv.getKey();
            object2 = object3;
            boolean bl4 = false;
            v = (DropStructure)$dstr$_u24__u24$v.getValue();
            object = new StructureWithProps<DropStructure>(((DropStructure)v).getDefaultProps(), (DropStructure)v);
            object2.put(k, object);
        }
        $this$mapValues$iv = StructuresConfigKt.configureStructures(destination$iv$iv, structuresConfig);
        $i$f$mapValues = false;
        $this$mapValuesTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        iterator2 = $this$associateByTo$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            it$iv$iv = element$iv$iv$iv = iterator2.next();
            Object object4 = destination$iv$iv;
            boolean bl = false;
            $dstr$_u24__u24$v = element$iv$iv$iv;
            k = it$iv$iv.getKey();
            object2 = object4;
            boolean bl5 = false;
            v = (StructureWithProps)$dstr$_u24__u24$v.getValue();
            object = DropStructure.copy$default((DropStructure)((StructureWithProps)v).getStructure(), ((StructureWithProps)v).getProps(), null, 2, null);
            object2.put(k, object);
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final Map<String, NbtStructureWithProps> readNbtStructures(@NotNull File baseDir, @NotNull StructuresConfig structuresConfig) {
        Object object;
        Object v;
        Map.Entry $dstr$_u24__u24$v;
        Object object2;
        Object k;
        Map.Entry it$iv$iv;
        Map<Object, Object> $this$mapValuesTo$iv$iv;
        Object k2;
        Map.Entry element$iv$iv;
        Map.Entry element$iv$iv$iv;
        Map $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(baseDir, "baseDir");
        Intrinsics.checkNotNullParameter(structuresConfig, "structuresConfig");
        Map<String, String> $this$mapNotNull$iv = StructuresConfigKt.getStructurePathsById(baseDir);
        boolean $i$f$mapNotNull = false;
        Map<String, String> map = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            InputStream it$iv$iv2;
            Object stream;
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry $dstr$k$path = element$iv$iv;
            boolean bl2 = false;
            k2 = (String)$dstr$k$path.getKey();
            String path = (String)$dstr$k$path.getValue();
            try {
                Object object3;
                if (StringsKt.endsWith$default((String)k2, ".nbt", false, 2, null)) {
                    InputStream inputStream = LoaderKt.getInputStream(baseDir, path);
                    Intrinsics.checkNotNull(inputStream);
                    stream = inputStream;
                    Pair<Object, Vec3<Integer>> pair = JavaGameAPIKt.getJAVA_GAME_API().readNbtStructure((InputStream)stream);
                    Object structure = pair.component1();
                    Vec3<Integer> size = pair.component2();
                    Pair[] pairArray = new Pair[]{TuplesKt.to("size", AttributeKt.vec3AttrOf(AttrType.DOUBLE, size.toDouble()))};
                    DictAttr props = AttributeKt.dictAttrOf(pairArray);
                    object3 = TuplesKt.to(k2, new NbtStructureWithProps(props, structure));
                } else {
                    object3 = null;
                }
                stream = object3;
            }
            catch (Exception e) {
                LoggerKt.getLOGGER().logError("Error reading structure '" + (String)k2 + "', path=" + path, e);
                stream = null;
            }
            if (stream == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv2);
        }
        Map nbtStructures = MapsKt.toMap((List)destination$iv$iv);
        Map<Object, Object> $this$mapValues$iv = nbtStructures;
        boolean $i$f$mapValues = false;
        $this$mapNotNullTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        iterator2 = $this$associateByTo$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            Object object4 = destination$iv$iv;
            boolean bl = false;
            k2 = element$iv$iv$iv;
            k = it$iv$iv.getKey();
            object2 = object4;
            boolean bl4 = false;
            v = (NbtStructureWithProps)$dstr$_u24__u24$v.getValue();
            object = new StructureWithProps<NbtStructureWithProps>(((NbtStructureWithProps)v).getDefaultProps(), (NbtStructureWithProps)v);
            object2.put(k, object);
        }
        $this$mapValues$iv = StructuresConfigKt.configureStructures(destination$iv$iv, structuresConfig);
        $i$f$mapValues = false;
        $this$mapValuesTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        iterator2 = $this$associateByTo$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            it$iv$iv = element$iv$iv$iv = iterator2.next();
            Object object5 = destination$iv$iv;
            boolean bl = false;
            $dstr$_u24__u24$v = element$iv$iv$iv;
            k = it$iv$iv.getKey();
            object2 = object5;
            boolean bl5 = false;
            v = (StructureWithProps)$dstr$_u24__u24$v.getValue();
            object = NbtStructureWithProps.copy$default((NbtStructureWithProps)((StructureWithProps)v).getStructure(), ((StructureWithProps)v).getProps(), null, 2, null);
            object2.put(k, object);
        }
        return destination$iv$iv;
    }
}

