/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.common.drop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mod.lucky.common.DropTemplateContext;
import mod.lucky.common.GameAPIKt;
import mod.lucky.common.KotlinRandom;
import mod.lucky.common.LuckyRegistry;
import mod.lucky.common.UtilsKt;
import mod.lucky.common.attribute.Attr;
import mod.lucky.common.attribute.AttrSpec;
import mod.lucky.common.attribute.AttrType;
import mod.lucky.common.attribute.EvalContext;
import mod.lucky.common.attribute.EvaluatorKt;
import mod.lucky.common.attribute.ListSpec;
import mod.lucky.common.attribute.TemplateVar;
import mod.lucky.common.attribute.ValueAttr;
import mod.lucky.common.attribute.ValueSpec;
import mod.lucky.common.drop.BaseDrop;
import mod.lucky.common.drop.DropContext;
import mod.lucky.common.drop.DropError;
import mod.lucky.common.drop.GroupDrop;
import mod.lucky.common.drop.SingleDrop;
import mod.lucky.common.drop.SingleDropKt;
import mod.lucky.common.drop.WeightedDrop;
import mod.lucky.jetbrains.annotations.NotNull;
import mod.lucky.jetbrains.annotations.Nullable;
import mod.lucky.kotlin.Metadata;
import mod.lucky.kotlin.Pair;
import mod.lucky.kotlin.Triple;
import mod.lucky.kotlin.TuplesKt;
import mod.lucky.kotlin.Unit;
import mod.lucky.kotlin.collections.CollectionsKt;
import mod.lucky.kotlin.collections.IntIterator;
import mod.lucky.kotlin.collections.MapsKt;
import mod.lucky.kotlin.jvm.functions.Function2;
import mod.lucky.kotlin.jvm.internal.Intrinsics;
import mod.lucky.kotlin.ranges.IntRange;
import mod.lucky.kotlin.ranges.RangesKt;
import mod.lucky.kotlin.text.StringsKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u001a\u001e\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u00032\u0006\u0010\f\u001a\u00020\u0006H\u0002\u001a\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u001aK\u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00160\u00150\u00142\u0006\u0010\u0017\u001a\u00020\u00042\u0018\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\u0002\u0010\u001c\u001a\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000e\u001a\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u000e\u001a(\u0010#\u001a\u00020\u00062\u0016\u0010$\u001a\u0012\u0012\u0004\u0012\u00020&0%j\b\u0012\u0004\u0012\u00020&`'2\u0006\u0010(\u001a\u00020&H\u0002\u001a\u0014\u0010)\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u001a\u001e\u0010*\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0001\u001a\u0016\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0010\u001a\u0016\u0010/\u001a\u00020+2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0010\u001a0\u00100\u001a\u00020+2\u0010\b\u0002\u00101\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"DEBUG", "", "debugDropFilters", "", "", "debugDropIndex", "", "debugDropIndexRange", "Lmod/lucky/kotlin/ranges/IntRange;", "chooseRandomDrop", "Lmod/lucky/common/drop/WeightedDrop;", "drops", "luck", "createDropEvalContext", "Lmod/lucky/common/attribute/EvalContext;", "dropContext", "Lmod/lucky/common/drop/DropContext;", "drop", "Lmod/lucky/common/drop/SingleDrop;", "createVecSpec", "", "Lmod/lucky/kotlin/Pair;", "Lmod/lucky/common/attribute/AttrSpec;", "baseName", "partNames", "Lmod/lucky/kotlin/Triple;", "type", "Lmod/lucky/common/attribute/AttrType;", "(Ljava/lang/String;Lkotlin/Triple;Lmod/lucky/common/attribute/AttrType;)[Lkotlin/Pair;", "evalDrop", "template", "Lmod/lucky/common/drop/BaseDrop;", "context", "evalDropAfterDelay", "dropOrTemplate", "getDropIndexByWeight", "weightPoints", "Ljava/util/ArrayList;", "", "Lmod/lucky/kotlin/collections/ArrayList;", "randomIndex", "nextDebugDrop", "runDrop", "", "showOutput", "runDropAfterDelay", "delayedDrop", "runEvaluatedDrop", "runRandomDrop", "customDrops", "common"})
public final class DropEvaluatorKt {
    public static final boolean DEBUG = false;
    @NotNull
    private static List<String> debugDropFilters = CollectionsKt.emptyList();
    @NotNull
    private static IntRange debugDropIndexRange = new IntRange(0, 1000);
    private static int debugDropIndex = debugDropIndexRange.getFirst();

    @NotNull
    public static final EvalContext createDropEvalContext(@NotNull DropContext dropContext, @Nullable SingleDrop drop) {
        Intrinsics.checkNotNullParameter(dropContext, "dropContext");
        return new EvalContext((Map<String, ? extends Function2<? super TemplateVar, Object, ? extends Attr>>)LuckyRegistry.INSTANCE.getTemplateVarFns(), new DropTemplateContext(drop, dropContext, new KotlinRandom(null, 1, null)));
    }

    public static /* synthetic */ EvalContext createDropEvalContext$default(DropContext dropContext, SingleDrop singleDrop, int n, Object object) {
        if ((n & 2) != 0) {
            singleDrop = null;
        }
        return DropEvaluatorKt.createDropEvalContext(dropContext, singleDrop);
    }

    @NotNull
    public static final Pair<String, AttrSpec>[] createVecSpec(@NotNull String baseName, @NotNull Triple<String, String, String> partNames, @Nullable AttrType type) {
        Intrinsics.checkNotNullParameter(baseName, "baseName");
        Intrinsics.checkNotNullParameter(partNames, "partNames");
        Pair[] pairArray = new Pair[4];
        pairArray[0] = TuplesKt.to(partNames.getFirst(), new ValueSpec(type));
        pairArray[1] = TuplesKt.to(partNames.getSecond(), new ValueSpec(type));
        pairArray[2] = TuplesKt.to(partNames.getThird(), new ValueSpec(type));
        ValueSpec[] valueSpecArray = new ValueSpec[]{new ValueSpec(type), new ValueSpec(type), new ValueSpec(type)};
        pairArray[3] = TuplesKt.to(baseName, new ListSpec(CollectionsKt.listOf(valueSpecArray)));
        return pairArray;
    }

    public static /* synthetic */ Pair[] createVecSpec$default(String string, Triple triple, AttrType attrType, int n, Object object) {
        if ((n & 4) != 0) {
            attrType = null;
        }
        return DropEvaluatorKt.createVecSpec(string, triple, attrType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SingleDrop> evalDrop(@NotNull BaseDrop template, @NotNull EvalContext context) {
        Intrinsics.checkNotNullParameter(template, "template");
        Intrinsics.checkNotNullParameter(context, "context");
        if (template instanceof WeightedDrop) {
            return DropEvaluatorKt.evalDrop(((WeightedDrop)template).getDrop(), context);
        }
        if (template instanceof GroupDrop) {
            void $this$mapTo$iv$iv;
            List<BaseDrop> shuffledDrops = ((GroupDrop)template).getShuffle() ? CollectionsKt.shuffled((Iterable)((GroupDrop)template).getDrops()) : ((GroupDrop)template).getDrops();
            int groupAmount = (Integer)((ValueAttr)EvaluatorKt.evalAttr(((GroupDrop)template).getAmount(), context)).getValue();
            Iterable $this$map$iv = RangesKt.until(0, groupAmount);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DropEvaluatorKt.evalDrop(shuffledDrops.get((int)it), context));
            }
            return CollectionsKt.toList(CollectionsKt.flatten((List)destination$iv$iv));
        }
        if (template instanceof SingleDrop) {
            EvalContext contextWithDrop = context.getTemplateContext() instanceof DropTemplateContext ? EvalContext.copy$default(context, null, DropTemplateContext.copy$default((DropTemplateContext)context.getTemplateContext(), (SingleDrop)template, null, null, 6, null), 1, null) : context;
            SingleDrop drop = SingleDropKt.eval((SingleDrop)template, contextWithDrop);
            int repeatAmount = ((Number)SingleDrop.get$default(drop, "amount", null, 2, null)).intValue();
            boolean evalOnRepeat = (Boolean)SingleDrop.get$default(drop, "reinitialize", null, 2, null);
            boolean evalAfterDelay = (Boolean)SingleDrop.get$default(drop, "postDelayInit", null, 2, null);
            if (((SingleDrop)template).contains("delay")) {
                if (evalOnRepeat) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = RangesKt.until(0, repeatAmount);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    Iterator iterator3 = $this$mapTo$iv$iv.iterator();
                    while (iterator3.hasNext()) {
                        void it;
                        int item$iv$iv;
                        int n = item$iv$iv = ((IntIterator)iterator3).nextInt();
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(evalAfterDelay ? SingleDropKt.evalKeys((SingleDrop)template, CollectionsKt.listOf("delay"), contextWithDrop) : (it == false ? drop : SingleDropKt.eval((SingleDrop)template, contextWithDrop)));
                    }
                    return CollectionsKt.toList((List)destination$iv$iv);
                }
                return CollectionsKt.listOf(evalAfterDelay ? SingleDrop.copy$default((SingleDrop)template, null, ((SingleDrop)template).getProps().with(MapsKt.mapOf(TuplesKt.to("delay", SingleDrop.get$default(drop, "delay", null, 2, null)))), null, 5, null) : drop);
            }
            Iterable $this$map$iv = RangesKt.until(0, repeatAmount);
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator4 = $this$mapTo$iv$iv.iterator();
            while (iterator4.hasNext()) {
                int item$iv$iv;
                int it = item$iv$iv = ((IntIterator)iterator4).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it == 0 ? drop : (evalOnRepeat ? SingleDropKt.eval((SingleDrop)template, contextWithDrop) : drop));
            }
            return CollectionsKt.toList((List)destination$iv$iv);
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SingleDrop> evalDropAfterDelay(@NotNull SingleDrop dropOrTemplate, @NotNull EvalContext context) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(dropOrTemplate, "dropOrTemplate");
        Intrinsics.checkNotNullParameter(context, "context");
        boolean evalAfterDelay = (Boolean)SingleDrop.get$default(dropOrTemplate, "postDelayInit", null, 2, null);
        SingleDrop drop = evalAfterDelay ? SingleDropKt.eval(dropOrTemplate, context) : dropOrTemplate;
        boolean evalOnRepeat = (Boolean)SingleDrop.get$default(drop, "reinitialize", null, 2, null);
        if (evalOnRepeat) {
            return CollectionsKt.listOf(drop);
        }
        Iterable $this$map$iv = RangesKt.until(0, ((Number)SingleDrop.get$default(drop, "amount", null, 2, null)).intValue());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(drop);
        }
        return CollectionsKt.toList((List)destination$iv$iv);
    }

    private static final int getDropIndexByWeight(ArrayList<Double> weightPoints, double randomIndex) {
        int n = weightPoints.size();
        for (int i = 0; i < n; ++i) {
            Double d = weightPoints.get(i);
            Intrinsics.checkNotNullExpressionValue(d, "weightPoints[i]");
            if (!(randomIndex >= ((Number)d).doubleValue())) continue;
            Double d2 = weightPoints.get(i + 1);
            Intrinsics.checkNotNullExpressionValue(d2, "weightPoints[i + 1]");
            if (!(randomIndex < ((Number)d2).doubleValue())) continue;
            return i;
        }
        return 0;
    }

    private static final WeightedDrop chooseRandomDrop(List<WeightedDrop> drops, int luck) {
        if (drops.isEmpty()) {
            throw new DropError("No drops found");
        }
        int lowestLuck = 0;
        int heighestLuck = 0;
        int n = drops.size();
        for (int i = 0; i < n; ++i) {
            if (drops.get(i).getLuck() < lowestLuck) {
                lowestLuck = drops.get(i).getLuck();
            }
            if (drops.get(i).getLuck() <= heighestLuck) continue;
            heighestLuck = drops.get(i).getLuck();
        }
        heighestLuck += lowestLuck * -1 + 1;
        double levelIncrease = 1.0 / (1.0 - (double)(luck < 0 ? luck * -1 : luck) * 0.77 / 100.0);
        double weightTotal = 0.0;
        ArrayList<Double> weightPoints = new ArrayList<Double>();
        weightPoints.add(0.0);
        for (WeightedDrop drop : drops) {
            int dropLuck = drop.getLuck() + lowestLuck * -1 + 1;
            float newLuck = luck >= 0 ? (float)Math.pow(levelIncrease, dropLuck) : (float)Math.pow(levelIncrease, (double)(heighestLuck + 1) - (double)dropLuck);
            Double d = drop.getChance();
            double newChance = (d != null ? d : 1.0) * (double)newLuck * (double)100;
            weightPoints.add(weightTotal += newChance);
        }
        double randomIndex = UtilsKt.getDEFAULT_RANDOM().randDouble(0.0, 1.0) * weightTotal;
        return drops.get(DropEvaluatorKt.getDropIndexByWeight(weightPoints, randomIndex));
    }

    public static final void runEvaluatedDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        if (drop.contains("delay") && ((Number)SingleDrop.get$default(drop, "delay", null, 2, null)).doubleValue() > 0.0) {
            GameAPIKt.getGAME_API().scheduleDrop(drop, context, ((Number)SingleDrop.get$default(drop, "delay", null, 2, null)).doubleValue());
        } else {
            Function2<SingleDrop, DropContext, Unit> function2 = LuckyRegistry.INSTANCE.getDropActions().get(drop.getType());
            Intrinsics.checkNotNull(function2);
            Function2<SingleDrop, DropContext, Unit> fn = function2;
            fn.invoke(drop, context);
        }
    }

    public static final void runDrop(@NotNull WeightedDrop drop, @NotNull DropContext context, boolean showOutput) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        if (showOutput) {
            GameAPIKt.getGAME_API().logInfo("Chosen Lucky Drop: " + drop.getDropString());
        }
        List<SingleDrop> singleDrops = DropEvaluatorKt.evalDrop(drop, DropEvaluatorKt.createDropEvalContext$default(context, null, 2, null));
        Iterable $this$forEach$iv = singleDrops;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SingleDrop it = (SingleDrop)element$iv;
            boolean bl = false;
            DropEvaluatorKt.runEvaluatedDrop(it, context);
        }
    }

    public static final void runDropAfterDelay(@NotNull SingleDrop delayedDrop, @NotNull DropContext context) {
        Intrinsics.checkNotNullParameter(delayedDrop, "delayedDrop");
        Intrinsics.checkNotNullParameter(context, "context");
        EvalContext evalContext = DropEvaluatorKt.createDropEvalContext$default(context, null, 2, null);
        List<SingleDrop> singleDrops = DropEvaluatorKt.evalDropAfterDelay(delayedDrop, evalContext);
        for (SingleDrop drop : singleDrops) {
            Function2<SingleDrop, DropContext, Unit> fn;
            Intrinsics.checkNotNull(LuckyRegistry.INSTANCE.getDropActions().get(drop.getType()));
            fn.invoke(drop, context);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final WeightedDrop nextDebugDrop(@NotNull List<WeightedDrop> drops) {
        List filteredDrops;
        List list;
        Intrinsics.checkNotNullParameter(drops, "drops");
        List<String> newFilters = debugDropFilters;
        IntRange newIndexRange = debugDropIndexRange;
        if (!Intrinsics.areEqual(newIndexRange, debugDropIndexRange) || !Intrinsics.areEqual(newFilters, debugDropFilters)) {
            debugDropIndexRange = newIndexRange;
            debugDropFilters = newFilters;
            debugDropIndex = debugDropIndexRange.getFirst();
        }
        if (!((Collection)debugDropFilters).isEmpty()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = drops;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block9: {
                    WeightedDrop d = (WeightedDrop)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$any$iv = debugDropFilters;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (!StringsKt.contains$default((CharSequence)d.getDropString(), it, false, 2, null)) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = filteredDrops = drops;
        }
        if (debugDropIndex > debugDropIndexRange.getLast() || debugDropIndex >= filteredDrops.size()) {
            debugDropIndex = debugDropIndexRange.getFirst();
        }
        if (debugDropIndex >= filteredDrops.size()) {
            debugDropIndex = 0;
        }
        int index = debugDropIndex++;
        return (WeightedDrop)filteredDrops.get(index);
    }

    public static final void runRandomDrop(@Nullable List<WeightedDrop> customDrops, int luck, @NotNull DropContext context, boolean showOutput) {
        Intrinsics.checkNotNullParameter(context, "context");
        List<WeightedDrop> list = customDrops;
        if (list == null && (list = LuckyRegistry.INSTANCE.getDrops().get(context.getSourceId())) == null) {
            list = CollectionsKt.emptyList();
        }
        List<WeightedDrop> drops = list;
        WeightedDrop drop = DropEvaluatorKt.chooseRandomDrop(drops, luck);
        DropEvaluatorKt.runDrop(drop, context, showOutput);
    }

    public static /* synthetic */ void runRandomDrop$default(List list, int n, DropContext dropContext, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            list = null;
        }
        DropEvaluatorKt.runRandomDrop(list, n, dropContext, bl);
    }
}

