/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.common.drop.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mod.lucky.common.GameAPIKt;
import mod.lucky.common.LuckyRegistry;
import mod.lucky.common.UtilsKt;
import mod.lucky.common.Vec3;
import mod.lucky.common.attribute.Attr;
import mod.lucky.common.attribute.AttrType;
import mod.lucky.common.attribute.AttributeKt;
import mod.lucky.common.attribute.DictAttr;
import mod.lucky.common.drop.BaseDrop;
import mod.lucky.common.drop.DropContext;
import mod.lucky.common.drop.DropEvaluatorKt;
import mod.lucky.common.drop.DropStructure;
import mod.lucky.common.drop.GroupDrop;
import mod.lucky.common.drop.SingleDrop;
import mod.lucky.common.drop.action.DropActionsKt;
import mod.lucky.common.drop.action.StructureConfig;
import mod.lucky.jetbrains.annotations.NotNull;
import mod.lucky.kotlin.Metadata;
import mod.lucky.kotlin.Pair;
import mod.lucky.kotlin.TuplesKt;
import mod.lucky.kotlin.collections.CollectionsKt;
import mod.lucky.kotlin.collections.MapsKt;
import mod.lucky.kotlin.jvm.internal.Intrinsics;
import mod.lucky.kotlin.text.StringsKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u000b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0005\u001a\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e\u00a8\u0006\u0011"}, d2={"createDropStructure", "", "dropStructure", "Lmod/lucky/common/drop/DropStructure;", "dropContext", "Lmod/lucky/common/drop/DropContext;", "structureConfig", "Lmod/lucky/common/drop/action/StructureConfig;", "doStructureDrop", "drop", "Lmod/lucky/common/drop/SingleDrop;", "getStructureConfig", "context", "resolveStructureId", "", "id", "sourceId", "common"})
public final class StructureDropKt {
    @NotNull
    public static final String resolveStructureId(@NotNull String id, @NotNull String sourceId) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(sourceId, "sourceId");
        String[] stringArray = new String[]{":"};
        int numParts = StringsKt.split$default((CharSequence)id, stringArray, false, 0, 6, null).size();
        if (numParts == 2 && !StringsKt.startsWith$default(id, "lucky:", false, 2, null)) {
            return "lucky:" + id;
        }
        if (numParts <= 2) {
            String string;
            String string2;
            Object v3;
            String fullId;
            block8: {
                String string3;
                String string4 = LuckyRegistry.INSTANCE.getSourceToAddonId().get(sourceId);
                if (string4 != null) {
                    String it = string4;
                    boolean bl = false;
                    String[] stringArray2 = new String[]{":"};
                    string3 = it + ':' + (String)CollectionsKt.last(StringsKt.split$default((CharSequence)id, stringArray2, false, 0, 6, null));
                } else {
                    string3 = fullId = null;
                }
                if (fullId != null && ((Map)LuckyRegistry.INSTANCE.getDefaultStructureProps()).containsKey(fullId)) {
                    return fullId;
                }
                Set<String> set = LuckyRegistry.INSTANCE.getDefaultStructureProps().keySet();
                Intrinsics.checkNotNullExpressionValue(set, "LuckyRegistry.defaultStructureProps.keys");
                Iterable $this$firstOrNull$iv = set;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    if (!StringsKt.endsWith$default(it, ':' + id, false, 2, null)) continue;
                    v3 = element$iv;
                    break block8;
                }
                v3 = null;
            }
            if ((string2 = (String)v3) == null) {
                string2 = string = fullId;
            }
            if (string2 == null) {
                string = id;
            }
            return string;
        }
        return id;
    }

    @NotNull
    public static final StructureConfig getStructureConfig(@NotNull SingleDrop drop, @NotNull DropContext context) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        String structureId = StructureDropKt.resolveStructureId((String)SingleDrop.get$default(drop, "id", null, 2, null), context.getSourceId());
        DictAttr dictAttr = LuckyRegistry.INSTANCE.getDefaultStructureProps().get(structureId);
        if (dictAttr == null) {
            dictAttr = new DictAttr(null, null, false, 7, null);
        }
        DictAttr defaultProps = dictAttr;
        SingleDrop dropWithDefaults = SingleDrop.copy$default(drop, null, AttributeKt.withDefaults(drop.getProps(), defaultProps.getChildren()), null, 5, null);
        int rotation = UtilsKt.positiveMod(((Number)SingleDrop.get$default(dropWithDefaults, "rotation", null, 2, null)).intValue(), 4);
        Vec3 size = SingleDrop.getVec3$default(dropWithDefaults, "size", null, 2, null);
        Vec3<Number> centerOffset = dropWithDefaults.getVec3("centerOffset", new Vec3<Number>(Math.floor(((Number)size.getX()).doubleValue() / 2.0), 0.0, Math.floor(((Number)size.getZ()).doubleValue() / 2.0)));
        Vec3 pos = DropActionsKt.calculatePos$default(drop, context.getPos(), context.getWorld(), null, null, 24, null);
        String mode = (String)SingleDrop.get$default(dropWithDefaults, "blockMode", null, 2, null);
        boolean notify = (Boolean)SingleDrop.get$default(dropWithDefaults, "blockUpdate", null, 2, null);
        return new StructureConfig(structureId, rotation, size, pos, centerOffset, mode, notify, (String)dropWithDefaults.getProps().getOptionalValue("overlayStruct"));
    }

    public static final void createDropStructure(@NotNull DropStructure dropStructure, @NotNull DropContext dropContext, @NotNull StructureConfig structureConfig) {
        Intrinsics.checkNotNullParameter(dropStructure, "dropStructure");
        Intrinsics.checkNotNullParameter(dropContext, "dropContext");
        Intrinsics.checkNotNullParameter(structureConfig, "structureConfig");
        Pair[] pairArray = new Pair[]{TuplesKt.to("pos", AttributeKt.vec3AttrOf(AttrType.DOUBLE, structureConfig.getPos())), TuplesKt.to("rotation", AttributeKt.intAttrOf(structureConfig.getRotation())), TuplesKt.to("centerOffset", AttributeKt.vec3AttrOf(AttrType.DOUBLE, structureConfig.getCenterOffset()))};
        Map commonDefaults = MapsKt.mapOf(pairArray);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to("blockMode", AttributeKt.stringAttrOf(structureConfig.getMode())), TuplesKt.to("blockUpdate", AttributeKt.booleanAttrOf(structureConfig.getNotify()))};
        Map blockDefaults = MapsKt.plus(commonDefaults, UtilsKt.mapOfNotNull(pairArray2));
        for (BaseDrop drop : dropStructure.getDrops()) {
            List<SingleDrop> evaluatedDrops = DropEvaluatorKt.evalDrop(StructureDropKt.createDropStructure$mergeDefaultDropProps(blockDefaults, commonDefaults, drop), DropEvaluatorKt.createDropEvalContext$default(dropContext, null, 2, null));
            Iterable $this$forEach$iv = evaluatedDrops;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SingleDrop it = (SingleDrop)element$iv;
                boolean bl = false;
                DropEvaluatorKt.runEvaluatedDrop(it, dropContext);
            }
        }
    }

    public static final void doStructureDrop(@NotNull SingleDrop drop, @NotNull DropContext dropContext) {
        DropStructure dropStructure;
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(dropContext, "dropContext");
        StructureConfig structureConfig = StructureDropKt.getStructureConfig(drop, dropContext);
        if (Intrinsics.areEqual(structureConfig.getMode(), "replace")) {
            int n;
            Vec3<Integer> minPos = UtilsKt.getWorldPos(new Vec3<Number>(0.0, 0.0, 0.0), structureConfig.getCenterOffset().floor().toDouble(), structureConfig.getPos().floor().toDouble(), structureConfig.getRotation()).floor();
            Vec3<Integer> maxPos = UtilsKt.getWorldPos(structureConfig.getSize().minus(new Vec3<Number>(1.0, 1.0, 1.0)), structureConfig.getCenterOffset().floor().toDouble(), structureConfig.getPos().floor().toDouble(), structureConfig.getRotation()).floor();
            int x = minPos.getX();
            if (x <= (n = ((Number)maxPos.getX()).intValue())) {
                while (true) {
                    int n2;
                    int y;
                    if ((y = ((Number)minPos.getY()).intValue()) <= (n2 = ((Number)maxPos.getY()).intValue())) {
                        while (true) {
                            int n3;
                            int z;
                            if ((z = ((Number)minPos.getZ()).intValue()) <= (n3 = ((Number)maxPos.getZ()).intValue())) {
                                while (true) {
                                    GameAPIKt.getGAME_API().setBlock(dropContext.getWorld(), new Vec3<Number>(x, y, z), "minecraft:air", null, null, 0, structureConfig.getNotify());
                                    if (z == n3) break;
                                    ++z;
                                }
                            }
                            if (y == n2) break;
                            ++y;
                        }
                    }
                    if (x == n) break;
                    ++x;
                }
            }
        }
        if ((dropStructure = LuckyRegistry.INSTANCE.getDropStructures().get(structureConfig.getStructureId())) != null) {
            StructureDropKt.createDropStructure(dropStructure, dropContext, structureConfig);
        } else {
            GameAPIKt.getGAME_API().createStructure(dropContext.getWorld(), structureConfig.getStructureId(), structureConfig.getPos().floor(), structureConfig.getCenterOffset().floor(), structureConfig.getRotation(), structureConfig.getMode(), structureConfig.getNotify());
        }
        if (structureConfig.getOverlayStructureId() != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("id", AttributeKt.stringAttrOf(structureConfig.getOverlayStructureId())), TuplesKt.to("blockMode", AttributeKt.stringAttrOf("overlay")), TuplesKt.to("rotation", AttributeKt.intAttrOf(structureConfig.getRotation())), TuplesKt.to("pos", AttributeKt.vec3AttrOf(AttrType.DOUBLE, structureConfig.getPos()))};
            SingleDrop overlayDrop = new SingleDrop("structure", AttributeKt.dictAttrOf(pairArray), null, 4, null);
            StructureDropKt.doStructureDrop(overlayDrop, dropContext);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final BaseDrop createDropStructure$mergeDefaultDropProps(Map<String, ? extends Attr> blockDefaults, Map<String, ? extends Attr> commonDefaults, BaseDrop drop) {
        BaseDrop baseDrop;
        BaseDrop baseDrop2 = drop;
        if (baseDrop2 instanceof SingleDrop) {
            baseDrop = SingleDrop.copy$default((SingleDrop)drop, null, AttributeKt.withDefaults(((SingleDrop)drop).getProps(), Intrinsics.areEqual(((SingleDrop)drop).getType(), "block") ? blockDefaults : commonDefaults), null, 5, null);
        } else if (baseDrop2 instanceof GroupDrop) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ((GroupDrop)drop).getDrops();
            GroupDrop groupDrop = (GroupDrop)drop;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BaseDrop baseDrop3 = (BaseDrop)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(StructureDropKt.createDropStructure$mergeDefaultDropProps(blockDefaults, commonDefaults, (BaseDrop)it));
            }
            baseDrop = GroupDrop.copy$default(groupDrop, (List)destination$iv$iv, null, false, 6, null);
        } else {
            throw new Exception();
        }
        return baseDrop;
    }
}

