/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.common.drop.action;

import java.util.List;
import mod.lucky.common.GameAPI;
import mod.lucky.common.GameAPIKt;
import mod.lucky.common.UtilsKt;
import mod.lucky.common.Vec3;
import mod.lucky.common.attribute.Attr;
import mod.lucky.common.attribute.AttrType;
import mod.lucky.common.attribute.AttributeKt;
import mod.lucky.common.attribute.DictAttr;
import mod.lucky.common.attribute.ListAttr;
import mod.lucky.common.attribute.ValueAttr;
import mod.lucky.common.drop.DropContext;
import mod.lucky.common.drop.DropError;
import mod.lucky.common.drop.SingleDrop;
import mod.lucky.jetbrains.annotations.NotNull;
import mod.lucky.jetbrains.annotations.Nullable;
import mod.lucky.kotlin.Metadata;
import mod.lucky.kotlin.collections.CollectionsKt;
import mod.lucky.kotlin.jvm.internal.Intrinsics;
import mod.lucky.kotlin.ranges.IntRange;
import mod.lucky.kotlin.text.StringsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a,\u0010\u0010\u001a\u00020\u00012\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0010\u0010\u0014\u001a\f\u0012\u0004\u0012\u00020\u00160\u0015j\u0002`\u00172\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019\u00a8\u0006\u001c"}, d2={"doBlockDrop", "", "drop", "Lmod/lucky/common/drop/SingleDrop;", "context", "Lmod/lucky/common/drop/DropContext;", "doCommandDrop", "doDifficultyDrop", "doEntityDrop", "doExplosionDrop", "doFillDrop", "doItemDrop", "doMessageDrop", "doParticleDrop", "doSoundDrop", "doTimeDrop", "setBlock", "world", "", "Lmod/lucky/common/World;", "pos", "Lmod/lucky/common/Vec3;", "", "Lmod/lucky/common/Vec3i;", "withBlockMode", "", "mode", "blockId", "common"})
public final class DropActionsKt {
    @Nullable
    public static final String withBlockMode(@NotNull String mode, @NotNull String blockId) {
        String string;
        Intrinsics.checkNotNullParameter(mode, "mode");
        Intrinsics.checkNotNullParameter(blockId, "blockId");
        switch (mode) {
            case "air": {
                if (!Intrinsics.areEqual(blockId, "minecraft:air")) {
                    string = "minecraft:air";
                    break;
                }
                string = null;
                break;
            }
            case "overlay": {
                if (!Intrinsics.areEqual(blockId, "minecraft:air")) {
                    string = blockId;
                    break;
                }
                string = null;
                break;
            }
            case "replace": {
                string = blockId;
                break;
            }
            default: {
                GameAPI.DefaultImpls.logError$default(GameAPIKt.getGameAPI(), "Invalid block mode '" + mode + '\'', null, 2, null);
                string = null;
            }
        }
        return string;
    }

    public static final void setBlock(@NotNull Object world, @NotNull Vec3<Integer> pos, @NotNull SingleDrop drop) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(drop, "drop");
        if (!drop.contains("id")) {
            throw new DropError("Missing block ID");
        }
        String string = DropActionsKt.withBlockMode((String)SingleDrop.get$default(drop, "blockMode", null, 2, null), (String)SingleDrop.get$default(drop, "id", null, 2, null));
        if (string == null) {
            return;
        }
        String blockId = string;
        GameAPIKt.getGameAPI().setBlock(world, pos, blockId, drop.get("state", null), UtilsKt.positiveMod(((Number)SingleDrop.get$default(drop, "facing", null, 2, null)).intValue() + ((Number)SingleDrop.get$default(drop, "rotation", null, 2, null)).intValue(), 4), (Boolean)SingleDrop.get$default(drop, "blockUpdate", null, 2, null));
        if (drop.contains("nbttag")) {
            GameAPIKt.getGameAPI().setBlockEntity(world, pos, (DictAttr)SingleDrop.get$default(drop, "nbttag", null, 2, null));
        }
    }

    public static final void doBlockDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        DropActionsKt.setBlock(context.getWorld(), SingleDrop.getPos$default(drop, context.getPos(), null, null, 6, null).floor(), drop);
    }

    public static final void doFillDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        Vec3<Integer> pos = SingleDrop.getPos$default(drop, context.getPos(), null, null, 6, null).floor();
        Vec3<Integer> pos2 = drop.contains("pos2") ? SingleDrop.getPos$default(drop, null, "pos2", "posOffset2", 1, null).floor() : pos.plus(SingleDrop.getVec3$default(drop, "size", null, 2, null)).minus(new Vec3<Number>(1, 1, 1));
        int n = pos.getX();
        int n2 = pos2.getX();
        int n3 = 0;
        int n4 = Math.min(n, n2);
        n = pos.getX();
        n2 = pos2.getX();
        n3 = 0;
        IntRange xRange = new IntRange(n4, Math.max(n, n2));
        n2 = pos.getY();
        n3 = pos2.getY();
        int n5 = 0;
        int n6 = Math.min(n2, n3);
        n2 = pos.getY();
        n3 = pos2.getY();
        n5 = 0;
        IntRange yRange = new IntRange(n6, Math.max(n2, n3));
        n3 = pos.getZ();
        n5 = pos2.getZ();
        boolean bl = false;
        int n7 = Math.min(n3, n5);
        n3 = pos.getZ();
        n5 = pos2.getZ();
        bl = false;
        IntRange zRange = new IntRange(n7, Math.max(n3, n5));
        n3 = xRange.getFirst();
        n5 = xRange.getLast();
        if (n3 <= n5) {
            int x;
            do {
                int y;
                int n8;
                x = n3++;
                int n9 = yRange.getFirst();
                if (n9 > (n8 = yRange.getLast())) continue;
                do {
                    int z;
                    int n10;
                    y = n9++;
                    int n11 = zRange.getFirst();
                    if (n11 > (n10 = zRange.getLast())) continue;
                    do {
                        z = n11++;
                        DropActionsKt.setBlock(context.getWorld(), new Vec3<Number>(x, y, z), drop);
                    } while (z != n10);
                } while (y != n8);
            } while (x != n5);
        }
    }

    public static final void doItemDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        GameAPIKt.getGameAPI().dropItem(context.getWorld(), SingleDrop.getPos$default(drop, context.getPos(), null, null, 6, null), (String)SingleDrop.get$default(drop, "id", null, 2, null), (DictAttr)drop.getOrNull("nbttag"));
    }

    public static final void doMessageDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        Object player;
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        Object object = context.getPlayer();
        Object object2 = player = object == null ? GameAPIKt.getGameAPI().getNearestPlayer(context.getWorld(), SingleDrop.getPos$default(drop, context.getPos(), null, null, 6, null)) : object;
        if (player != null) {
            GameAPIKt.getGameAPI().sendMessage(player, (String)SingleDrop.get$default(drop, "id", null, 2, null));
        }
    }

    public static final void doCommandDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        GameAPIKt.getGameAPI().runCommand(context.getWorld(), SingleDrop.getPos$default(drop, context.getPos(), null, null, 6, null), (String)SingleDrop.get$default(drop, "id", null, 2, null), (String)SingleDrop.get$default(drop, "commandSender", null, 2, null), (Boolean)SingleDrop.get$default(drop, "displayOutput", null, 2, null));
    }

    public static final void doDifficultyDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        String string;
        String[] value;
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        String[] stringArray = value = (String[])SingleDrop.get$default(drop, "id", null, 2, null);
        boolean bl = false;
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = stringArray.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.String).toLowerCase()");
        String string3 = string2;
        stringArray = new String[]{"peacful", "p", "0"};
        if (CollectionsKt.listOf(stringArray).contains(string3)) {
            string = "peacful";
        } else {
            stringArray = new String[]{"easy", "3", "1"};
            if (CollectionsKt.listOf(stringArray).contains(string3)) {
                string = "easy";
            } else {
                stringArray = new String[]{"normal", "n", "2"};
                if (CollectionsKt.listOf(stringArray).contains(string3)) {
                    string = "normal";
                } else {
                    stringArray = new String[]{"hard", "h", "3"};
                    if (CollectionsKt.listOf(stringArray).contains(string3)) {
                        string = "hard";
                    } else {
                        GameAPI.DefaultImpls.logError$default(GameAPIKt.getGameAPI(), Intrinsics.stringPlus("Invalid diffictulty: ", value), null, 2, null);
                        return;
                    }
                }
            }
        }
        String difficulty = string;
        GameAPIKt.getGameAPI().setDifficulty(context.getWorld(), difficulty);
    }

    public static final void doTimeDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        long l;
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        Attr attr = drop.getProps().get("id");
        if (attr == null) {
            throw new NullPointerException("null cannot be cast to non-null type mod.lucky.common.attribute.ValueAttr");
        }
        ValueAttr timeAttr = (ValueAttr)attr;
        if (AttributeKt.isNumType(timeAttr.getType())) {
            l = (Long)AttributeKt.castNum(AttrType.LONG, (Number)timeAttr.getValue());
        } else {
            String string = (String)timeAttr.getValue();
            if (Intrinsics.areEqual(string, "day")) {
                l = 1000L;
            } else if (Intrinsics.areEqual(string, "night")) {
                l = 13000L;
            } else {
                GameAPI.DefaultImpls.logError$default(GameAPIKt.getGameAPI(), Intrinsics.stringPlus("Invalid time: ", timeAttr.getValue()), null, 2, null);
                return;
            }
        }
        long time = l;
        GameAPIKt.getGameAPI().setTime(context.getWorld(), time);
    }

    public static final void doSoundDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        GameAPIKt.getGameAPI().playSound(context.getWorld(), SingleDrop.getPos$default(drop, context.getPos(), null, null, 6, null), (String)SingleDrop.get$default(drop, "id", null, 2, null), ((Number)SingleDrop.get$default(drop, "volume", null, 2, null)).doubleValue(), ((Number)SingleDrop.get$default(drop, "pitch", null, 2, null)).doubleValue());
    }

    public static final void doExplosionDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        Vec3<Number> pos = SingleDrop.getPos$default(drop, context.getPos(), null, null, 6, null).plus(new Vec3<Number>(0.0, 0.5, 0.0));
        GameAPIKt.getGameAPI().createExplosion(context.getWorld(), pos, ((Number)SingleDrop.get$default(drop, "damage", null, 2, null)).doubleValue(), (Boolean)SingleDrop.get$default(drop, "fire", null, 2, null));
    }

    public static final void doParticleDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        Attr attr = drop.getProps().get("id");
        if (attr == null) {
            throw new NullPointerException("null cannot be cast to non-null type mod.lucky.common.attribute.ValueAttr");
        }
        ValueAttr effectIdAttr = (ValueAttr)attr;
        Vec3 pos = SingleDrop.getPos$default(drop, context.getPos(), null, null, 6, null);
        int particleData = ((Number)SingleDrop.get$default(drop, "damage", null, 2, null)).intValue();
        if (AttributeKt.isNumType(effectIdAttr.getType())) {
            int particleIdInt = (Integer)AttributeKt.castNum(AttrType.INT, (Number)effectIdAttr.getValue());
            GameAPIKt.getGameAPI().playParticleEvent(context.getWorld(), pos, particleIdInt, particleData);
        } else {
            String particleId = (String)effectIdAttr.getValue();
            if (StringsKt.equals(particleId, "splashpotion", true)) {
                String potionName = (String)drop.getOrNull("potion");
                GameAPIKt.getGameAPI().playSplashPotionEvent(context.getWorld(), pos, potionName, potionName == null ? Integer.valueOf(particleData) : null);
            } else {
                char[] cArray = new char[]{'.'};
                List splitId = StringsKt.split$default((CharSequence)particleId, cArray, false, 0, 6, null);
                List<String> particleArgs = splitId.size() >= 2 ? splitId.subList(1, splitId.size()) : CollectionsKt.emptyList();
                GameAPIKt.getGameAPI().spawnParticle(context.getWorld(), pos, (String)splitId.get(0), particleArgs, SingleDrop.getVec3$default(drop, "size", null, 2, null), ((Number)SingleDrop.get$default(drop, "particleAmount", null, 2, null)).intValue());
            }
        }
    }

    public static final void doEntityDrop(@NotNull SingleDrop drop, @NotNull DropContext context) {
        Intrinsics.checkNotNullParameter(drop, "drop");
        Intrinsics.checkNotNullParameter(context, "context");
        Vec3 initPos = SingleDrop.getPos$default(drop, context.getPos(), null, null, 6, null);
        ListAttr adjustList = (ListAttr)SingleDrop.get$default(drop, "adjustY", null, 2, null);
        IntRange adjustRange = new IntRange(((Number)adjustList.getValue(0)).intValue(), ((Number)adjustList.getValue(1)).intValue());
        Vec3<Double> pos = DropActionsKt.doEntityDrop$adjustY(context.getWorld(), initPos, adjustRange);
        if (!drop.contains("id")) {
            throw new DropError("Missing entity ID");
        }
        String initId = (String)SingleDrop.get$default(drop, "id", null, 2, null);
        String id = Intrinsics.areEqual(initId, "LightningBolt") ? "lightning_bolt" : initId;
        Object object = context.getWorld();
        DictAttr dictAttr = (DictAttr)SingleDrop.get$default(drop, "nbttag", null, 2, null);
        Object object2 = context.getPlayer();
        String string = context.getSourceId();
        boolean bl = (Boolean)SingleDrop.get$default(drop, "randomizeMob", null, 2, null);
        double d = UtilsKt.positiveMod(((Number)SingleDrop.get$default(drop, "facing", null, 2, null)).doubleValue() + ((Number)SingleDrop.get$default(drop, "rotation", null, 2, null)).doubleValue(), 4.0);
        GameAPIKt.getGameAPI().spawnEntity(object, id, pos, dictAttr, d, bl, object2, string);
    }

    private static final Vec3<Double> doEntityDrop$adjustY(Object world, Vec3<Double> pos, IntRange adjustRange) {
        int n;
        int n2 = adjustRange.getFirst();
        if (n2 <= (n = adjustRange.getLast())) {
            int y;
            do {
                y = n2++;
                Vec3<Double> newPos = new Vec3<Double>(pos.getX(), (Double)((Number)(pos.getY() + (double)y)), pos.getZ());
                if (!GameAPIKt.getGameAPI().isAirBlock(world, newPos.floor())) continue;
                return newPos;
            } while (y != n);
        }
        return pos;
    }
}

