/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.forge;

import mod.lucky.java.EnchantmentType;
import mod.lucky.java.ItemStack;
import mod.lucky.java.JavaGameAPI;
import mod.lucky.java.JavaGameAPIKt;
import mod.lucky.jetbrains.annotations.NotNull;
import mod.lucky.kotlin.Metadata;
import mod.lucky.kotlin.NoWhenBranchMatchedException;
import mod.lucky.kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.registries.ForgeRegistries;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t\u001a\u0014\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0012\u0010\u000f\u001a\u00060\bj\u0002`\t2\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\u0010"}, d2={"isClientWorld", "", "world", "Lnet/minecraft/world/level/LevelAccessor;", "Lmod/lucky/forge/MCIWorld;", "toItemStack", "Lmod/lucky/java/ItemStack;", "stack", "Lnet/minecraft/world/item/ItemStack;", "Lmod/lucky/forge/MCItemStack;", "toMCEnchantmentType", "Lnet/minecraft/world/item/enchantment/EnchantmentCategory;", "Lmod/lucky/forge/MCEnchantmentType;", "type", "Lmod/lucky/java/EnchantmentType;", "toMCItemStack", "luckyblock"})
public final class ForgeJavaGameAPIKt {
    public static final boolean isClientWorld(@NotNull LevelAccessor world) {
        Intrinsics.checkNotNullParameter(world, "world");
        return world.m_5776_();
    }

    private static final EnchantmentCategory toMCEnchantmentType(EnchantmentType type) {
        EnchantmentType enchantmentType = type;
        int n = WhenMappings.$EnumSwitchMapping$0[enchantmentType.ordinal()];
        return switch (n) {
            case 1 -> EnchantmentCategory.ARMOR;
            case 2 -> EnchantmentCategory.ARMOR_FEET;
            case 3 -> EnchantmentCategory.ARMOR_LEGS;
            case 4 -> EnchantmentCategory.ARMOR_CHEST;
            case 5 -> EnchantmentCategory.ARMOR_HEAD;
            case 6 -> EnchantmentCategory.WEAPON;
            case 7 -> EnchantmentCategory.DIGGER;
            case 8 -> EnchantmentCategory.FISHING_ROD;
            case 9 -> EnchantmentCategory.TRIDENT;
            case 10 -> EnchantmentCategory.BOW;
            case 11 -> EnchantmentCategory.BOW;
            case 12 -> EnchantmentCategory.WEARABLE;
            case 13 -> EnchantmentCategory.CROSSBOW;
            case 14 -> EnchantmentCategory.VANISHABLE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final net.minecraft.world.item.ItemStack toMCItemStack(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Object object = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(stack.getItemId()));
        net.minecraft.world.item.ItemStack mcStack = new net.minecraft.world.item.ItemStack((ItemLike)(object == null ? Items.f_41852_ : object), stack.getCount());
        if (stack.getNbt() != null) {
            object = stack.getNbt();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.nbt.CompoundTag{ mod.lucky.forge.ForgeGameAPIKt.CompoundTag }");
            }
            mcStack.m_41751_((CompoundTag)object);
        }
        return mcStack;
    }

    @NotNull
    public static final ItemStack toItemStack(@NotNull net.minecraft.world.item.ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        JavaGameAPI javaGameAPI = JavaGameAPIKt.getJavaGameAPI();
        Item item = stack.m_41720_();
        Intrinsics.checkNotNullExpressionValue(item, "stack.item");
        String string = javaGameAPI.getItemId(item);
        return new ItemStack(string == null ? "minecraft:air" : string, stack.m_41613_(), stack.m_41783_());
    }

    public static final /* synthetic */ EnchantmentCategory access$toMCEnchantmentType(EnchantmentType type) {
        return ForgeJavaGameAPIKt.toMCEnchantmentType(type);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EnchantmentType.values().length];
            nArray[EnchantmentType.ARMOR.ordinal()] = 1;
            nArray[EnchantmentType.ARMOR_FEET.ordinal()] = 2;
            nArray[EnchantmentType.ARMOR_LEGS.ordinal()] = 3;
            nArray[EnchantmentType.ARMOR_CHEST.ordinal()] = 4;
            nArray[EnchantmentType.ARMOR_HEAD.ordinal()] = 5;
            nArray[EnchantmentType.WEAPON.ordinal()] = 6;
            nArray[EnchantmentType.DIGGER.ordinal()] = 7;
            nArray[EnchantmentType.FISHING_ROD.ordinal()] = 8;
            nArray[EnchantmentType.TRIDENT.ordinal()] = 9;
            nArray[EnchantmentType.BREAKABLE.ordinal()] = 10;
            nArray[EnchantmentType.BOW.ordinal()] = 11;
            nArray[EnchantmentType.WEARABLE.ordinal()] = 12;
            nArray[EnchantmentType.CROSSBOW.ordinal()] = 13;
            nArray[EnchantmentType.VANISHABLE.ordinal()] = 14;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

