/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.java.game;

import java.util.List;
import mod.lucky.common.GameAPIKt;
import mod.lucky.common.Vec3;
import mod.lucky.common.attribute.Attr;
import mod.lucky.common.attribute.AttributeKt;
import mod.lucky.common.attribute.DictAttr;
import mod.lucky.common.attribute.ListAttr;
import mod.lucky.common.drop.DropContext;
import mod.lucky.common.drop.DropEvaluatorKt;
import mod.lucky.common.drop.WeightedDrop;
import mod.lucky.java.DropSerializerKt;
import mod.lucky.java.JavaGameAPIKt;
import mod.lucky.java.game.GameUtilsKt;
import mod.lucky.java.game.LuckyProjectileData;
import mod.lucky.jetbrains.annotations.NotNull;
import mod.lucky.jetbrains.annotations.Nullable;
import mod.lucky.kotlin.Metadata;
import mod.lucky.kotlin.Pair;
import mod.lucky.kotlin.TuplesKt;
import mod.lucky.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001aB\u0010\u0005\u001a\u00020\u0006*\u00020\u00012\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\n\u0010\n\u001a\u00060\bj\u0002`\u000b2\u000e\u0010\f\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\u000b2\u000e\u0010\r\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\u000b\u001a\u0016\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\n\u0010\u000f\u001a\u00060\bj\u0002`\u0010\u001a:\u0010\u0011\u001a\u00020\u0006*\u00020\u00012\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\n\u0010\n\u001a\u00060\bj\u0002`\u000b2\u000e\u0010\u0012\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\u000b2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\n\u0010\u0015\u001a\u00020\u0004*\u00020\u0001\u001a\u0016\u0010\u0016\u001a\u00020\u0006*\u00020\u00012\n\u0010\u000f\u001a\u00060\bj\u0002`\u0010\u00a8\u0006\u0017"}, d2={"fromAttr", "Lmod/lucky/java/game/LuckyProjectileData;", "Lmod/lucky/java/game/LuckyProjectileData$Companion;", "attr", "Lmod/lucky/common/attribute/DictAttr;", "onImpact", "", "world", "", "Lmod/lucky/common/World;", "entity", "Lmod/lucky/common/Entity;", "user", "hitEntity", "readFromTag", "tag", "Lmod/lucky/java/NBTTag;", "tick", "shooter", "ticksExisted", "", "toAttr", "writeToTag", "common"})
public final class LuckyProjectileUtilsKt {
    public static final void tick(@NotNull LuckyProjectileData $this$tick, @NotNull Object world, @NotNull Object entity, @Nullable Object shooter, int ticksExisted) {
        Intrinsics.checkNotNullParameter($this$tick, "<this>");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(entity, "entity");
        try {
            if (ticksExisted < 2) {
                return;
            }
            if ($this$tick.getTrailDrops() == null) {
                return;
            }
            if ($this$tick.getTrailFreqPerTick() < 1.0 && $this$tick.getTrailFreqPerTick() > 0.0) {
                int amount = (int)(1.0 / $this$tick.getTrailFreqPerTick());
                Vec3<Double> velocity = JavaGameAPIKt.getJAVA_GAME_API().getEntityVelocity(entity);
                Vec3<Double> pos = GameAPIKt.getGAME_API().getEntityPos(entity);
                int n = 0;
                while (n < amount) {
                    int i = n++;
                    Vec3<Number> vec3 = new Vec3<Number>(pos.getX() + velocity.getX() * (double)i / (double)amount, pos.getY() + velocity.getY() * (double)i / (double)amount, pos.getZ() + velocity.getZ() * (double)i / (double)amount);
                    String string = $this$tick.getSourceId();
                    DropContext context = new DropContext(world, vec3, shooter, null, 0.0, string, 24, null);
                    DropEvaluatorKt.runRandomDrop($this$tick.getTrailDrops(), 0, context, false);
                }
            } else if ((ticksExisted - 2) % (int)$this$tick.getTrailFreqPerTick() == 0) {
                Vec3<Double> vec3 = GameAPIKt.getGAME_API().getEntityPos(entity);
                String string = $this$tick.getSourceId();
                DropContext context = new DropContext(world, vec3, shooter, null, 0.0, string, 24, null);
                DropEvaluatorKt.runRandomDrop($this$tick.getTrailDrops(), 0, context, false);
            }
        }
        catch (Exception e) {
            GameAPIKt.getGAME_API().logError("Error in lucky_projectile tick", e);
        }
    }

    public static final void onImpact(@NotNull LuckyProjectileData $this$onImpact, @NotNull Object world, @NotNull Object entity, @Nullable Object user, @Nullable Object hitEntity) {
        Intrinsics.checkNotNullParameter($this$onImpact, "<this>");
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(entity, "entity");
        try {
            if ($this$onImpact.getImpactDrops() == null) {
                return;
            }
            Vec3<Double> vec3 = hitEntity != null ? GameAPIKt.getGAME_API().getEntityPos(hitEntity) : GameAPIKt.getGAME_API().getEntityPos(entity);
            String string = $this$onImpact.getSourceId();
            DropContext context = new DropContext(world, vec3, user, hitEntity, 0.0, string, 16, null);
            DropEvaluatorKt.runRandomDrop($this$onImpact.getImpactDrops(), 0, context, true);
        }
        catch (Exception e) {
            GameAPIKt.getGAME_API().logError("Error in lucky_projectile impact", e);
        }
    }

    @NotNull
    public static final DictAttr toAttr(@NotNull LuckyProjectileData $this$toAttr) {
        ListAttr listAttr;
        Attr attr;
        List<WeightedDrop> it;
        Pair[] pairArray;
        int n;
        String string;
        Attr attr2;
        Intrinsics.checkNotNullParameter($this$toAttr, "<this>");
        Pair[] pairArray2 = new Pair[3];
        pairArray2[0] = TuplesKt.to("sourceId", AttributeKt.stringAttrOf($this$toAttr.getSourceId()));
        Pair[] pairArray3 = pairArray2;
        int n2 = 1;
        String string2 = "trail";
        List<WeightedDrop> list = $this$toAttr.getTrailDrops();
        if (list == null) {
            attr2 = null;
        } else {
            List<WeightedDrop> list2 = list;
            string = string2;
            n = n2;
            pairArray = pairArray3;
            boolean bl = false;
            Pair[] pairArray4 = new Pair[]{TuplesKt.to("frequency", AttributeKt.doubleAttrOf($this$toAttr.getTrailFreqPerTick())), TuplesKt.to("drops", DropSerializerKt.dropsToAttrList(it))};
            attr = AttributeKt.dictAttrOf(pairArray4);
            pairArray3 = pairArray;
            n2 = n;
            string2 = string;
            attr2 = attr;
        }
        pairArray3[n2] = TuplesKt.to(string2, attr2);
        Pair[] pairArray5 = pairArray2;
        int n3 = 2;
        String string3 = "impact";
        List<WeightedDrop> list3 = $this$toAttr.getImpactDrops();
        if (list3 == null) {
            listAttr = null;
        } else {
            it = list3;
            string = string3;
            n = n3;
            pairArray = pairArray5;
            boolean bl = false;
            attr = DropSerializerKt.dropsToAttrList(it);
            pairArray5 = pairArray;
            n3 = n;
            string3 = string;
            listAttr = attr;
        }
        pairArray5[n3] = TuplesKt.to(string3, listAttr);
        return AttributeKt.dictAttrOf(pairArray2);
    }

    @NotNull
    public static final LuckyProjectileData fromAttr(@NotNull LuckyProjectileData.Companion $this$fromAttr, @NotNull DictAttr attr) {
        LuckyProjectileData luckyProjectileData;
        Intrinsics.checkNotNullParameter($this$fromAttr, "<this>");
        Intrinsics.checkNotNullParameter(attr, "attr");
        try {
            String string;
            List<WeightedDrop> list;
            List<WeightedDrop> list2;
            ListAttr it;
            double d;
            List<WeightedDrop> list3;
            double d2;
            DictAttr dictAttr = (DictAttr)attr.get("trail");
            if (dictAttr == null) {
                d2 = 0.0;
            } else {
                Double d3 = (Double)dictAttr.getValue("frequency");
                d2 = d3 == null ? 0.0 : d3;
            }
            DictAttr dictAttr2 = (DictAttr)attr.get("trail");
            if (dictAttr2 == null) {
                list3 = null;
            } else {
                DictAttr dictAttr3 = dictAttr2;
                d = d2;
                boolean bl = false;
                list2 = DropSerializerKt.dropsFromAttrList(((DictAttr)((Object)it)).getList("drops"));
                d2 = d;
                list3 = list2;
            }
            ListAttr listAttr = (ListAttr)attr.get("impact");
            if (listAttr == null) {
                list = null;
            } else {
                it = listAttr;
                list2 = list3;
                d = d2;
                boolean bl = false;
                List<WeightedDrop> list4 = DropSerializerKt.dropsFromAttrList(it);
                d2 = d;
                list3 = list2;
                list = list4;
            }
            if ((string = (String)attr.getOptionalValue("sourceId")) == null) {
                string = "lucky:lucky_block";
            }
            String string2 = string;
            List<WeightedDrop> list5 = list;
            List<WeightedDrop> list6 = list3;
            double d4 = d2;
            luckyProjectileData = new LuckyProjectileData(d4, list6, list5, string2);
        }
        catch (Exception e) {
            GameAPIKt.getGAME_API().logError("Error loading lucky_projectile", e);
            luckyProjectileData = new LuckyProjectileData(0.0, null, null, null, 15, null);
        }
        return luckyProjectileData;
    }

    public static final void writeToTag(@NotNull LuckyProjectileData $this$writeToTag, @NotNull Object tag) {
        Intrinsics.checkNotNullParameter($this$writeToTag, "<this>");
        Intrinsics.checkNotNullParameter(tag, "tag");
        GameUtilsKt.writeNBTKeys(tag, LuckyProjectileUtilsKt.toAttr($this$writeToTag));
    }

    @NotNull
    public static final LuckyProjectileData readFromTag(@NotNull LuckyProjectileData.Companion $this$readFromTag, @NotNull Object tag) {
        Intrinsics.checkNotNullParameter($this$readFromTag, "<this>");
        Intrinsics.checkNotNullParameter(tag, "tag");
        return LuckyProjectileUtilsKt.fromAttr($this$readFromTag, GameUtilsKt.readNBTKeys(tag, $this$readFromTag.getAttrKeys()));
    }
}

