/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.java.loader;

import java.util.List;
import mod.lucky.common.LoggerKt;
import mod.lucky.common.LuckyBlockSettings;
import mod.lucky.common.LuckyRegistry;
import mod.lucky.common.attribute.AttrType;
import mod.lucky.common.attribute.AttributeKt;
import mod.lucky.common.attribute.DictAttr;
import mod.lucky.common.attribute.DictSpec;
import mod.lucky.common.attribute.EvaluatorKt;
import mod.lucky.common.attribute.ParserKt;
import mod.lucky.common.attribute.ValueSpec;
import mod.lucky.java.AddonIds;
import mod.lucky.java.loader.GlobalSettings;
import mod.lucky.java.loader.LocalSettings;
import mod.lucky.jetbrains.annotations.NotNull;
import mod.lucky.kotlin.Metadata;
import mod.lucky.kotlin.Pair;
import mod.lucky.kotlin.TuplesKt;
import mod.lucky.kotlin.collections.CollectionsKt;
import mod.lucky.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0014\u0010\u0005\u001a\u00020\u00062\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a8\u0006\t"}, d2={"parseGlobalSettings", "Lmod/lucky/java/loader/GlobalSettings;", "lines", "", "", "parseLocalSettings", "Lmod/lucky/java/loader/LocalSettings;", "readAddonIds", "Lmod/lucky/java/AddonIds;", "common"})
public final class ReadSettingsKt {
    @NotNull
    public static final GlobalSettings parseGlobalSettings(@NotNull List<String> lines) {
        DictAttr dictAttr;
        Intrinsics.checkNotNullParameter(lines, "lines");
        Pair[] pairArray = new Pair[]{TuplesKt.to("showUpdateMessage", new ValueSpec(AttrType.BOOLEAN))};
        DictSpec spec = AttributeKt.dictSpecOf(pairArray);
        try {
            String propsStr = CollectionsKt.joinToString$default(ParserKt.splitLines(lines), ",", null, null, 0, null, null, 62, null);
            dictAttr = (DictAttr)EvaluatorKt.parseEvalAttr(propsStr, spec, LuckyRegistry.INSTANCE.getParserContext(), LuckyRegistry.INSTANCE.getSimpleEvalContext());
        }
        catch (Exception e) {
            LoggerKt.getLOGGER().logError("Error reading global settings", e);
            dictAttr = new DictAttr(null, null, false, 7, null);
        }
        DictAttr props = dictAttr;
        return new GlobalSettings(props.getWithDefault("showUpdateMessage", true));
    }

    @NotNull
    public static final LocalSettings parseLocalSettings(@NotNull List<String> lines) {
        DictAttr dictAttr;
        Intrinsics.checkNotNullParameter(lines, "lines");
        Pair[] pairArray = new Pair[]{TuplesKt.to("doDropsOnRightClick", new ValueSpec(AttrType.BOOLEAN))};
        DictSpec spec = AttributeKt.dictSpecOf(pairArray);
        try {
            String propsStr = CollectionsKt.joinToString$default(ParserKt.splitLines(lines), ",", null, null, 0, null, null, 62, null);
            dictAttr = (DictAttr)EvaluatorKt.parseEvalAttr(propsStr, spec, LuckyRegistry.INSTANCE.getParserContext(), LuckyRegistry.INSTANCE.getSimpleEvalContext());
        }
        catch (Exception e) {
            LoggerKt.getLOGGER().logError("Error reading global settings", e);
            dictAttr = new DictAttr(null, null, false, 7, null);
        }
        DictAttr props = dictAttr;
        return new LocalSettings(new LuckyBlockSettings(props.getWithDefault("doDropsOnRightClick", false)));
    }

    @NotNull
    public static final AddonIds readAddonIds(@NotNull List<String> lines) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String it;
        String string7;
        DictAttr dictAttr;
        Intrinsics.checkNotNullParameter(lines, "lines");
        Pair[] pairArray = new Pair[]{TuplesKt.to("block_id", new ValueSpec(AttrType.STRING)), TuplesKt.to("id", new ValueSpec(AttrType.STRING)), TuplesKt.to("sword_id", new ValueSpec(AttrType.STRING)), TuplesKt.to("bow_id", new ValueSpec(AttrType.STRING)), TuplesKt.to("potion_id", new ValueSpec(AttrType.STRING))};
        DictSpec spec = AttributeKt.dictSpecOf(pairArray);
        try {
            String propsStr = CollectionsKt.joinToString$default(ParserKt.splitLines(lines), ",", null, null, 0, null, null, 62, null);
            dictAttr = (DictAttr)EvaluatorKt.parseEvalAttr(propsStr, spec, LuckyRegistry.INSTANCE.getParserContext(), LuckyRegistry.INSTANCE.getSimpleEvalContext());
        }
        catch (Exception e) {
            LoggerKt.getLOGGER().logError("Error reading addon info", e);
            dictAttr = new DictAttr(null, null, false, 7, null);
        }
        DictAttr props = dictAttr;
        String string8 = (String)props.getOptionalValue("block_id");
        if (string8 == null) {
            string8 = (String)props.getOptionalValue("id");
        }
        if (string8 == null) {
            string7 = null;
        } else {
            it = string8;
            boolean bl = false;
            string7 = Intrinsics.stringPlus("lucky:", it);
        }
        String string9 = (String)props.getOptionalValue("sword_id");
        if (string9 == null) {
            string6 = null;
        } else {
            it = string9;
            string5 = string7;
            boolean bl = false;
            string6 = Intrinsics.stringPlus("lucky:", it);
            string7 = string5;
        }
        String string10 = (String)props.getOptionalValue("bow_id");
        if (string10 == null) {
            string4 = null;
        } else {
            it = string10;
            string3 = string6;
            string5 = string7;
            boolean bl = false;
            string2 = Intrinsics.stringPlus("lucky:", it);
            string7 = string5;
            string6 = string3;
            string4 = string2;
        }
        String string11 = (String)props.getOptionalValue("potion_id");
        if (string11 == null) {
            string = null;
        } else {
            it = string11;
            string2 = string4;
            string3 = string6;
            string5 = string7;
            boolean bl = false;
            String string12 = Intrinsics.stringPlus("lucky:", it);
            string7 = string5;
            string6 = string3;
            string4 = string2;
            string = string12;
        }
        String string13 = string;
        String string14 = string4;
        String string15 = string6;
        String string16 = string7;
        return new AddonIds(string16, string15, string14, string13);
    }
}

