/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.forge;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mod.lucky.common.GameAPIKt;
import mod.lucky.common.Logger;
import mod.lucky.common.Random;
import mod.lucky.common.attribute.Attr;
import mod.lucky.common.attribute.AttrType;
import mod.lucky.common.attribute.AttributeKt;
import mod.lucky.common.attribute.DictAttr;
import mod.lucky.common.attribute.ListAttr;
import mod.lucky.common.attribute.ValueAttr;
import mod.lucky.forge.ForgeGameAPIKt;
import mod.lucky.forge.ForgeLuckyRegistry;
import mod.lucky.forge.OnlyInClient;
import mod.lucky.java.JavaGameAPI;
import mod.lucky.java.JavaGameAPIKt;
import mod.lucky.jetbrains.annotations.NotNull;
import mod.lucky.jetbrains.annotations.Nullable;
import mod.lucky.kotlin.Metadata;
import mod.lucky.kotlin.NoWhenBranchMatchedException;
import mod.lucky.kotlin.Pair;
import mod.lucky.kotlin.TuplesKt;
import mod.lucky.kotlin.collections.CollectionsKt;
import mod.lucky.kotlin.jvm.internal.DefaultConstructorMarker;
import mod.lucky.kotlin.jvm.internal.Intrinsics;
import mod.lucky.kotlin.ranges.IntRange;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.fixes.ItemIdFix;
import net.minecraft.util.datafix.fixes.ItemStackTheFlatteningFix;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.versions.mcp.MCPVersion;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J$\u0010\r\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f2\n\u0010\u0010\u001a\u00060\u000ej\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016J6\u0010\u0013\u001a\u00020\u00142\n\u0010\u0010\u001a\u00060\u000ej\u0002`\u00112\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u000b0\u0016j\u0002`\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016JX\u0010\u001b\u001a\"\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001d0\u0016j\u0002`\u001e\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001d0\u0016j\u0002`\u001e0\u001c2\n\u0010\u0010\u001a\u00060\u000ej\u0002`\u00112\n\u0010\u001f\u001a\u00060\u000ej\u0002` 2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001dH\u0016J\u0016\u0010$\u001a\u0004\u0018\u00010\t2\n\u0010%\u001a\u00060\u000ej\u0002`&H\u0016J\u0014\u0010'\u001a\u00020\t2\n\u0010(\u001a\u00060\u000ej\u0002`\u000fH\u0016J\u0014\u0010)\u001a\u00020\t2\n\u0010(\u001a\u00060\u000ej\u0002`\u000fH\u0016J\u001e\u0010*\u001a\f\u0012\u0004\u0012\u00020\u001d0\u0016j\u0002`\u001e2\n\u0010(\u001a\u00060\u000ej\u0002`\u000fH\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0016\u0010-\u001a\u0004\u0018\u00010\t2\n\u0010.\u001a\u00060\u000ej\u0002`/H\u0016J\b\u00100\u001a\u00020\tH\u0016J\b\u00101\u001a\u00020\tH\u0016J\b\u00102\u001a\u00020\tH\u0016J\u0014\u00103\u001a\u0002042\n\u0010\u001f\u001a\u00060\u000ej\u0002` H\u0016J\u0014\u00105\u001a\u0002042\n\u0010\u001f\u001a\u00060\u000ej\u0002` H\u0016J\u0010\u00106\u001a\u0002042\u0006\u0010\n\u001a\u00020\tH\u0016J\u0014\u00107\u001a\u00020\u00072\n\u00108\u001a\u00060\u000ej\u0002`9H\u0016J\u0010\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020<H\u0016J$\u0010=\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`92\n\u00108\u001a\u00060\u000ej\u0002`92\u0006\u0010>\u001a\u00020\tH\u0016J*\u0010?\u001a\u001c\u0012\b\u0012\u00060\u000ej\u0002`@\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\u0016j\u0002`\u00170\u001c2\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\tH\u0017J(\u0010D\u001a\u00020B2\n\u00108\u001a\u00060\u000ej\u0002`92\u0006\u0010>\u001a\u00020\t2\n\u0010E\u001a\u00060\u000ej\u0002`9H\u0016\u00a8\u0006F"}, d2={"Lmod/lucky/forge/ForgeJavaGameAPI;", "Lmod/lucky/java/JavaGameAPI;", "()V", "attrToNBT", "Lnet/minecraft/nbt/Tag;", "Lmod/lucky/forge/Tag;", "attr", "Lmod/lucky/common/attribute/Attr;", "convertLegacyItemId", "", "id", "", "data", "findEntityByUUID", "", "Lmod/lucky/common/Entity;", "world", "Lmod/lucky/common/World;", "uuid", "generateChestLoot", "Lmod/lucky/common/attribute/ListAttr;", "pos", "Lmod/lucky/common/Vec3;", "Lmod/lucky/common/Vec3i;", "lootTableId", "random", "Lmod/lucky/common/Random;", "getArrowPosAndVelocity", "Lmod/lucky/kotlin/Pair;", "", "Lmod/lucky/common/Vec3d;", "player", "Lmod/lucky/common/PlayerEntity;", "bowPower", "yawOffsetDeg", "pitchOffsetDeg", "getBlockId", "block", "Lmod/lucky/common/Block;", "getEntityTypeId", "entity", "getEntityUUID", "getEntityVelocity", "getGameDir", "Ljava/io/File;", "getItemId", "item", "Lmod/lucky/common/Item;", "getLoaderName", "getMinecraftVersion", "getModVersion", "hasSilkTouch", "", "isCreativeMode", "isValidItemId", "nbtToAttr", "tag", "Lmod/lucky/java/NBTTag;", "readCompressedNBT", "stream", "Ljava/io/InputStream;", "readNBTKey", "k", "readNbtStructure", "Lmod/lucky/java/MinecraftNbtStructure;", "showClientMessage", "", "textJsonStr", "writeNBTKey", "v", "lucky-block"})
public final class ForgeJavaGameAPI
implements JavaGameAPI {
    @NotNull
    public static final ForgeJavaGameAPI INSTANCE = new ForgeJavaGameAPI();

    private ForgeJavaGameAPI() {
    }

    @Override
    @NotNull
    public String getLoaderName() {
        return "forge";
    }

    @Override
    @NotNull
    public String getModVersion() {
        return ForgeLuckyRegistry.INSTANCE.getModVersion();
    }

    @Override
    @NotNull
    public String getMinecraftVersion() {
        String string = MCPVersion.getMCVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getMCVersion()");
        return string;
    }

    @Override
    @NotNull
    public File getGameDir() {
        File file = FMLLoader.getGamePath().toFile();
        Intrinsics.checkNotNullExpressionValue(file, "getGamePath().toFile()");
        return file;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Tag attrToNBT(@NotNull Attr attr) {
        Tag tag;
        Intrinsics.checkNotNullParameter(attr, "attr");
        Attr attr2 = attr;
        if (attr2 instanceof ValueAttr) {
            Tag tag2 = switch (WhenMappings.$EnumSwitchMapping$0[attr.getType().ordinal()]) {
                case 1 -> (Tag)StringTag.m_129297_((String)((String)((ValueAttr)attr).getValue()));
                case 2 -> (Tag)ByteTag.m_128266_((byte)((Byte)((ValueAttr)attr).getValue()));
                case 3 -> (Tag)ByteTag.m_128273_((boolean)Intrinsics.areEqual(((ValueAttr)attr).getValue(), true));
                case 4 -> (Tag)ShortTag.m_129258_((short)((Short)((ValueAttr)attr).getValue()));
                case 5 -> (Tag)IntTag.m_128679_((int)((Integer)((ValueAttr)attr).getValue()));
                case 6 -> (Tag)LongTag.m_128882_((long)((Long)((ValueAttr)attr).getValue()));
                case 7 -> (Tag)FloatTag.m_128566_((float)((Float)((ValueAttr)attr).getValue()).floatValue());
                case 8 -> (Tag)DoubleTag.m_128500_((double)((Double)((ValueAttr)attr).getValue()));
                case 9 -> (Tag)new IntArrayTag((int[])((ValueAttr)attr).getValue());
                case 10 -> (Tag)new ByteArrayTag((byte[])((ValueAttr)attr).getValue());
                case 11 -> (Tag)new LongArrayTag((long[])((ValueAttr)attr).getValue());
                case 12, 13 -> throw new Exception();
                default -> throw new NoWhenBranchMatchedException();
            };
            Intrinsics.checkNotNullExpressionValue(tag2, "when (attr.type) {\n     \u2026Exception()\n            }");
            tag = tag2;
        } else if (attr2 instanceof ListAttr) {
            ListTag listTag = new ListTag();
            Iterable $this$forEach$iv = ((ListAttr)attr).getChildren();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Attr it = (Attr)element$iv;
                boolean bl = false;
                listTag.add((Object)INSTANCE.attrToNBT(it));
            }
            tag = (Tag)listTag;
        } else if (attr2 instanceof DictAttr) {
            void var3_5;
            CompoundTag dictTag = new CompoundTag();
            Map<String, Attr> $this$forEach$iv = ((DictAttr)attr).getChildren();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Attr>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, Attr> element$iv;
                Map.Entry<String, Attr> entry = element$iv = iterator2.next();
                boolean bl = false;
                String k = entry.getKey();
                Attr v = entry.getValue();
                dictTag.m_128365_(k, INSTANCE.attrToNBT(v));
            }
            tag = (Tag)var3_5;
        } else {
            throw new Exception();
        }
        return tag;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Attr nbtToAttr(@NotNull Object tag) {
        Attr attr;
        Intrinsics.checkNotNullParameter(tag, "tag");
        Object object = tag;
        if (object instanceof StringTag) {
            String string = ((StringTag)tag).m_7916_();
            Intrinsics.checkNotNullExpressionValue(string, "tag.asString");
            attr = AttributeKt.stringAttrOf(string);
        } else if (object instanceof ByteTag) {
            attr = new ValueAttr(AttrType.BYTE, ((ByteTag)tag).m_7063_(), false, 4, null);
        } else if (object instanceof ShortTag) {
            attr = new ValueAttr(AttrType.SHORT, ((ShortTag)tag).m_7053_(), false, 4, null);
        } else if (object instanceof IntTag) {
            attr = new ValueAttr(AttrType.INT, ((IntTag)tag).m_7047_(), false, 4, null);
        } else if (object instanceof LongTag) {
            attr = new ValueAttr(AttrType.LONG, ((LongTag)tag).m_7046_(), false, 4, null);
        } else if (object instanceof FloatTag) {
            attr = new ValueAttr(AttrType.FLOAT, Float.valueOf(((FloatTag)tag).m_7057_()), false, 4, null);
        } else if (object instanceof DoubleTag) {
            attr = new ValueAttr(AttrType.DOUBLE, ((DoubleTag)tag).m_7061_(), false, 4, null);
        } else if (object instanceof ByteArrayTag) {
            byte[] byArray = ((ByteArrayTag)tag).m_128227_();
            Intrinsics.checkNotNullExpressionValue(byArray, "tag.asByteArray");
            attr = new ValueAttr(AttrType.BYTE_ARRAY, byArray, false, 4, null);
        } else if (object instanceof IntArrayTag) {
            int[] nArray = ((IntArrayTag)tag).m_128648_();
            Intrinsics.checkNotNullExpressionValue(nArray, "tag.asIntArray");
            attr = new ValueAttr(AttrType.INT_ARRAY, nArray, false, 4, null);
        } else if (object instanceof LongArrayTag) {
            long[] lArray = ((LongArrayTag)tag).m_128851_();
            Intrinsics.checkNotNullExpressionValue(lArray, "tag.asLongArray");
            attr = new ValueAttr(AttrType.INT_ARRAY, lArray, false, 4, null);
        } else if (object instanceof ListTag) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)tag;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Tag tag2 = (Tag)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                collection.add(INSTANCE.nbtToAttr(it));
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 6;
            boolean bl = false;
            AttrType attrType = null;
            List list = (List)destination$iv$iv;
            attr = new ListAttr(list, attrType, bl, n, defaultConstructorMarker);
        } else if (object instanceof CompoundTag) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Set set = ((CompoundTag)tag).m_128431_();
            Intrinsics.checkNotNullExpressionValue(set, "tag.allKeys");
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Attr attr2;
                void it;
                String bl = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                void v6 = it;
                if (((CompoundTag)tag).m_128423_((String)it) != null) {
                    void v;
                    void var14_29 = v6;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue(v, "v");
                    attr2 = INSTANCE.nbtToAttr(v);
                    v6 = var14_29;
                } else {
                    attr2 = null;
                }
                collection.add(TuplesKt.to(v6, attr2));
            }
            $this$map$iv = (List)destination$iv$iv2;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
            if (pairArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            Pair[] pairArray2 = pairArray;
            attr = AttributeKt.dictAttrOf(Arrays.copyOf(pairArray2, pairArray2.length));
        } else {
            throw new Exception();
        }
        return attr;
    }

    @Override
    @Nullable
    public Object readNBTKey(@NotNull Object tag, @NotNull String k) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(k, "k");
        return ((CompoundTag)tag).m_128423_(k);
    }

    @Override
    public void writeNBTKey(@NotNull Object tag, @NotNull String k, @NotNull Object v) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(k, "k");
        Intrinsics.checkNotNullParameter(v, "v");
        ((CompoundTag)tag).m_128365_(k, (Tag)v);
    }

    @Override
    @NotNull
    public Attr readCompressedNBT(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        CompoundTag nbt = NbtIo.m_128939_((InputStream)stream);
        Intrinsics.checkNotNullExpressionValue(nbt, "nbt");
        return this.nbtToAttr(nbt);
    }

    @Override
    @NotNull
    public Pair<mod.lucky.common.Vec3<Double>, mod.lucky.common.Vec3<Double>> getArrowPosAndVelocity(@NotNull Object world, @NotNull Object player, double bowPower, double yawOffsetDeg, double pitchOffsetDeg) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(player, "player");
        Arrow arrowEntity = new Arrow((Level)((ServerLevel)world), (LivingEntity)((Player)player));
        arrowEntity.m_37251_((Entity)player, (float)(GameAPIKt.getGAME_API().getPlayerHeadPitchDeg(player) + yawOffsetDeg), (float)(GameAPIKt.getGAME_API().getPlayerHeadYawDeg(player) + pitchOffsetDeg), 0.0f, (float)(bowPower * 3.0), 1.0f);
        return new Pair<mod.lucky.common.Vec3<Double>, mod.lucky.common.Vec3<Double>>(GameAPIKt.getGAME_API().getEntityPos(arrowEntity), new mod.lucky.common.Vec3<Number>(arrowEntity.m_20184_().f_82479_, arrowEntity.m_20184_().f_82480_, arrowEntity.m_20184_().f_82481_));
    }

    @Override
    @NotNull
    public mod.lucky.common.Vec3<Double> getEntityVelocity(@NotNull Object entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        Vec3 vec3 = ((Entity)entity).m_20184_();
        Intrinsics.checkNotNullExpressionValue(vec3, "entity as MCEntity).deltaMovement");
        return ForgeGameAPIKt.toVec3d(vec3);
    }

    @Override
    @NotNull
    public String getEntityUUID(@NotNull Object entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        String string = ((Entity)entity).m_142081_().toString();
        Intrinsics.checkNotNullExpressionValue(string, "entity as MCEntity).uuid.toString()");
        return string;
    }

    @Override
    @Nullable
    public Object findEntityByUUID(@NotNull Object world, @NotNull String uuid) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return ((ServerLevel)world).m_8791_(UUID.fromString(uuid));
    }

    @Override
    @OnlyInClient
    public void showClientMessage(@NotNull String textJsonStr) {
        block1: {
            Intrinsics.checkNotNullParameter(textJsonStr, "textJsonStr");
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            MutableComponent mcText = Component.Serializer.m_130701_((String)textJsonStr);
            if (mcText == null) {
                Logger.DefaultImpls.logError$default(GameAPIKt.getGAME_API(), "Invalid JSON text: " + textJsonStr, null, 2, null);
                return;
            }
            LocalPlayer localPlayer = player;
            if (localPlayer == null) break block1;
            localPlayer.m_6352_((Component)mcText, UUID.fromString(this.getEntityUUID(player)));
        }
    }

    @Override
    @Nullable
    public String getBlockId(@NotNull Object block) {
        Intrinsics.checkNotNullParameter(block, "block");
        ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)((Block)block));
        return resourceLocation != null ? resourceLocation.toString() : null;
    }

    @Override
    @Nullable
    public String getItemId(@NotNull Object item) {
        Intrinsics.checkNotNullParameter(item, "item");
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)((Item)item));
        return resourceLocation != null ? resourceLocation.toString() : null;
    }

    @Override
    public boolean isValidItemId(@NotNull String id) {
        Intrinsics.checkNotNullParameter(id, "id");
        return ForgeRegistries.ITEMS.containsKey(new ResourceLocation(id));
    }

    @Override
    @NotNull
    public String getEntityTypeId(@NotNull Object entity) {
        ResourceLocation key;
        Intrinsics.checkNotNullParameter(entity, "entity");
        ResourceLocation resourceLocation = key = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)((Entity)entity).m_6095_());
        String string = resourceLocation != null ? resourceLocation.toString() : null;
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @NotNull
    public ListAttr generateChestLoot(@NotNull Object world, @NotNull mod.lucky.common.Vec3<Integer> pos, @NotNull String lootTableId, @NotNull Random random) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(lootTableId, "lootTableId");
        Intrinsics.checkNotNullParameter(random, "random");
        ChestBlockEntity chestEntity = new ChestBlockEntity(ForgeGameAPIKt.toMCBlockPos(pos), Blocks.f_50087_.m_49966_());
        chestEntity.m_142339_((Level)ForgeGameAPIKt.toServerWorld(world));
        chestEntity.m_59626_(new ResourceLocation(lootTableId), (long)random.randInt(new IntRange(0, Integer.MAX_VALUE)));
        chestEntity.m_59640_(null);
        CompoundTag tag = chestEntity.m_187480_();
        JavaGameAPI javaGameAPI = JavaGameAPIKt.getJAVA_GAME_API();
        JavaGameAPI javaGameAPI2 = JavaGameAPIKt.getJAVA_GAME_API();
        Intrinsics.checkNotNullExpressionValue(tag, "tag");
        Object object = javaGameAPI2.readNBTKey(tag, "Items");
        Intrinsics.checkNotNull(object);
        return (ListAttr)javaGameAPI.nbtToAttr(object);
    }

    @Override
    public boolean isCreativeMode(@NotNull Object player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return ((Player)player).m_7500_();
    }

    @Override
    public boolean hasSilkTouch(@NotNull Object player) {
        Intrinsics.checkNotNullParameter(player, "player");
        return EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44985_, (LivingEntity)((LivingEntity)((Player)player))) > 0;
    }

    @Override
    @Nullable
    public String convertLegacyItemId(int id, int data) {
        String string = ItemIdFix.m_15942_((int)id);
        Intrinsics.checkNotNullExpressionValue(string, "getItem(id)");
        String legacyName = string;
        if (Intrinsics.areEqual(legacyName, "minecraft:air") && id > 0) {
            return null;
        }
        String string2 = ItemStackTheFlatteningFix.m_16122_((String)legacyName, (int)data);
        if (string2 == null) {
            string2 = legacyName;
        }
        return string2;
    }

    @Override
    @NotNull
    public Pair<Object, mod.lucky.common.Vec3<Integer>> readNbtStructure(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        StructureTemplate structure = new StructureTemplate();
        structure.m_74638_(NbtIo.m_128939_((InputStream)stream));
        Vec3i vec3i = structure.m_163801_();
        Intrinsics.checkNotNullExpressionValue(vec3i, "structure.size");
        return new Pair<StructureTemplate, mod.lucky.common.Vec3<Integer>>(structure, ForgeGameAPIKt.toVec3i(vec3i));
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AttrType.values().length];
            nArray[AttrType.STRING.ordinal()] = 1;
            nArray[AttrType.BYTE.ordinal()] = 2;
            nArray[AttrType.BOOLEAN.ordinal()] = 3;
            nArray[AttrType.SHORT.ordinal()] = 4;
            nArray[AttrType.INT.ordinal()] = 5;
            nArray[AttrType.LONG.ordinal()] = 6;
            nArray[AttrType.FLOAT.ordinal()] = 7;
            nArray[AttrType.DOUBLE.ordinal()] = 8;
            nArray[AttrType.INT_ARRAY.ordinal()] = 9;
            nArray[AttrType.BYTE_ARRAY.ordinal()] = 10;
            nArray[AttrType.LONG_ARRAY.ordinal()] = 11;
            nArray[AttrType.LIST.ordinal()] = 12;
            nArray[AttrType.DICT.ordinal()] = 13;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

