/*
 * Decompiled with CFR 0.152.
 */
package lykrast.meetyourfight.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import lykrast.meetyourfight.MeetYourFight;
import lykrast.meetyourfight.entity.BossEntity;
import lykrast.meetyourfight.entity.ProjectileLineEntity;
import lykrast.meetyourfight.entity.ai.VexMoveRandomGoal;
import lykrast.meetyourfight.entity.movement.VexMovementController;
import lykrast.meetyourfight.registry.ModEntities;
import lykrast.meetyourfight.registry.ModSounds;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BellringerEntity
extends BossEntity {
    public int attackCooldown;
    private int rageAttacks = 0;

    public BellringerEntity(EntityType<? extends BellringerEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new VexMovementController((MobEntity)this);
        this.field_70728_aV = 50;
    }

    public void func_213315_a(MoverType typeIn, Vector3d pos) {
        super.func_213315_a(typeIn, pos);
        this.func_145775_I();
    }

    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new RageAttack(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BurstAttack(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new MoveFrontOfTarget((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new VexMoveRandomGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233819_b_, 64.0);
    }

    public static void spawn(PlayerEntity player, World world) {
        Random rand = player.func_70681_au();
        BellringerEntity bellringer = (BellringerEntity)ModEntities.BELLRINGER.func_200721_a(world);
        bellringer.func_70012_b(player.func_226277_ct_() + (double)rand.nextInt(15) - 7.0, player.func_226278_cu_() + (double)rand.nextInt(9) - 1.0, player.func_226281_cx_() + (double)rand.nextInt(15) - 7.0, rand.nextFloat() * 360.0f - 180.0f, 0.0f);
        bellringer.attackCooldown = 100;
        if (!player.field_71075_bZ.field_75098_d) {
            bellringer.func_70624_b((LivingEntity)player);
        }
        bellringer.func_195064_c(new EffectInstance(Effects.field_76429_m, 100, 2));
        bellringer.func_213386_a((IServerWorld)((ServerWorld)world), world.func_175649_E(bellringer.func_233580_cy_()), SpawnReason.EVENT, null, null);
        world.func_217376_c((Entity)bellringer);
        world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_219603_Y, SoundCategory.PLAYERS, 2.0f, 1.0f);
    }

    @Override
    public void func_70619_bc() {
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        super.func_70619_bc();
    }

    private void dingDong() {
        this.func_184609_a(Hand.MAIN_HAND);
        this.func_184185_a(SoundEvents.field_219603_Y, 2.0f, 1.0f);
    }

    private ProjectileLineEntity readyAttack() {
        ProjectileLineEntity ghost = new ProjectileLineEntity(this.field_70170_p, (LivingEntity)this, 0.0, 0.0, 0.0);
        ghost.func_212361_a((Entity)this);
        ghost.func_70107_b(this.func_226277_ct_() - 2.0 + this.field_70146_Z.nextDouble() * 4.0, this.func_226278_cu_() - 2.0 + this.field_70146_Z.nextDouble() * 4.0, this.func_226281_cx_() - 2.0 + this.field_70146_Z.nextDouble() * 4.0);
        ghost.setVariant(0);
        return ghost;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("AttackCooldown")) {
            this.attackCooldown = compound.func_74762_e("AttackCooldown");
        }
        this.rageAttacks = compound.func_74762_e("Rage");
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("AttackCooldown", this.attackCooldown);
        compound.func_74768_a("Rage", this.rageAttacks);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.bellringerIdle;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.bellringerHurt;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.bellringerDeath;
    }

    @Override
    protected SoundEvent getMusic() {
        return ModSounds.musicBellringer;
    }

    protected ResourceLocation func_184647_J() {
        return MeetYourFight.rl("bellringer");
    }

    public float func_70013_c() {
        return 1.0f;
    }

    private static class MoveFrontOfTarget
    extends Goal {
        private MobEntity mob;
        private int moveCooldown;

        public MoveFrontOfTarget(MobEntity mob) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.mob = mob;
        }

        public boolean func_75250_a() {
            return this.mob.func_70638_az() != null && !this.mob.func_70605_aq().func_75640_a();
        }

        public void func_75249_e() {
            this.moveCooldown = 20;
            LivingEntity target = this.mob.func_70638_az();
            BlockPos targetP = target.func_233580_cy_();
            Vector3d look = Vector3d.func_189986_a((float)0.0f, (float)target.field_70177_z);
            this.mob.func_70605_aq().func_75642_a((double)targetP.func_177958_n() + look.field_72450_a * 4.0 - 0.5 + this.mob.func_70681_au().nextDouble() * 2.0, (double)(targetP.func_177956_o() + 2) + this.mob.func_70681_au().nextDouble() * 2.0, (double)targetP.func_177952_p() + look.field_72449_c * 4.0 - 0.5 + this.mob.func_70681_au().nextDouble() * 2.0, 1.0);
        }

        public boolean func_75253_b() {
            return this.moveCooldown > 0;
        }

        public void func_75246_d() {
            --this.moveCooldown;
        }
    }

    private static class RageAttack
    extends Goal {
        private BellringerEntity ringer;
        private LivingEntity target;
        private int attackRemaining;
        private int attackDelay;
        private Direction dir;

        public RageAttack(BellringerEntity ringer) {
            this.ringer = ringer;
        }

        public boolean func_75250_a() {
            return this.ringer.attackCooldown <= 0 && this.ringer.rageAttacks == 0 && this.ringer.func_110143_aJ() <= this.ringer.func_110138_aP() / 2.0f && this.ringer.func_70638_az() != null && this.ringer.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            this.ringer.attackCooldown = 2;
            this.ringer.rageAttacks = 1;
            this.attackDelay = 30;
            this.attackRemaining = 20;
            this.target = this.ringer.func_70638_az();
            BlockPos self = this.ringer.func_233580_cy_();
            double sx = self.func_177958_n();
            double sz = self.func_177952_p();
            BlockPos tgt = this.target.func_233580_cy_();
            double tx = tgt.func_177958_n();
            double tz = tgt.func_177952_p();
            this.dir = Direction.func_210769_a((double)(tx - sx), (double)0.0, (double)(tz - sz));
            List list = this.ringer.field_70170_p.func_175674_a((Entity)this.ringer, this.ringer.func_174813_aQ().func_186662_g(16.0), e -> e instanceof LivingEntity && e.func_70089_S() && e.func_184222_aU());
            list.add(this.target);
            for (Entity e2 : list) {
                ((LivingEntity)e2).func_195064_c(new EffectInstance(Effects.field_76421_d, 300, 1));
            }
            this.ringer.dingDong();
            this.ringer.func_184185_a(SoundEvents.field_219604_Z, 2.0f, 1.0f);
        }

        public void func_75246_d() {
            this.ringer.attackCooldown = 2;
            --this.attackDelay;
            if (this.attackDelay <= 0) {
                this.attackDelay = 12;
                --this.attackRemaining;
                this.ringer.dingDong();
                BlockPos tgt = this.target.func_233580_cy_();
                double tx = (double)tgt.func_177958_n() + 0.5;
                double tz = (double)tgt.func_177952_p() + 0.5;
                double ty = (double)tgt.func_177956_o() + 0.1;
                if (!(this.target.func_233570_aj_() || this.target.func_70090_H() || this.ringer.field_70170_p.func_180495_p(tgt.func_177977_b()).func_185904_a().func_76230_c())) {
                    ty -= 1.0;
                }
                double cx = this.dir.func_82601_c();
                double cz = this.dir.func_82599_e();
                int off = this.attackRemaining % 2 == 0 ? 1 : -1;
                for (int i = -5; i <= 5; ++i) {
                    ProjectileLineEntity ghost = this.ringer.readyAttack();
                    ghost.setUp(15 + off * i, cx, 0.0, cz, tx - 7.0 * cx + (double)i * cz, ty, tz - 7.0 * cz + (double)i * cx);
                    this.ringer.field_70170_p.func_217376_c((Entity)ghost);
                }
                if (this.attackRemaining <= 0) {
                    this.func_75251_c();
                }
            }
        }

        public void func_75251_c() {
            this.ringer.attackCooldown = 40 + this.ringer.field_70146_Z.nextInt(21);
        }

        public boolean func_75253_b() {
            return this.attackRemaining > 0 && this.target.func_70089_S();
        }
    }

    private static class BurstAttack
    extends Goal {
        private BellringerEntity ringer;
        private LivingEntity target;
        private int attackRemaining;
        private int attackDelay;
        private int chosenAttack;

        public BurstAttack(BellringerEntity ringer) {
            this.ringer = ringer;
        }

        public boolean func_75250_a() {
            return this.ringer.attackCooldown <= 0 && this.ringer.func_70638_az() != null && this.ringer.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            this.ringer.attackCooldown = 2;
            this.attackDelay = 20;
            this.attackRemaining = 3 + this.ringer.rageAttacks;
            this.target = this.ringer.func_70638_az();
            this.chosenAttack = this.ringer.field_70146_Z.nextInt(2);
        }

        public void func_75246_d() {
            this.ringer.attackCooldown = 2;
            --this.attackDelay;
            if (this.attackDelay <= 0) {
                this.attackDelay = 20;
                --this.attackRemaining;
                this.ringer.dingDong();
                this.performAttack();
                if (this.attackRemaining <= 0) {
                    this.func_75251_c();
                }
            }
        }

        private void performAttack() {
            BlockPos tgt = this.target.func_233580_cy_();
            double tx = (double)tgt.func_177958_n() + 0.5;
            double tz = (double)tgt.func_177952_p() + 0.5;
            double ty = (double)tgt.func_177956_o() + 0.1;
            if (!(this.target.func_233570_aj_() || this.target.func_70090_H() || this.ringer.field_70170_p.func_180495_p(tgt.func_177977_b()).func_185904_a().func_76230_c())) {
                ty -= 1.0;
            }
            switch (this.chosenAttack) {
                default: {
                    BlockPos self = this.ringer.func_233580_cy_();
                    double sx = self.func_177958_n();
                    double sz = self.func_177952_p();
                    Direction dir = Direction.func_210769_a((double)(tx - sx), (double)0.0, (double)(tz - sz));
                    double cx = dir.func_82601_c();
                    double cz = dir.func_82599_e();
                    for (int i = -4; i <= 4; ++i) {
                        ProjectileLineEntity ghost = this.ringer.readyAttack();
                        ghost.setUp(20, cx, 0.0, cz, tx - 7.0 * cx + (double)i * cz, ty, tz - 7.0 * cz + (double)i * cx);
                        this.ringer.field_70170_p.func_217376_c((Entity)ghost);
                    }
                    break;
                }
                case 1: {
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            ProjectileLineEntity ghost = this.ringer.readyAttack();
                            ghost.setUp(20, 0.0, -1.0, 0.0, tx + (double)x, ty + 7.0, tz + (double)z);
                            this.ringer.field_70170_p.func_217376_c((Entity)ghost);
                        }
                    }
                }
            }
        }

        public void func_75251_c() {
            this.ringer.attackCooldown = 40 + this.ringer.field_70146_Z.nextInt(21);
        }

        public boolean func_75253_b() {
            return this.attackRemaining > 0 && this.target.func_70089_S();
        }
    }
}

